/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.gui.tree;

import ch.e2e.builder.analyzer.Analyzer;
import ch.e2e.builder.trace.gui.model.TreeModel;
import ch.e2e.swing.Tree;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableBar;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.TreeSearchable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public abstract class TreeView<E>
extends JPanel {
    private final Analyzer analyzer;
    private Tree tree;

    protected TreeView(E root, Analyzer analyzer) {
        super(new BorderLayout());
        this.analyzer = analyzer;
        this.createGui(root);
        this.addEventHandler();
    }

    public abstract void refreshTree(EventObject var1);

    protected abstract Tree createTree(E var1);

    protected abstract void addEventHandler();

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    public TreeModel getModel() {
        return (TreeModel)this.getTree().getModel();
    }

    public TreePath getSelectionPath() {
        return this.getTree().getSelectionPath();
    }

    public void setSelectionPath(TreePath path) {
        this.getTree().setSelectionPath(path);
        if (path == null) {
            this.clearSelection();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getTree().setEnabled(enabled);
        if (enabled) {
            this.getModel().refresh();
        }
    }

    public void expandPath(TreePath path) {
        this.getTree().expandPath(path);
    }

    public void clearSelection() {
    }

    protected JComponent createSearchPanel() {
        return null;
    }

    private void createGui(E root) {
        this.tree = this.createTree(root);
        this.tree.addTreeSelectionListener((TreeSelectionListener)this.getAnalyzer());
        JScrollPane pane = new JScrollPane((Component)this.tree, 20, 30);
        this.add((Component)pane, "Center");
        this.add((Component)this.createSearchableBar(), "South");
    }

    private SearchableBar createSearchableBar() {
        TreeSearchable searchable = SearchableUtils.installSearchable((JTree)this.tree);
        searchable.setRecursive(true);
        searchable.setCaseSensitive(false);
        searchable.setFromStart(false);
        searchable.setRepeats(true);
        SearchableBar searchableBar = SearchableBar.install((Searchable)searchable, (KeyStroke)KeyStroke.getKeyStroke(70, 128), (SearchableBar.Installer)new SearchableBar.Installer(){

            public void openSearchBar(SearchableBar searchableBar) {
                searchableBar.setVisible(true);
            }

            public void closeSearchBar(SearchableBar searchableBar) {
                searchableBar.setVisible(false);
            }
        });
        searchableBar.setCompact(true);
        Dimension minSize = searchableBar.getMinimumSize();
        searchableBar.setMinimumSize(new Dimension(5, minSize.height));
        return searchableBar;
    }
}

