/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.util;

import ch.e2e.util.ComparableVersion;

public class VersionChecker {
    public static boolean isNewer(String oldVersion, String newVersion) {
        if (oldVersion.trim().equals(newVersion.trim())) {
            return false;
        }
        return VersionChecker.checkVersion(oldVersion, newVersion);
    }

    public static boolean checkMajorVersion(String minimumVersion, String actualVersion) {
        return VersionChecker.checkVersion(new ComparableVersion(minimumVersion).getMajorVersion(), new ComparableVersion(actualVersion).getMajorVersion());
    }

    public static boolean checkMajorMinorVersion(String minimumVersion, String actualVersion) {
        return VersionChecker.checkVersion(new ComparableVersion(minimumVersion).getMajorMinorVersion(), new ComparableVersion(actualVersion).getMajorMinorVersion());
    }

    public static boolean checkVersion(String minimumVersion) {
        return VersionChecker.checkVersion(minimumVersion, System.getProperty("java.version"));
    }

    public static boolean checkVersion(String minimumVersion, String actualVersion) {
        return VersionChecker.checkVersion(new ComparableVersion(minimumVersion), new ComparableVersion(actualVersion));
    }

    private static boolean checkVersion(ComparableVersion minimumVersion, ComparableVersion actualVersion) {
        return actualVersion.compareTo(minimumVersion) >= 0;
    }
}

