/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class CalendarUtilities {
    public static final SimpleDateFormat DATE_FORMAT_ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    public static final long MILLISECONDS_PER_SECOND = 1000L;
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    public static final long MILLISECONDS_PER_HOUR = 3600000L;
    public static final long MILLISECONDS_PER_DAY = 86400000L;

    private CalendarUtilities() {
    }

    public static long getDay(Date date) {
        Calendar c = null;
        if (date != null) {
            c = Calendar.getInstance();
            c.setTime(date);
        }
        return CalendarUtilities.getDay(c);
    }

    public static long getDay(Calendar date) {
        return date == null ? -1L : (long)Math.floor((double)(date.getTimeInMillis() + CalendarUtilities.getOffset(date)) / 8.64E7);
    }

    public static long getDayDifference(Date start, Date end) throws IllegalArgumentException {
        if (start == null) {
            throw new IllegalArgumentException("Argument 'start' must not be NULL");
        }
        if (end == null) {
            throw new IllegalArgumentException("Argument 'end' must not be NULL");
        }
        return CalendarUtilities.getDay(end) - CalendarUtilities.getDay(start);
    }

    public static long getDayDifference(Calendar start, Calendar end) throws IllegalArgumentException {
        if (start == null) {
            throw new IllegalArgumentException("Argument 'start' must not be NULL");
        }
        if (end == null) {
            throw new IllegalArgumentException("Argument 'end' must not be NULL");
        }
        return CalendarUtilities.getDay(end) - CalendarUtilities.getDay(start);
    }

    public static long getDayPeriods(Date start, Date end) throws IllegalArgumentException {
        if (start == null) {
            throw new IllegalArgumentException("Argument 'start' must not be NULL");
        }
        if (end == null) {
            throw new IllegalArgumentException("Argument 'end' must not be NULL");
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(start);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(end);
        return CalendarUtilities.getDayPeriods(startCal, endCal);
    }

    public static long getDayPeriods(Calendar start, Calendar end) throws IllegalArgumentException {
        if (start == null) {
            throw new IllegalArgumentException("Argument 'start' must not be NULL");
        }
        if (end == null) {
            throw new IllegalArgumentException("Argument 'end' must not be NULL");
        }
        return (end.getTimeInMillis() + CalendarUtilities.getOffset(end) - start.getTimeInMillis() - CalendarUtilities.getOffset(start)) / 86400000L;
    }

    public static Date parseISO8601(String date) throws ParseException {
        return DATE_FORMAT_ISO_8601.parse(date);
    }

    public static String toISO8601(Date date) {
        return date == null ? "" : DATE_FORMAT_ISO_8601.format(date);
    }

    public static String toISO8601(Calendar date) {
        return date == null ? "" : CalendarUtilities.toISO8601(date.getTime());
    }

    private static long getOffset(Calendar date) {
        return date.getTimeZone().getOffset(date.getTimeInMillis());
    }
}

