/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.transformer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class E2EURIResolver
implements URIResolver {
    private URIResolver originalResolver;

    public E2EURIResolver(URIResolver originalResolver) {
        this.originalResolver = originalResolver;
    }

    @Override
    public Source resolve(String path, String base) throws TransformerException {
        Source result;
        URL url = null;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if ((base.startsWith("file:") || base.length() == 0) && (url == null || url.getProtocol().equals("file"))) {
            path = url == null ? path : url.getPath();
            File srcFile = new File(path);
            if (!srcFile.isAbsolute()) {
                File file = null;
                if (base.length() == 0) {
                    file = new File(base).getAbsoluteFile();
                } else {
                    if (base.startsWith("file:") && base.indexOf(":", 5) == -1 && !base.substring(5, 9).equals("////")) {
                        base = base.replace("file://", "file:////");
                    }
                    try {
                        URI uri = new URI(base);
                        file = new File(uri);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (URISyntaxException e) {
                        Source source = this.originalResolver.resolve(path, base);
                    }
                }
                if (file != null) {
                    srcFile = new File(file.getParentFile(), path);
                }
            }
            result = new StreamSource(srcFile);
        } else {
            result = this.originalResolver.resolve(path, base);
        }
        return result;
    }
}

