/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.resource;

import ch.e2e.resource.MultiMapProperties;
import ch.e2e.resource.Properties;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;

public class Translator {
    private Locale locale;
    private Properties translations;
    private Hashtable translationTables;
    private String properties;
    private ClassLoader classLoader;

    public Translator(Locale locale) {
        this(null, locale);
    }

    public Translator(String properties, Locale locale) {
        this(properties, locale, Translator.class.getClassLoader());
    }

    public Translator(String properties, ClassLoader classLoader) {
        this(properties, Locale.getDefault(), classLoader);
    }

    public Translator(Locale locale, ClassLoader classLoader) {
        this(null, locale, classLoader);
    }

    public Translator(String properties, Locale locale, ClassLoader classLoader) {
        this.locale = locale;
        this.properties = properties;
        this.classLoader = classLoader;
        this.translationTables = new Hashtable();
        try {
            this.translations = properties == null ? new Properties(locale, classLoader) : new MultiMapProperties(properties, "translation_maps", locale, classLoader);
            this.translationTables.put(this.translations.getLocale(), this.translations);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public void setLocale(Locale locale) {
        if (!this.locale.equals(locale)) {
            this.locale = locale;
            Iterator addedProperties = this.translations.getAddedProperties();
            Properties translations = (Properties)this.translationTables.get(locale);
            if (translations == null) {
                try {
                    translations = new MultiMapProperties(this.properties, "translation_maps", locale, this.classLoader);
                }
                catch (MissingResourceException mrEx) {
                    translations = new Properties(this.properties, locale);
                }
                this.translationTables.put(translations.getLocale(), translations);
            }
            this.translations = translations;
            while (addedProperties.hasNext()) {
                this.addMap((String)addedProperties.next());
            }
        }
    }

    public String getTranslation(String key) {
        String result = null;
        if (this.translations != null) {
            try {
                result = this.translations.getString(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public String getTranslation(String key, String defaultTranslation) {
        if (this.translations != null) {
            try {
                return this.translations.getString(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultTranslation;
    }

    public String[] getTranslatedArray(String key) {
        if (this.translations != null) {
            try {
                return this.translations.getStringArray(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String[] getTranslation(String key, String[] defaultTranslation) {
        if (this.translations != null) {
            try {
                return this.translations.getStringArray(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultTranslation;
    }

    public String[] getTranslation(String[] keys) {
        String[] translatedStrings = new String[keys.length];
        if (this.translations != null) {
            for (int i = 0; i < keys.length; ++i) {
                translatedStrings[i] = this.translations.getString(keys[i], keys[i]);
            }
            return translatedStrings;
        }
        return keys;
    }

    public String[] getTranslation(String[] keys, String[] defaultTranslation) {
        String[] translatedStrings = new String[keys.length];
        if (this.translations != null) {
            for (int i = 0; i < keys.length; ++i) {
                translatedStrings[i] = this.translations.getString(keys[i], keys[i]);
            }
            return translatedStrings;
        }
        return defaultTranslation;
    }

    public void addMap(String name) {
        Enumeration tables = this.translationTables.elements();
        if (tables.hasMoreElements()) {
            while (tables.hasMoreElements()) {
                Properties translationTable = (Properties)tables.nextElement();
                if (translationTable.containsProperties(name)) continue;
                translationTable.addProperties(new MultiMapProperties(name, "translation_maps", translationTable.getLocale(), this.classLoader));
            }
        } else if (!this.translations.containsProperties(name)) {
            this.translations = new MultiMapProperties(name, "translation_maps", this.locale, this.classLoader);
            this.translationTables.put(this.locale, this.translations);
        }
    }

    public void addTranslation(String key, String value) {
        this.translations.setProperty(key, value);
    }

    public void addTranslation(String key, String value, Locale locale) {
        Properties translations = (Properties)this.translationTables.get(locale);
        translations.setProperty(key, value);
    }

    public Properties getTranslations() {
        return this.translations;
    }
}

