/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.net;

import ch.e2e.net.FileObject;
import ch.e2e.net.FileServerConstants;
import ch.e2e.net.FileServerOutput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileServerOutputStream
implements FileServerConstants {
    private OutputStream out;
    private FileServerOutput output;

    public FileServerOutputStream(OutputStream out, FileServerOutput logger) throws IOException {
        this.out = out;
        this.output = logger;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void writeObject(Object obj) throws IOException {
        if (obj instanceof FileObject) {
            this.writeObject((FileObject)obj);
        } else if (obj instanceof String) {
            this.writeObject((String)obj);
        } else {
            throw new IllegalArgumentException(obj.getClass().getName() + " not supported in FileServerOutputStream.writeObject");
        }
    }

    public void setOutput(FileServerOutput output) {
        this.output = output;
    }

    private void writeObject(FileObject file) throws IOException {
        if (this.output != null) {
            this.output.transferStart(file.getFilename());
        }
        this.writeProtocolLine("[FILENAME]");
        this.writeProtocolLine(file.getFilename());
        byte[] data = file.getData();
        this.writeData(data);
        if (this.output != null) {
            this.output.transferEnd(file.getFilename());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(byte[] data) throws IOException {
        this.writeProtocolLine("[CONTENT-LENGTH]");
        int contentLength = data.length;
        this.writeProtocolLine(String.valueOf(contentLength));
        byte[] buffer = new byte[4096];
        boolean dataMissing = true;
        int writtenBytes = 0;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        while (dataMissing) {
            ByteArrayInputStream byteArrayInputStream = in;
            synchronized (byteArrayInputStream) {
                OutputStream outputStream = this.out;
                synchronized (outputStream) {
                    int rest = contentLength - writtenBytes;
                    int bytes2Read = rest < 4096 ? rest : 4096;
                    int amountRead = in.read(buffer, 0, bytes2Read);
                    this.out.write(buffer, 0, amountRead);
                    writtenBytes += amountRead;
                    if (this.output != null) {
                        this.output.log(writtenBytes + " bytes of " + contentLength + " written");
                    }
                    dataMissing = writtenBytes < contentLength;
                }
            }
        }
        this.out.flush();
    }

    private void writeObject(String string) throws IOException {
        this.writeProtocolLine("[STRING]");
        this.writeData(string.getBytes());
    }

    void writeProtocolLine(String s) throws IOException {
        this.out.write(new String(s + '\n').getBytes());
    }
}

