/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.logging;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogWriter
extends Writer {
    private Logger logger;
    private Level level;
    private String className = "LogWriter";
    private String methodName = "";
    private StringBuffer buffer = new StringBuffer();

    public LogWriter(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
    }

    public LogWriter(Logger logger, Level level, String className, String methodName) {
        this(logger, level);
        this.className = className;
        this.methodName = methodName;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len <= 0 || off + len > cbuf.length || off + len < 0) {
            return;
        }
        this.buffer.append(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer.length() > 0 && this.logger.isLoggable(this.level)) {
            LogRecord record = new LogRecord(this.level, this.buffer.toString());
            record.setSourceClassName(this.className);
            record.setSourceMethodName(this.methodName);
            this.logger.log(record);
            this.buffer = new StringBuffer();
        }
    }

    @Override
    public void close() throws IOException {
    }
}

