/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.event;

import ch.e2e.event.DefaultExceptionHandler;
import ch.e2e.event.DefaultHandler;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecuterList;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.event.ExceptionHandler;
import ch.e2e.event.Logging;
import ch.e2e.event.RuntimeTargetException;
import java.util.EventObject;
import java.util.Hashtable;

public class EventController
implements Logging {
    private static EventController controller = new EventController();
    private DefaultHandler defaultHandler;
    private Hashtable<Class, EventExecuterList> eventExecuter = new Hashtable();
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();

    private EventController() {
    }

    public static void setDefaultHandler(DefaultHandler defaultHandler) {
        EventController.controller.defaultHandler = defaultHandler;
    }

    public static void register(EventExecuter executer, Class eventObject) {
        EventExecuterList executerList = EventController.controller.eventExecuter.get(eventObject);
        if (executerList == null) {
            executerList = new EventExecuterList();
            EventController.controller.eventExecuter.put(eventObject, executerList);
        }
        executerList.addExecuter(executer);
    }

    public static void registerSavely(EventExecuter executer, Class event) {
        EventExecuterList executerList = EventController.controller.eventExecuter.get(event);
        if (executerList == null) {
            executerList = new EventExecuterList();
            EventController.controller.eventExecuter.put(event, executerList);
        }
        if (!executerList.contains(executer)) {
            executerList.addExecuter(executer);
        }
    }

    public static void unregister(EventExecuter executer, EventObject event) {
        EventController.unregister(executer, event.getClass());
    }

    public static void unregister(EventExecuter executer, Class event) {
        EventExecuterList executerList = EventController.controller.eventExecuter.get(event);
        if (executerList != null) {
            executerList.removeExecuter(executer);
            if (executerList.size() == 0) {
                EventController.controller.eventExecuter.remove(event.getClass());
            }
        }
    }

    public static void unregisterSavely(EventExecuter executer, Class event) {
        EventExecuterList executerList = EventController.controller.eventExecuter.get(event);
        if (executerList != null && executerList.contains(executer)) {
            executerList.removeExecuter(executer);
            if (executerList.size() == 0) {
                EventController.controller.eventExecuter.remove(event.getClass());
            }
        }
    }

    public static void setExceptionHandler(ExceptionHandler exceptionHandler) {
        EventController.controller.exceptionHandler = exceptionHandler;
    }

    public static void fire(EventObject event) throws EventExecutionVetoException {
        EventExecuterList executerList;
        block9: {
            executerList = EventController.controller.eventExecuter.get(event.getClass());
            if (executerList == null) {
                executerList = new EventExecuterList();
                EventController.controller.eventExecuter.put(event.getClass(), executerList);
            }
            if (EventController.controller.defaultHandler != null) {
                try {
                    EventController.controller.defaultHandler.checkDefaultExecuter(event, executerList);
                }
                catch (RuntimeTargetException ex) {
                    logger.throwing(EventController.class.getName(), "fire", ex);
                    if (ex.getTargetException() == null) break block9;
                    System.err.println("caused by:\n");
                    logger.throwing(EventController.class.getName(), "fire", ex.getTargetException());
                }
            }
        }
        if (executerList.size() == 0) {
            EventController.controller.eventExecuter.remove(event.getClass());
        }
        try {
            executerList.execute(event);
        }
        catch (Throwable t) {
            if (t instanceof EventExecutionVetoException) {
                throw (EventExecutionVetoException)t;
            }
            t.printStackTrace();
            if (t instanceof RuntimeTargetException) {
                EventController.controller.exceptionHandler.doExceptionHandling((RuntimeTargetException)t);
            }
            EventController.controller.exceptionHandler.doExceptionHandling(new RuntimeTargetException(t, "Exception caught in EventController.fire(" + event.getClass().getName() + ")\nException: " + t.toString(), event.hashCode()));
        }
    }
}

