/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.dom;

import ch.e2e.dom.BridgeNamespaceContext;
import ch.e2e.dom.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.xpath.XPathEvaluator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomUtilities
implements Logging {
    public static final String XML_false = "false";
    public static final String XML_no = "no";
    public static final String XML_true = "true";
    public static final String XML_yes = "yes";
    public static final NodeList EMPTY_NODE_LIST = new EmptyNodeList();

    private DomUtilities() {
    }

    public static void removeAllNotElementNodes(Element element) {
        int i;
        NodeList childs = element.getChildNodes();
        ArrayList<Node> childsToRemove = new ArrayList<Node>();
        int length = childs.getLength();
        for (i = 0; i < length; ++i) {
            if (childs.item(i).getNodeType() == 1) {
                DomUtilities.removeAllNotElementNodes((Element)childs.item(i));
                continue;
            }
            childsToRemove.add(childs.item(i));
        }
        length = childsToRemove.size();
        for (i = 0; i < length; ++i) {
            element.removeChild((Node)childsToRemove.get(i));
        }
    }

    public static void removeAllNotElementEmptyNodes(Element element) {
        int i;
        NodeList childs = element.getChildNodes();
        ArrayList<Node> childsToRemove = new ArrayList<Node>();
        int length = childs.getLength();
        for (i = 0; i < length; ++i) {
            if (childs.item(i).getNodeType() == 1) {
                DomUtilities.removeAllNotElementEmptyNodes((Element)childs.item(i));
                continue;
            }
            if (childs.item(i).getNodeType() != 3 || !DomUtilities.containsOnlyWhiteSpaces(((Text)childs.item(i)).getData())) continue;
            childsToRemove.add(childs.item(i));
        }
        length = childsToRemove.size();
        for (i = 0; i < length; ++i) {
            element.removeChild((Node)childsToRemove.get(i));
        }
    }

    public static boolean containsOnlyWhiteSpaces(String text) {
        boolean result = true;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static Document copySaxonResult(DOMResult result) {
        Document resultDocument = null;
        Document resultDoc = (Document)result.getNode();
        StringWriter docString = new StringWriter();
        Element root = resultDoc.getDocumentElement();
        if (root != null) {
            try {
                DomUtilities.serialize((Writer)docString, resultDoc, false);
                String domString = docString.toString();
                if (domString.length() > 0) {
                    StringReader domReader = new StringReader(domString);
                    resultDocument = DomUtilities.parse(domReader, false, false);
                }
            }
            catch (Exception e) {
                logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                logger.throwing(DomUtilities.class.getName(), "copySaxonResult", e);
            }
        }
        return resultDocument;
    }

    public static Document parseFromClasspath(String filename) throws ParserConfigurationException, SAXException, IOException {
        return DomUtilities.parseFromClasspath(filename, true, true, true, DomUtilities.class.getClassLoader());
    }

    public static Document parseFromClasspath(String filename, boolean validating, boolean schemaValidation) throws ParserConfigurationException, SAXException, IOException {
        return DomUtilities.parseFromClasspath(filename, validating, schemaValidation, true, DomUtilities.class.getClassLoader());
    }

    public static Document parseFromClasspath(String filename, boolean validating, boolean schemaValidation, boolean namespaceAware) throws ParserConfigurationException, SAXException, IOException {
        return DomUtilities.parseFromClasspath(filename, validating, schemaValidation, namespaceAware, DomUtilities.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseFromClasspath(String filename, boolean validating, boolean schemaValidation, boolean namespaceAware, ClassLoader classLoader) throws ParserConfigurationException, SAXException, IOException {
        Document document;
        block7: {
            InputStream in = classLoader.getResourceAsStream(filename);
            try {
                document = DomUtilities.parse(in, validating, schemaValidation, namespaceAware);
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                        logger.throwing(DomUtilities.class.getName(), "parse", e);
                    }
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                logger.throwing(DomUtilities.class.getName(), "parse", e);
            }
        }
        return document;
    }

    public static Document parse(Reader reader) throws ParserConfigurationException, SAXException, IOException {
        return new Builder().build().parse(new InputSource(reader));
    }

    public static Document parse(Reader reader, boolean validating, boolean schemaValidation) throws ParserConfigurationException, SAXException, IOException {
        return new Builder().validating(validating).schemaValidation(schemaValidation).build().parse(new InputSource(reader));
    }

    public static Document parse(Reader reader, boolean validating, boolean schemaValidation, boolean namespaceAware) throws ParserConfigurationException, SAXException, IOException {
        return new Builder().namespaceAware(namespaceAware).validating(validating).schemaValidation(schemaValidation).build().parse(new InputSource(reader));
    }

    public static Document parse(Reader reader, boolean validating, boolean schemaValidation, ErrorHandler errorHandler) throws ParserConfigurationException, SAXException, IOException {
        return new Builder().validating(validating).schemaValidation(schemaValidation).errorHandler(errorHandler).build().parse(new InputSource(reader));
    }

    public static Document parse(Reader reader, boolean validating, boolean schemaValidation, boolean namespaceAware, ErrorHandler errorHandler) throws ParserConfigurationException, SAXException, IOException {
        return new Builder().namespaceAware(namespaceAware).validating(validating).schemaValidation(schemaValidation).errorHandler(errorHandler).build().parse(new InputSource(reader));
    }

    public static Document parse(File file) throws ParserConfigurationException, SAXException, IOException {
        return DomUtilities.parse(file, new Builder().build());
    }

    public static Document parse(File file, boolean validating, boolean schemaValidation) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = new Builder().validating(validating).schemaValidation(schemaValidation).build();
        return DomUtilities.parse(file, builder);
    }

    public static Document parse(File file, boolean validating, boolean schemaValidation, boolean namespaceAware) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = new Builder().namespaceAware(namespaceAware).validating(validating).schemaValidation(schemaValidation).build();
        return DomUtilities.parse(file, builder);
    }

    public static Document parse(File file, boolean validating, boolean schemaValidation, ErrorHandler errorHandler) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = new Builder().validating(validating).schemaValidation(schemaValidation).errorHandler(errorHandler).build();
        return DomUtilities.parse(file, builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parse(File file, DocumentBuilder builder) throws SAXException, IOException {
        Document document;
        FileInputStream in = new FileInputStream(file);
        try {
            document = builder.parse(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                logger.throwing(DomUtilities.class.getName(), "parse", e);
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(DomUtilities.class.getName(), "parse", e);
        }
        return document;
    }

    public static Document parse(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        return new Builder().build().parse(in);
    }

    public static Document parse(InputStream in, boolean validating, boolean schemaValidation) throws ParserConfigurationException, SAXException, IOException {
        return new Builder().validating(validating).schemaValidation(schemaValidation).build().parse(in);
    }

    public static Document parse(InputStream in, boolean validating, boolean schemaValidation, boolean namespaceAware) throws ParserConfigurationException, SAXException, IOException {
        return new Builder().namespaceAware(namespaceAware).validating(validating).schemaValidation(schemaValidation).build().parse(in);
    }

    public static Document parse(InputStream in, boolean validating, boolean schemaValidation, boolean namespaceAware, boolean loadExternalDtd) throws ParserConfigurationException, SAXException, IOException {
        return new Builder().namespaceAware(namespaceAware).validating(validating).schemaValidation(schemaValidation).loadExternalDtd(loadExternalDtd).build().parse(in);
    }

    public static Document parse(InputStream in, boolean validating, boolean schemaValidation, ErrorHandler errorHandler) throws ParserConfigurationException, SAXException, IOException {
        return DomUtilities.parse(new InputSource(in), validating, schemaValidation, errorHandler);
    }

    public static Document parse(InputSource in, boolean validating, boolean schemaValidation, ErrorHandler errorHandler) throws ParserConfigurationException, SAXException, IOException {
        return new Builder().validating(validating).schemaValidation(schemaValidation).errorHandler(errorHandler).build().parse(in);
    }

    public static Document newDocument() {
        return new DocBuilder().build();
    }

    public static Document newDocument(String qualifiedName) {
        return new DocBuilder().qualifiedName(qualifiedName).build();
    }

    public static Document newDocument(String qualifiedName, DocumentType documentType) {
        return new DocBuilder().qualifiedName(qualifiedName).documentType(documentType).build();
    }

    public static Document newDocument(String namespaceUri, String qualifiedName) {
        return new DocBuilder().namespaceUri(namespaceUri).qualifiedName(qualifiedName).build();
    }

    public static Document newDocument(String namespaceUri, String qualifiedName, DocumentType documentType) {
        return new DocBuilder().namespaceUri(namespaceUri).qualifiedName(qualifiedName).documentType(documentType).build();
    }

    public static void serializeToZip(File file, Document doc, boolean indent) throws TransformerException, IOException {
        DomUtilities.serializeToZip(file, doc, indent, DomUtilities.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeToZip(File file, Document doc, boolean indent, ClassLoader classLoader) throws TransformerException, IOException {
        String filename = file.getName();
        int index = filename.lastIndexOf(46);
        String entryName = index == -1 ? filename : filename.substring(0, index);
        DeflaterOutputStream zipfile = null;
        try {
            zipfile = new ZipOutputStream(new FileOutputStream(file));
            ZipEntry entry = new ZipEntry(entryName);
            ((ZipOutputStream)zipfile).putNextEntry(entry);
            DomUtilities.serialize(new StreamResult(zipfile), doc, indent, classLoader);
            ((ZipOutputStream)zipfile).closeEntry();
        }
        catch (Throwable throwable) {
            try {
                if (zipfile != null) {
                    zipfile.flush();
                }
            }
            catch (Exception e) {
                logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                logger.throwing(DomUtilities.class.getName(), "serializeToZip", e);
            }
            try {
                if (zipfile != null) {
                    ((ZipOutputStream)zipfile).close();
                }
            }
            catch (Exception e) {
                logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                logger.throwing(DomUtilities.class.getName(), "serializeToZip", e);
            }
            throw throwable;
        }
        try {
            if (zipfile != null) {
                zipfile.flush();
            }
        }
        catch (Exception e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(DomUtilities.class.getName(), "serializeToZip", e);
        }
        try {
            if (zipfile != null) {
                ((ZipOutputStream)zipfile).close();
            }
        }
        catch (Exception e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(DomUtilities.class.getName(), "serializeToZip", e);
        }
    }

    public static void serialize(File file, Node node, boolean indent) throws TransformerException, IOException {
        DomUtilities.serialize(file, node, indent, DomUtilities.class.getClassLoader());
    }

    public static void serialize(File file, Node node, boolean indent, ClassLoader classLoader) throws FileNotFoundException, TransformerException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        DomUtilities.serialize((OutputStream)new FileOutputStream(file), node, indent, classLoader);
    }

    public static void serialize(OutputStream stream, Node node, boolean indent) throws TransformerException {
        DomUtilities.serialize(stream, node, indent, DomUtilities.class.getClassLoader());
    }

    public static void serialize(OutputStream stream, Node node, boolean indent, boolean close) throws TransformerException {
        DomUtilities.serialize(stream, node, indent, close, DomUtilities.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(OutputStream stream, Node node, boolean indent, ClassLoader classLoader) throws TransformerException {
        try {
            DomUtilities.serialize(new StreamResult(stream), node, indent, classLoader);
        }
        catch (Throwable throwable) {
            try {
                stream.flush();
            }
            catch (Exception e) {
                logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                logger.throwing(DomUtilities.class.getName(), "serialize", e);
            }
            try {
                stream.close();
            }
            catch (Exception e) {
                logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                logger.throwing(DomUtilities.class.getName(), "serialize", e);
            }
            throw throwable;
        }
        try {
            stream.flush();
        }
        catch (Exception e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(DomUtilities.class.getName(), "serialize", e);
        }
        try {
            stream.close();
        }
        catch (Exception e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(DomUtilities.class.getName(), "serialize", e);
        }
    }

    public static void serialize(Writer writer, Node node, boolean indent) throws TransformerException {
        DomUtilities.serialize(writer, node, indent, DomUtilities.class.getClassLoader());
    }

    public static void serialize(Writer writer, Node node, boolean indent, boolean close) throws TransformerException {
        DomUtilities.serialize(writer, node, indent, close, DomUtilities.class.getClassLoader());
    }

    public static void serialize(Writer writer, Node node, boolean indent, ClassLoader classLoader) throws TransformerException {
        DomUtilities.serialize(writer, node, indent, true, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Writer writer, Node node, boolean indent, boolean close, ClassLoader classLoader) throws TransformerException {
        try {
            DomUtilities.serialize(new StreamResult(writer), node, indent, classLoader);
        }
        catch (Throwable throwable) {
            try {
                writer.flush();
            }
            catch (Exception e) {
                logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                logger.throwing(DomUtilities.class.getName(), "serialize", e);
            }
            if (close) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                    logger.throwing(DomUtilities.class.getName(), "serialize", e);
                }
            }
            throw throwable;
        }
        try {
            writer.flush();
        }
        catch (Exception e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(DomUtilities.class.getName(), "serialize", e);
        }
        if (close) {
            try {
                writer.close();
            }
            catch (Exception e) {
                logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                logger.throwing(DomUtilities.class.getName(), "serialize", e);
            }
        }
    }

    public static void serialize(StreamResult result, Node node, boolean indent) throws TransformerException {
        DomUtilities.serialize(result, node, indent, DomUtilities.class.getClassLoader());
    }

    public static void serialize(StreamResult result, Node node, boolean indent, ClassLoader classLoader) throws TransformerException {
        if (node instanceof Document) {
            DomUtilities.serialize(result, (Document)node, indent, classLoader);
        } else {
            Document doc;
            if (node instanceof Element) {
                doc = DomUtilities.newDocument();
                node = doc.importNode(node, true);
                doc.appendChild(node);
            } else {
                doc = DomUtilities.newDocument("DomUtilitiesSerializeDocument");
                node = doc.importNode(node, true);
                doc.getDocumentElement().appendChild(node);
            }
            DomUtilities.serialize(result, doc, indent, classLoader);
        }
    }

    public static void serialize(OutputStream result, Node node, boolean indent, boolean close, ClassLoader classLoader) throws TransformerException {
        if (node instanceof Document) {
            DomUtilities.serialize(result, (Document)node, indent, classLoader, close);
        } else {
            Document doc = DomUtilities.newDocument();
            node = doc.importNode(node, true);
            doc.appendChild(node);
            DomUtilities.serialize(result, doc, indent, classLoader, close);
        }
    }

    public static void serialize(File file, Document document, boolean indent) throws TransformerException, IOException {
        DomUtilities.serialize(file, document, indent, DomUtilities.class.getClassLoader());
    }

    public static void serialize(File file, Document document, boolean indent, ClassLoader classLoader) throws FileNotFoundException, TransformerException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        DomUtilities.serialize((OutputStream)new FileOutputStream(file), document, indent, classLoader);
    }

    public static void serialize(OutputStream stream, Document document, boolean indent) throws TransformerException {
        DomUtilities.serialize(stream, document, indent, DomUtilities.class.getClassLoader(), true);
    }

    public static void serialize(OutputStream stream, Document document, boolean indent, boolean close) throws TransformerException {
        DomUtilities.serialize(stream, document, indent, DomUtilities.class.getClassLoader(), close);
    }

    public static void serialize(OutputStream stream, Document document, boolean indent, ClassLoader classLoader) throws TransformerException {
        DomUtilities.serialize(stream, document, indent, classLoader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(OutputStream stream, Document document, boolean indent, ClassLoader classLoader, boolean close) throws TransformerException {
        try {
            DomUtilities.serialize(new StreamResult(stream), document, indent, classLoader);
        }
        catch (Throwable throwable) {
            try {
                stream.flush();
            }
            catch (Exception e) {
                logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                logger.throwing(DomUtilities.class.getName(), "serialize", e);
            }
            if (close) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                    logger.throwing(DomUtilities.class.getName(), "serialize", e);
                }
            }
            throw throwable;
        }
        try {
            stream.flush();
        }
        catch (Exception e) {
            logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
            logger.throwing(DomUtilities.class.getName(), "serialize", e);
        }
        if (close) {
            try {
                stream.close();
            }
            catch (Exception e) {
                logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                logger.throwing(DomUtilities.class.getName(), "serialize", e);
            }
        }
    }

    public static void serialize(Writer writer, Document document, boolean indent) throws TransformerException {
        DomUtilities.serialize(writer, document, indent, DomUtilities.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Writer writer, Document document, boolean indent, ClassLoader classLoader) throws TransformerException {
        try {
            DomUtilities.serialize(new StreamResult(writer), document, indent, classLoader);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(DomUtilities.class.getName(), "serialize", e);
            }
        }
    }

    public static void serialize(StreamResult result, Document document, boolean indent) throws TransformerException {
        DomUtilities.serialize(result, document, indent, DomUtilities.class.getClassLoader());
    }

    public static void serialize(StreamResult result, Document document, boolean indent, ClassLoader classLoader) throws TransformerException {
        DomUtilities.newTransformer(indent, classLoader).transform(new DOMSource(document), result);
    }

    private static Transformer newTransformer(boolean indent, ClassLoader classLoader) throws TransformerConfigurationException {
        Transformer transformer = DomUtilities.getTransformerFactory(classLoader).newTransformer();
        transformer.setOutputProperty("indent", indent ? XML_yes : XML_no);
        return transformer;
    }

    public static TransformerFactory getTransformerFactory(ClassLoader classLoader) {
        TransformerFactory transformerFactory;
        try {
            Class<?> factoryClass = classLoader.loadClass("net.sf.saxon.TransformerFactoryImpl");
            transformerFactory = (TransformerFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            logger.finest("Could not load the saxon TransformerFactory, loading default factory");
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    public static boolean getBoolean(Element element, String attributeName, boolean defaultValue) {
        boolean result = defaultValue;
        if (element != null && element.hasAttribute(attributeName)) {
            String attribute = element.getAttribute(attributeName).toLowerCase();
            if (attribute.equalsIgnoreCase(XML_no) || attribute.equalsIgnoreCase(XML_false)) {
                result = false;
            } else if (attribute.equalsIgnoreCase(XML_yes) || attribute.equalsIgnoreCase(XML_true)) {
                result = true;
            }
        }
        return result;
    }

    public static boolean getBooleanNS(Element element, String namespaceUri, String attributeName, boolean defaultValue) {
        boolean result = defaultValue;
        if (element != null && element.hasAttributeNS(namespaceUri, attributeName)) {
            String attribute = element.getAttributeNS(namespaceUri, attributeName).toLowerCase();
            if (attribute.equalsIgnoreCase(XML_no) || attribute.equalsIgnoreCase(XML_false)) {
                result = false;
            } else if (attribute.equalsIgnoreCase(XML_yes) || attribute.equalsIgnoreCase(XML_true)) {
                result = true;
            }
        }
        return result;
    }

    public static int getInt(Element element, String attributeName, int defaultValue) {
        int result = defaultValue;
        if (element.hasAttribute(attributeName)) {
            String attribute = element.getAttribute(attributeName);
            try {
                result = Integer.parseInt(attribute);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static int getIntNS(Element element, String namespaceUri, String attributeName, int defaultValue) {
        int result = defaultValue;
        if (element.hasAttributeNS(namespaceUri, attributeName)) {
            String attribute = element.getAttributeNS(namespaceUri, attributeName);
            try {
                result = Integer.parseInt(attribute);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean getBooleanFromElement(Element element, boolean defaultValue) {
        boolean result = defaultValue;
        if (element.getChildNodes().getLength() == 1 && element.getFirstChild().getNodeType() == 3) {
            String value = ((Text)element.getFirstChild()).getData();
            if (value.equalsIgnoreCase(XML_no) || value.equalsIgnoreCase(XML_false)) {
                result = false;
            } else if (value.equalsIgnoreCase(XML_yes) || value.equalsIgnoreCase(XML_true)) {
                result = true;
            }
        }
        return result;
    }

    public static boolean getBooleanFromElement(Element element, String childName, boolean defaultValue) {
        Element child;
        boolean result = defaultValue;
        NodeList children = element.getElementsByTagName(childName);
        if (children != null && children.getLength() > 0 && (child = (Element)children.item(0)).getChildNodes().getLength() == 1 && child.getFirstChild().getNodeType() == 3) {
            String value = ((Text)child.getFirstChild()).getData();
            if (value.equalsIgnoreCase(XML_no) || value.equalsIgnoreCase(XML_false)) {
                result = false;
            } else if (value.equalsIgnoreCase(XML_yes) || value.equalsIgnoreCase(XML_true)) {
                result = true;
            }
        }
        return result;
    }

    public static boolean getBooleanFromElementNS(Element element, String namespaceUri, String childName, boolean defaultValue) {
        Element child;
        boolean result = defaultValue;
        NodeList children = element.getElementsByTagNameNS(namespaceUri, childName);
        if (children != null && children.getLength() > 0 && (child = (Element)children.item(0)).getChildNodes().getLength() == 1 && child.getFirstChild().getNodeType() == 3) {
            String value = ((Text)child.getFirstChild()).getData();
            if (value.equalsIgnoreCase(XML_no) || value.equalsIgnoreCase(XML_false)) {
                result = false;
            } else if (value.equalsIgnoreCase(XML_yes) || value.equalsIgnoreCase(XML_true)) {
                result = true;
            }
        }
        return result;
    }

    public static String getTextValue(Element element, String defaultValue) {
        String result = defaultValue;
        if (element.getChildNodes().getLength() == 1 && element.getFirstChild().getNodeType() == 3) {
            result = ((Text)element.getFirstChild()).getData();
        }
        return result;
    }

    public static String getTextValue(Element element, String childName, String defaultValue) {
        Element child;
        String result = defaultValue;
        NodeList children = element.getElementsByTagName(childName);
        if (children != null && children.getLength() > 0 && (child = (Element)children.item(0)).getChildNodes().getLength() == 1 && child.getFirstChild().getNodeType() == 3) {
            result = ((Text)child.getFirstChild()).getData();
        }
        return result;
    }

    public static String getTextValueNS(Element element, String namespaceUri, String childName, String defaultValue) {
        Element child;
        String result = defaultValue;
        NodeList children = element.getElementsByTagNameNS(namespaceUri, childName);
        if (children != null && children.getLength() > 0 && (child = (Element)children.item(0)).getChildNodes().getLength() == 1 && child.getFirstChild().getNodeType() == 3) {
            result = ((Text)child.getFirstChild()).getData();
        }
        return result;
    }

    public static void copyAttributes(Node from, Element to) {
        NamedNodeMap attrFrom = from.getAttributes();
        int length = attrFrom.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attribute = (Attr)attrFrom.item(i);
            to.setAttribute(attribute.getName(), attribute.getValue());
        }
    }

    public static String selectNodeValue(Node node, String xPathExpression) throws XPathExpressionException {
        return DomUtilities.selectNodeValue(node, xPathExpression, null);
    }

    public static String selectNodeValue(Node node, String xPathExpression, Map<String, String> namespaces) throws XPathExpressionException {
        Node result = DomUtilities.selectNode(node, xPathExpression, namespaces);
        return result == null ? null : result.getNodeValue();
    }

    public static Object selectNode(Node node, String xPathExpression) throws XPathExpressionException {
        return DomUtilities.selectNode(node, xPathExpression, null);
    }

    public static Node selectNode(Node node, String xPathExpression, Map<String, String> namespaces) throws XPathExpressionException {
        return (Node)DomUtilities.evaluate(node, xPathExpression, namespaces, XPathConstants.NODE);
    }

    public static List<Node> selectNodes(Node node, String xpath) throws XPathExpressionException {
        return DomUtilities.selectNodes(node, xpath, null);
    }

    public static List<Node> selectNodes(Node node, String xPathExpression, Map<String, String> namespaces) throws XPathExpressionException {
        NodeList nodes = (NodeList)DomUtilities.evaluate(node, xPathExpression, namespaces, XPathConstants.NODESET);
        ArrayList<Node> result = new ArrayList<Node>();
        if (nodes != null) {
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                result.add(nodes.item(i));
            }
        }
        return result;
    }

    public static Object evaluate(Node element, String xPathExpression, QName returnType) throws XPathExpressionException {
        return DomUtilities.evaluate(element, xPathExpression, new BridgeNamespaceContext(element), returnType);
    }

    public static Object evaluate(Node node, String xPathExpression, Map<String, String> namespaces, QName returnType) throws XPathExpressionException {
        BridgeNamespaceContext namespaceContext;
        if (namespaces == null) {
            namespaceContext = new BridgeNamespaceContext(node);
        } else {
            namespaceContext = new BridgeNamespaceContext(new Node[0]);
            for (Map.Entry<String, String> entry : namespaces.entrySet()) {
                namespaceContext.addNamespace(entry.getKey(), entry.getValue());
            }
        }
        return DomUtilities.evaluate(node, xPathExpression, namespaceContext, returnType);
    }

    public static Object evaluate(Node node, String xPathExpression, NamespaceContext namespaceContext, QName returnType) throws XPathExpressionException {
        return DomUtilities.newXPath(namespaceContext).evaluate(xPathExpression, node, returnType);
    }

    public static XPath newXPath() {
        return new XPathEvaluator();
    }

    public static XPath newXPath(NamespaceContext namespaceContext) {
        XPath xPath = DomUtilities.newXPath();
        if (namespaceContext != null) {
            xPath.setNamespaceContext(namespaceContext);
        }
        return xPath;
    }

    public static String toString(Node node) {
        StringBuilder row = new StringBuilder();
        NodeList children = node.getChildNodes();
        if (children != null) {
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                if (child instanceof Text) {
                    row.append(child.getNodeValue());
                    continue;
                }
                if (!(child instanceof Element)) continue;
                row.append('<').append(child.getNodeName()).append(DomUtilities.getAttributesString(child)).append('>');
                row.append(DomUtilities.toString(child)).append("</").append(child.getNodeName()).append('>');
            }
        }
        return row.toString();
    }

    private static String getAttributesString(Node element) {
        StringBuilder attributesString = new StringBuilder(" ");
        if (element.hasAttributes()) {
            NamedNodeMap attributes = element.getAttributes();
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                attributesString.append(attribute.getName()).append("=\"").append(attribute.getValue()).append("\" ");
            }
        }
        return attributesString.toString();
    }

    public static Node importAndAdd(Node child, Node newParent) {
        Node newChild = newParent.getOwnerDocument().adoptNode(child);
        if (newChild == null) {
            newChild = newParent.getOwnerDocument().importNode(child, true);
        }
        newParent.appendChild(newChild);
        return newChild;
    }

    public static String show(Node node, boolean indent) {
        StringWriter w = new StringWriter();
        try {
            DomUtilities.serialize((Writer)w, node.cloneNode(true), indent);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return w.toString();
    }

    public static String show(Node node) {
        return DomUtilities.asString(node, true);
    }

    public static String asString(Node node) {
        return DomUtilities.asString(node, true);
    }

    public static String asString(Node node, boolean indent) {
        StringWriter w = new StringWriter();
        try {
            DomUtilities.serialize((Writer)w, node, indent);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return w.toString();
    }

    public static Element getFirstElement(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static Iterator<Element> elementIterator(NodeList nodes) {
        return new ElementIterator(nodes);
    }

    public static NodeList emptyNodeList() {
        return EMPTY_NODE_LIST;
    }

    private static class DocBuilder {
        private String namespaceUri;
        private String qualifiedName;
        private DocumentType documentType;

        private DocBuilder() {
        }

        private Document build() {
            try {
                return new Builder().build().getDOMImplementation().createDocument(this.namespaceUri, this.qualifiedName, this.documentType);
            }
            catch (ParserConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
        }

        private DocBuilder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        private DocBuilder qualifiedName(String qualifiedName) {
            this.qualifiedName = qualifiedName;
            return this;
        }

        private DocBuilder documentType(DocumentType documentType) {
            this.documentType = documentType;
            return this;
        }
    }

    private static class Builder {
        private boolean namespaceAware = true;
        private boolean validating = true;
        private boolean expandEntityReferences = false;
        private Boolean schemaValidation;
        private Boolean loadExternalDtd;
        private ErrorHandler errorHandler;

        private Builder() {
        }

        private DocumentBuilder build() throws ParserConfigurationException {
            return this.createBuilder(this.createFactory());
        }

        private Builder namespaceAware(boolean namespaceAware) {
            this.namespaceAware = namespaceAware;
            return this;
        }

        private Builder validating(boolean validating) {
            this.validating = validating;
            return this;
        }

        private Builder expandEntityReferences(boolean expandEntityReferences) {
            this.expandEntityReferences = expandEntityReferences;
            return this;
        }

        private Builder schemaValidation(Boolean schemaValidation) {
            this.schemaValidation = schemaValidation;
            return this;
        }

        private Builder loadExternalDtd(Boolean loadExternalDtd) {
            this.loadExternalDtd = loadExternalDtd;
            return this;
        }

        private Builder errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        private DocumentBuilderFactory createFactory() {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(this.namespaceAware);
            factory.setValidating(this.validating);
            factory.setExpandEntityReferences(this.expandEntityReferences);
            this.setFactoryAttribute(factory, "http://apache.org/xml/features/validation/schema", this.schemaValidation);
            this.setFactoryAttribute(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", this.loadExternalDtd);
            return factory;
        }

        private void setFactoryAttribute(DocumentBuilderFactory factory, String name, Object value) {
            if (value != null) {
                try {
                    factory.setAttribute(name, value);
                }
                catch (IllegalArgumentException e) {
                    Logging.logger.warning(String.format("Could not set attribute '%s' on '%s'.", name, factory.getClass().getName()));
                }
            }
        }

        private DocumentBuilder createBuilder(DocumentBuilderFactory factory) throws ParserConfigurationException {
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                if (this.errorHandler != null) {
                    builder.setErrorHandler(this.errorHandler);
                }
                return builder;
            }
            catch (ParserConfigurationException e) {
                Logging.logger.severe(String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()));
                Logging.logger.throwing(DomUtilities.class.getName(), "Builder.createBuilder", e);
                throw e;
            }
        }
    }

    private static class EmptyNodeList
    implements NodeList {
        private EmptyNodeList() {
        }

        @Override
        public Node item(int index) {
            return null;
        }

        @Override
        public int getLength() {
            return 0;
        }
    }

    public static class ElementIterator
    implements Iterator<Element> {
        private final NodeList nodes;
        private boolean hasNext = false;
        int cursor = 0;

        private ElementIterator(NodeList nodes) {
            this.nodes = nodes;
        }

        @Override
        public boolean hasNext() {
            while (this.cursor < this.nodes.getLength()) {
                if (this.nodes.item(this.cursor).getNodeType() == 1) {
                    this.hasNext = true;
                    return true;
                }
                ++this.cursor;
            }
            this.hasNext = false;
            return false;
        }

        @Override
        public Element next() {
            Node node;
            if (this.hasNext) {
                this.hasNext = false;
                return (Element)this.nodes.item(this.cursor++);
            }
            do {
                if ((node = this.nodes.item(this.cursor++)) != null) continue;
                throw new NoSuchElementException();
            } while (node.getNodeType() != 1);
            return (Element)node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

