/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;

public class OperatingSystemInfo {
    private static final String SUFFIX_BAT = ".bat";
    private static final String SUFFIX_SH = ".sh";
    private static final String SUFFIX_EXE = ".exe";
    private static final String COMMENT_WINDOWS = "REM ";
    private static final String COMMENT_UNIX = "# ";
    private static final String COMMAND_SET = "set ";
    private static final String OS_WINDOWS = "windows";
    private static final String OS_LINUX = "linux";
    private static final OsName OS_NAME = OsName.access$000();

    public static OsName getOsName() {
        return OS_NAME;
    }

    public static boolean isOsName(OsName osName) {
        return OperatingSystemInfo.getOsName().equals((Object)osName);
    }

    public static boolean isWindowsOs() {
        return OperatingSystemInfo.isOsName(OsName.WIN32);
    }

    public static boolean isLinuxOs() {
        return OperatingSystemInfo.isOsName(OsName.LINUX);
    }

    public static String scriptSuffix() {
        return OperatingSystemInfo.isWindowsOs() ? SUFFIX_BAT : SUFFIX_SH;
    }

    public static String executableSuffix() {
        return OperatingSystemInfo.isWindowsOs() ? SUFFIX_EXE : "";
    }

    public static String lineComment() {
        return OperatingSystemInfo.isWindowsOs() ? COMMENT_WINDOWS : COMMENT_UNIX;
    }

    public static String commandSet() {
        return OperatingSystemInfo.isWindowsOs() ? COMMAND_SET : "";
    }

    private OperatingSystemInfo() {
    }

    public static enum OsName {
        WIN32,
        LINUX,
        UNKNOWN;


        private static OsName getOsName() {
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            String osName = osBean.getName().toLowerCase();
            if (osName.contains(OperatingSystemInfo.OS_WINDOWS)) {
                return WIN32;
            }
            if (osName.contains(OperatingSystemInfo.OS_LINUX)) {
                return LINUX;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static /* synthetic */ OsName access$000() {
            return OsName.getOsName();
        }
    }
}

