/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.substitutor;

import ch.e2e.util.StringTools;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutor;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutorException;
import ch.e2e.xuml.utils.E2eIni;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class IniPlaceholderSubstitutor
implements PlaceholderSubstitutor {
    private static final String PLACEHOLDER_PREFIX = "${";
    private final Ini ini;

    public IniPlaceholderSubstitutor(Ini ini) {
        this.ini = ini;
    }

    public IniPlaceholderSubstitutor() {
        this.ini = new E2eIni();
    }

    @Override
    public boolean canProcess(String filePath) {
        return filePath.endsWith(".cfg") || filePath.endsWith(".ini") || filePath.endsWith(".properties");
    }

    @Override
    public void applySubstitutions(Reader reader, Writer writer, Map<String, String> substitutions) throws PlaceholderSubstitutorException {
        try {
            this.ini.load(reader);
            this.applySubstitions(this.ini.values(), substitutions);
            this.ini.store(writer);
        }
        catch (IOException e) {
            throw new PlaceholderSubstitutorException(e.getMessage());
        }
    }

    private void applySubstitions(Collection<Profile.Section> sections, Map<String, String> substitutions) {
        for (Profile.Section section : sections) {
            this.applySubstitutions(section, substitutions);
        }
    }

    private void applySubstitutions(Profile.Section section, Map<String, String> substitutions) {
        Iterator iterator = section.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            String newValue = StringTools.replaceProperties((String)((String)(entry = (Map.Entry)iterator.next()).getValue()), substitutions).trim();
            entry.setValue(this.isRemoveProperty(newValue) ? null : newValue);
        }
    }

    private boolean isRemoveProperty(String value) {
        return value.isEmpty() || value.startsWith(PLACEHOLDER_PREFIX);
    }
}

