/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.settings.view;

import ch.e2e.xuml.settings.model.Setting;
import ch.e2e.xuml.settings.view.Category;
import ch.e2e.xuml.settings.view.Section;
import ch.e2e.xuml.settings.view.SettingRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class View {
    private static final Comparator<Category> CATEGORY_COMPARATOR = new CategoryComparator();
    private final Category[] categories;
    private final List<SettingRow> settingRows;

    public View(Document substitutionsDoc, Map<String, ? extends Setting> settings) {
        this.categories = this.buildView(substitutionsDoc, settings);
        this.settingRows = new ArrayList<SettingRow>();
        for (Category category : this.categories) {
            for (Section section : category.getSections()) {
                this.settingRows.addAll(section.getSettingRows());
            }
        }
    }

    public Category[] getCategories() {
        return this.categories;
    }

    public List<SettingRow> getSettingRows() {
        return this.settingRows;
    }

    private Category[] buildView(Document substitutionsDoc, Map<String, ? extends Setting> settings) {
        NodeList categoryElements = substitutionsDoc.getElementsByTagName("Category");
        int nCategories = categoryElements.getLength();
        Category[] categories = new Category[nCategories];
        for (int i = 0; i < nCategories; ++i) {
            categories[i] = new Category((Element)categoryElements.item(i), settings);
        }
        View.sort(categories);
        return categories;
    }

    private static void sort(Category[] categories) {
        Arrays.sort(categories, CATEGORY_COMPARATOR);
    }

    private static class CategoryComparator
    implements Comparator<Category> {
        private CategoryComparator() {
        }

        @Override
        public int compare(Category o1, Category o2) {
            if (o1.isGlobalSetting()) {
                return -1;
            }
            if (o2.isGlobalSetting()) {
                return 1;
            }
            return o1.getLabel().compareTo(o2.getLabel());
        }
    }
}

