/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.settings.view;

import ch.e2e.xuml.settings.Settings;
import ch.e2e.xuml.settings.model.Setting;
import ch.e2e.xuml.settings.view.Node;
import java.util.Map;
import org.w3c.dom.Element;

public class SettingRow
extends Node {
    private final Setting setting;

    public SettingRow(Element element, Map<String, ? extends Setting> settings) {
        super(element);
        this.setting = settings.get(element.getAttribute("variable"));
    }

    @Override
    public String getKey() {
        return this.getId();
    }

    public String getId() {
        return this.setting.getId();
    }

    public String getType() {
        return this.setting.getType();
    }

    public String getValue() {
        return this.setting.getValue();
    }

    public String getReplacedValue() {
        return this.setting.getReplacedValue();
    }

    public String getModelValue() {
        return this.setting.getModelValue();
    }

    public boolean isModified() {
        return this.setting.isModified();
    }

    public Setting getSetting() {
        return this.setting;
    }

    public String toCsv(char separator) {
        return Settings.escapeCsv(this.getLabel(), separator) + separator + this.getSetting().toCsv(separator);
    }

    @Override
    public String toString() {
        return "SettingRow{label=" + this.getLabel() + ", setting=" + this.setting + '}';
    }
}

