/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.testsuite;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.regtest.model.TestImportTreeNode;
import ch.e2e.builder.regtest.testsuite.ImportTestcaseContainer;
import ch.e2e.builder.regtest.testsuite.TraceTestcase;
import ch.e2e.builder.regtest.testsuite.WSDLFolder;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcaseRoot;
import ch.e2e.builder.trace.testcase.AbstractWSDLFolder;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.tree.TreePath;

public class TraceTestcaseRoot
extends AbstractSynchronousTestcaseRoot
implements TestImportTreeNode,
ImportTestcaseContainer {
    public static final int TESTCASE_ROOT_SELECTABLE = 5000;
    public static final int TESTCASE_ROOT_NOT_SELECTABLE = 5001;
    private File projectHome;
    private boolean testSuiteSelectionMode = false;

    public TraceTestcaseRoot(File projectHome) {
        super(projectHome.getName());
        this.setProjectHome(projectHome);
    }

    public File getProjectHome() {
        return this.projectHome;
    }

    public void setProjectHome(File projectHome) {
        this.projectHome = projectHome;
        this.setHome(new File(projectHome, "testcase"));
        this.clear();
        this.readWSDLFolders();
        this.setTestSuiteSelectionMode();
    }

    public void projectChanged(E2EBuilderProject project) {
        this.clear();
        this.readWSDLFolders();
    }

    public AbstractWSDLFolder getWSDLFolder(String name, File home, File idFile) {
        return new WSDLFolder(name, home, idFile);
    }

    public ArrayList<String> getAllExistingWsdlFolder() {
        return null;
    }

    private void readWSDLFolders() {
        File wsdlIds = new File(this.getHome(), ".wsdl.folder.ids");
        if (wsdlIds.exists()) {
            try {
                HashMap ids = UniqueIdService.loadUniqueIds((File)wsdlIds);
                for (String name : ids.keySet()) {
                    String folder = (String)ids.get(name);
                    File wsdlFolder = new File(this.getHome(), folder);
                    File idFile = new File(wsdlFolder, ".synchronous.id");
                    if (!idFile.exists()) continue;
                    WSDLFolder newFolder = new WSDLFolder(name, wsdlFolder, idFile);
                    if (newFolder.getChildCount() == 0) {
                        System.out.println("The WSDL folder " + name + " is empty.");
                        continue;
                    }
                    this.add((TestcaseObject)newFolder);
                }
            }
            catch (WrongIDFileVersionException e) {
                e.printStackTrace();
            }
        } else {
            this.createWSDLFolderIds(wsdlIds);
        }
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void setTestSuitSelectionMode(boolean testSuiteSelectionMode) {
        this.testSuiteSelectionMode = testSuiteSelectionMode;
        this.setTestSuiteSelectionMode();
    }

    @Override
    public Collection<TreePath> getSelectablePaths() {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        ArrayList<TreePath> selectablePaths = new ArrayList<TreePath>();
        for (TestcaseObject testcaseObject : this.getChildren().values()) {
            selectablePaths.addAll(((TestImportTreeNode)testcaseObject).getSelectablePaths());
        }
        for (TreePath path : selectablePaths) {
            Object[] pathElements = new Object[path.getPath().length + 1];
            pathElements[0] = this;
            System.arraycopy(path.getPath(), 0, pathElements, 1, path.getPath().length);
            result.add(new TreePath(pathElements));
        }
        return result;
    }

    @Override
    public void setExistingNames(Collection<String> existingNames) {
        for (TestcaseObject testcaseObject : this.getChildren().values()) {
            ((TestImportTreeNode)testcaseObject).setExistingNames(existingNames);
        }
    }

    @Override
    public void setExistingPaths(Collection<String> existingPaths, String rootPath) {
        rootPath = rootPath + this.getName() + '/';
        for (TestcaseObject testcaseObject : this.getChildren().values()) {
            ((TestImportTreeNode)testcaseObject).setExistingPaths(existingPaths, rootPath);
        }
    }

    @Override
    public boolean hasNameConflict() {
        return false;
    }

    @Override
    public void checkNames(String rootPath) {
        rootPath = rootPath + this.getName() + '/';
        for (TestcaseObject testcaseObject : this.getChildren().values()) {
            ((TestImportTreeNode)testcaseObject).checkNames(rootPath);
        }
    }

    @Override
    public Collection<TraceTestcase> findNameConflicts() {
        ArrayList<TraceTestcase> result = new ArrayList<TraceTestcase>();
        for (TestcaseObject testcase : this.getChildren().values()) {
            result.addAll(((TestImportTreeNode)testcase).findNameConflicts());
        }
        return result;
    }

    @Override
    public Collection<TestcaseObject> getChildCollection() {
        return this.getChildren().values();
    }

    private void setTestSuiteSelectionMode() {
        for (TestcaseObject testcaseObject : this.getChildren().values()) {
            if (!(testcaseObject instanceof TestImportTreeNode)) continue;
            ((TestImportTreeNode)testcaseObject).setTestSuitSelectionMode(this.testSuiteSelectionMode);
        }
    }
}

