/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.model;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.model.RunPopupMenu;
import ch.e2e.builder.regtest.testsuite.TestSuiteRoot;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.resource.Properties;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.test.E2ETestSuiteTemplateFactory;
import ch.e2e.test.ErrorDetail;
import ch.e2e.test.ErrorElement;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.TestLogfile;
import ch.e2e.test.TestSuiteProperty;
import ch.e2e.test.Testable;
import ch.e2e.test.XMLDiffErrorDetail;
import java.io.File;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;

public class TestSuiteTreeModel
extends AbstractTreeModel {
    private final E2EBuilderModule module;
    private Testable root;
    private RunPopupMenu runMenu;

    public TestSuiteTreeModel(E2EBuilderModule module) {
        super(new Properties("ch.e2e.builder.regtest.properties.tree"));
        this.module = module;
        this.createPopupMenus(module);
    }

    public E2EBuilderModule getModule() {
        return this.module;
    }

    public void setRoot(File root) {
        if (this.root == null && root != null || this.root != null && this.root instanceof TreeTestSuite && !((TreeTestSuite)this.root).getTestSuiteFile().equals(root)) {
            try {
                this.root = new TestSuiteRoot(E2ETestSuiteTemplateFactory.getInstance().getTemplate(root, false));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.reload();
        }
    }

    public void setRoot(Testable test) {
        this.root = test;
        this.reload();
    }

    public Object getRoot() {
        return this.root;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public String getTypeString(int type) {
        return null;
    }

    public int getType(Object value) {
        int result;
        if (value instanceof TestLogfile) {
            result = 20;
        } else if (value instanceof ErrorElement) {
            result = ((ErrorElement)value).getClassname().equals(AssertionFailedError.class.getName()) ? -10 : -11;
        } else if (value instanceof OptionContainer) {
            result = 600;
        } else if (value instanceof Testcase) {
            result = ((Testcase)value).getType();
            if (((Testcase)value).getErrors().size() > 0) {
                result += 2;
            } else if (((Testcase)value).isRun()) {
                ++result;
            }
        } else {
            result = value instanceof TestSuiteProperty ? -501 : super.getType(value);
        }
        return result;
    }

    public Object[][] getDefaultTypes() {
        return new Object[][]{{0, "regtest.root"}, {1, "regtest.testsuite"}, {2, "regtest.testsuite.in.library"}, {5, "regtest.library"}, {10, "regtest.testcase"}, {11, "regtest.testcase.no.errors"}, {12, "regtest.testcase.errors"}, {13, "regtest.testcase.in.library"}, {14, "regtest.testcase.in.library.no.errors"}, {15, "regtest.testcase.in.library.errors"}, {20, "regtest.logfile"}, {-10, "regtest.failure"}, {-11, "regtest.error"}, {500, "regtest.testsuite.options"}, {600, "regtest.option.container"}, {ErrorDetail.TYPE_ERROR_DETAIL, "error.detail"}, {XMLDiffErrorDetail.TYPE_XML_DIFF_ERROR_DETAIL, "error.xml.diff.detail"}, {-500, "regtest.testsuite.properties"}, {-501, "regtest.testsuite.properties.property"}};
    }

    public JPopupMenu getPopupMenu(TreePath[] paths) {
        RunPopupMenu result = null;
        if (paths != null && paths.length == 1 && paths[0].getLastPathComponent().equals(this.root)) {
            this.runMenu.setTest(this.root);
            result = this.runMenu;
        }
        return result;
    }

    public RunPopupMenu getRunMenu() {
        return this.runMenu;
    }

    public void reload() {
        try {
            this.fireRootChanged();
            this.fireTreeStructureChanged(new TreePath(this.root == null ? "" : this.root));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fireTreeNodesChanged(TreePath treePath, int[] childIndices, Object[] childs) {
        super.fireTreeNodesChanged(treePath, childIndices, childs);
    }

    public void fireTreeNodesRemoved(TreePath treePath, int[] childIndices, Object[] childs) {
        super.fireTreeNodesRemoved(treePath, childIndices, childs);
    }

    public void fireTreeStructureChanged(TreePath treePath) {
        super.fireTreeStructureChanged(treePath);
    }

    protected void createPopupMenus(E2EBuilderModule module) {
        this.runMenu = new RunPopupMenu(module);
    }
}

