/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.model;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.event.RemoveOptionsEvent;
import ch.e2e.builder.regtest.gui.OptionsDialog;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.event.EventController;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.Utilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class OptionsPopupMenu
extends JPopupMenu {
    private OptionContainer options;
    private E2EBuilderModule module;
    private JMenuItem editOptions;
    private JMenuItem removeOptions;

    public OptionsPopupMenu(E2EBuilderModule module) {
        this.module = module;
        this.addEditOptions(module);
        this.addRemoveOptions(module);
    }

    private void addEditOptions(E2EBuilderModule module) {
        this.editOptions = ComponentFactory.createMenuItem((String)"popup.menu.item.edit.options", (E2EBuilderModule)module);
        this.editOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPopupMenu.this.editOptions();
            }
        });
        this.add(this.editOptions);
    }

    private void addRemoveOptions(E2EBuilderModule module) {
        this.removeOptions = ComponentFactory.createMenuItem((String)"popup.menu.item.remove.options", (E2EBuilderModule)module);
        this.removeOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPopupMenu.this.removeOptions();
            }
        });
        this.add(this.removeOptions);
    }

    public void setOptionContainer(OptionContainer options, boolean readOnly) {
        this.editOptions.setText(this.module.getTranslation(readOnly ? "popup.menu.item.show.options" : "popup.menu.item.edit.options"));
        boolean canWrite = options.getOwner().canWrite();
        this.removeOptions.setVisible(!readOnly);
        this.editOptions.setEnabled(canWrite);
        this.removeOptions.setEnabled(canWrite);
        this.options = options;
    }

    private void editOptions() {
        OptionContainer inheritedOptions = ((TreeTestSuite)this.options.getOwner()).getInheritedOptions(this.options.getType(), false);
        Utilities.mergeOptions((OptionContainer)inheritedOptions, (OptionContainer)this.options);
        this.options.getNameOption().clearDependencies();
        this.options.getNameOption().setValue(null);
        this.options.getNameOption().setDefaultValue(null);
        this.options.getNameOption().setVisible(false);
        OptionsDialog.getInstance(this.module).editOptions(this.options, false, false);
    }

    private void removeOptions() {
        EventController.fire((EventObject)new RemoveOptionsEvent(this, this.options));
    }
}

