/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui.swing;

import ch.e2e.builder.regtest.gui.swing.TextFieldOptionPane;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.RegexTextField;
import ch.e2e.test.options.StringOption;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class StringOptionPane
extends TextFieldOptionPane<String, StringOption> {
    private RegexTextField textField;
    private JLabel nameLabel;
    private StringOption option;

    public StringOptionPane() {
        this.createGui();
    }

    @Override
    public String getValue() {
        return this.textField.getText().isEmpty() ? null : this.textField.getText();
    }

    @Override
    public void setValue(String value) {
        this.setText(value);
    }

    @Override
    public StringOption getOption() {
        return this.option;
    }

    @Override
    public void setOption(StringOption option) {
        this.option = option;
        this.nameLabel.setText(option.getName());
        this.textField.setPattern(option.getPattern());
        super.setOption(option);
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.textField.requestFocusInWindow();
    }

    @Override
    protected JTextField getTextField() {
        return this.textField;
    }

    private void createGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 2;
        this.nameLabel = new JLabel();
        this.nameLabel.setBorder(new EmptyBorder(0, 0, 2, 0));
        this.add((Component)this.nameLabel, c);
        this.textField = new RegexTextField(".*");
        this.textField.addInputFieldListener(new InputFieldListener(){

            public void inputFieldChanged(InputFieldEvent e) {
                StringOptionPane.this.inputChanged();
            }
        });
        this.textField.setRequestFocusEnabled(true);
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                boolean dummy = false;
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        c.weighty = 1.0;
        c.anchor = 18;
        this.add((Component)this.textField, c);
    }

    private void setText(String value) {
        this.setFireOptionInputChanged(false);
        this.textField.setText(value);
        this.setFireOptionInputChanged(true);
    }
}

