/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui.swing;

import ch.e2e.builder.regtest.gui.swing.TextFieldOptionPane;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.InputIntegerField;
import ch.e2e.test.options.IntegerOption;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class IntegerOptionPane
extends TextFieldOptionPane<Integer, IntegerOption> {
    private InputIntegerField textField;
    private JLabel nameLabel;
    private IntegerOption option;

    public IntegerOptionPane() {
        this.createGui();
    }

    @Override
    protected JTextField getTextField() {
        return this.textField;
    }

    @Override
    public Integer getValue() {
        return (Integer)this.textField.getValue();
    }

    @Override
    public void setValue(Integer value) {
        this.setText(value);
    }

    @Override
    public IntegerOption getOption() {
        return this.option;
    }

    @Override
    public void setOption(IntegerOption option) {
        this.option = option;
        this.nameLabel.setText(option.getName());
        this.textField.setMinimum((double)option.getMinValue());
        this.textField.setMaximum((double)option.getMaxValue());
        this.textField.doLayout();
        Dimension size = this.textField.getPreferredSize();
        this.textField.setMinimumSize(size);
        super.setOption(option);
    }

    private void setText(Integer value) {
        this.setFireOptionInputChanged(false);
        this.textField.setValue((Object)value);
        this.setFireOptionInputChanged(true);
    }

    private void createGui() {
        this.setLayout(new GridLayout(2, 1));
        this.nameLabel = new JLabel();
        this.nameLabel.setBorder(new EmptyBorder(0, 0, 2, 0));
        this.add(this.nameLabel);
        this.textField = new InputIntegerField(Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.textField.addInputFieldListener(new InputFieldListener(){

            public void inputFieldChanged(InputFieldEvent e) {
                IntegerOptionPane.this.inputChanged();
            }
        });
        this.add((Component)this.textField);
    }
}

