/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.gui.TestSuiteChoicePanel;
import ch.e2e.builder.regtest.gui.TestSuiteSettings;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.FixedHeightLabel;
import ch.e2e.swing.MultiLineLabel;
import ch.e2e.swing.RegexTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class TestSuiteNameFinder
extends E2EBuilderDialog {
    private static TestSuiteNameFinder nameFinder;
    private String errorNoName;
    private String errorNameExists;
    private RegexTextField nameInput;
    private TestSuiteChoicePanel choicePanel;
    private FixedHeightLabel problem;
    private E2EBuilderModule module;
    private MultiLineLabel messageLabel;

    private TestSuiteNameFinder(E2EBuilderModule module) {
        super(module.getTranslation("create.test.suite.input.name.title"), module.getTranslation("create.test.suite.input.name.internaltitle"), module.getTranslation("create.test.suite.input.name.subtitle"), 3);
        this.module = module;
        this.createGui();
    }

    public static TestSuiteNameFinder getInstance(E2EBuilderModule module) {
        if (nameFinder == null) {
            nameFinder = new TestSuiteNameFinder(module);
        }
        return nameFinder;
    }

    public TestSuiteSettings findTestSuiteName(String defaultName, TreeTestSuite selection, boolean showTestSuiteSelection) {
        this.setTitle(this.module.getTranslation("create.test.suite.input.name.title"));
        this.setSubtitle(this.module.getTranslation("create.test.suite.input.name.subtitle"));
        this.setInternalTitle(this.module.getTranslation("create.test.suite.input.name.internaltitle"));
        this.messageLabel.setText(this.module.getTranslation("create.test.suite.input.name.message"));
        this.errorNoName = this.module.getTranslation("create.test.suite.input.name.error.no.name");
        this.errorNameExists = this.module.getTranslation("create.test.suite.input.name.error.name.exists");
        TestSuiteSettings result = null;
        this.choicePanel.setTestSuite(selection, showTestSuiteSelection);
        this.nameInput.setPattern(this.module.getTranslation("create.test.suite.input.name.pattern"));
        this.nameInput.setText(defaultName == null ? "" : defaultName);
        this.checkOkButton();
        this.nameInput.setSelectionStart(0);
        this.nameInput.setSelectionEnd(this.nameInput.getText().length() - 1);
        this.nameInput.requestFocus();
        if (this.showDialog() == 1) {
            result = new TestSuiteSettings(this.choicePanel.getSelectedTestSuite(), this.choicePanel.getSelectionIndex());
            result.setName(this.nameInput.getText());
        }
        return result;
    }

    public TestSuiteSettings findLibraryName(String defaultName, LibrariesRoot libraries) {
        this.setTitle(this.module.getTranslation("create.library.input.name.title"));
        this.setSubtitle(this.module.getTranslation("create.library.input.name.subtitle"));
        this.setInternalTitle(this.module.getTranslation("create.library.input.name.internaltitle"));
        this.messageLabel.setText(this.module.getTranslation("create.library.input.name.message"));
        this.nameInput.setPattern(this.module.getTranslation("create.library.input.name.pattern"));
        this.nameInput.setText(defaultName == null ? "" : defaultName);
        this.errorNoName = this.module.getTranslation("create.library.input.name.error.no.name");
        this.errorNameExists = this.module.getTranslation("create.library.input.name.error.name.exists");
        TestSuiteSettings result = null;
        this.choicePanel.setLibrariesRoot(libraries);
        this.checkOkButton();
        if (this.showDialog() == 1) {
            result = new TestSuiteSettings(this.choicePanel.getSelectedTestSuite(), this.choicePanel.getSelectionIndex());
            result.setName(this.nameInput.getText());
        }
        return result;
    }

    public int getMinimumWidth() {
        return 330;
    }

    private void createGui() {
        this.choicePanel = new TestSuiteChoicePanel(this.module);
        this.choicePanel.setBorder(BorderFactory.createEmptyBorder(3, 10, 0, 10));
        this.add(this.choicePanel, "North");
        this.addNameInput(this.module);
        this.problem = new FixedHeightLabel();
        this.problem.setForeground(Color.RED);
        this.problem.setBorder(BorderFactory.createEmptyBorder(0, 14, 3, 5));
        this.add((Component)this.problem, "South");
        this.choicePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuiteNameFinder.this.checkOkButton();
            }
        });
    }

    private void addNameInput(E2EBuilderModule module) {
        String message = module.getTranslation("create.test.suite.input.name.message");
        String pattern = module.getTranslation("create.test.suite.input.name.pattern");
        JPanel center = new JPanel(new BorderLayout());
        center.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        this.messageLabel = new MultiLineLabel("");
        this.messageLabel.setHorizontalAlignment(2);
        this.messageLabel.setText(message);
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 5));
        center.add((Component)this.messageLabel, "North");
        this.nameInput = new RegexTextField(pattern == null ? ".*" : pattern, 30);
        this.setOkButtonEnabled(false);
        this.nameInput.addInputFieldListener(new InputFieldListener(){

            public void inputFieldChanged(InputFieldEvent e) {
                TestSuiteNameFinder.this.checkOkButton();
            }
        });
        this.nameInput.setText("");
        center.add((Component)this.nameInput, "Center");
        this.nameInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestSuiteNameFinder.this.okDialog();
            }
        });
        this.add(center, "Center");
    }

    private void checkOkButton() {
        this.setOkButtonEnabled(this.nameInput.getText().length() != 0 && !this.choicePanel.existsName(this.nameInput.getText()));
        if (this.nameInput.getText().length() == 0) {
            this.problem.setText(this.errorNoName);
        } else if (this.choicePanel.existsName(this.nameInput.getText())) {
            this.problem.setText(this.errorNameExists);
        } else {
            this.problem.setText("");
        }
    }
}

