/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.testsuite.TestSuiteOptions;
import ch.e2e.builder.regtest.tools.TestClassFactory;
import ch.e2e.swing.model.SortedListModel;
import ch.e2e.test.TestType;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectOptionTypeDialog
extends E2EBuilderDialog {
    private ArrayList<TestType> optionTypes;
    private SortedListModel<TestType> listModel;
    private JList list;

    public SelectOptionTypeDialog(E2EBuilderModule module) {
        super(module.getTranslation("add.option.select.type.title"), module.getTranslation("add.option.select.type.internaltitle"), module.getTranslation("add.option.select.type.subtitle"), 3);
        this.createGui(module);
    }

    public TestType selectOptionType(TestSuiteOptions options) {
        ArrayList<TestType> selectCollection = new ArrayList<TestType>(this.optionTypes);
        selectCollection.removeAll(options.getKeys());
        this.listModel.removeAll();
        this.listModel.addAll(selectCollection);
        TestType result = null;
        this.list.clearSelection();
        this.setOkButtonEnabled(false);
        if (this.showDialog() == 1) {
            result = (TestType)this.list.getSelectedValue();
        }
        return result;
    }

    public int getMinimumWidth() {
        return 300;
    }

    public int getMinimumHeight() {
        return 250;
    }

    private void createGui(E2EBuilderModule module) {
        Collection<TestType> testActions = TestClassFactory.getInstance().getOptionContainer().values();
        this.optionTypes = new ArrayList<TestType>(testActions);
        this.listModel = new SortedListModel();
        this.listModel.addAll(this.optionTypes);
        this.list = new JList<TestType>((ListModel<TestType>)this.listModel);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new TestTypeListCellRenderer());
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectOptionTypeDialog.this.setOkButtonEnabled(SelectOptionTypeDialog.this.list.getSelectedValue() != null);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SelectOptionTypeDialog.this.okDialog();
                }
            }
        });
        this.add(this.list);
    }

    private class TestTypeListCellRenderer
    extends DefaultListCellRenderer {
        private TestTypeListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof TestType && result instanceof JLabel) {
                ((JLabel)result).setIcon(((TestType)value).getIcon());
            }
            return result;
        }
    }
}

