/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.event.SelectTestcaseEvent;
import ch.e2e.builder.regtest.event.TestUnitFinishedEvent;
import ch.e2e.builder.regtest.event.TestUnitStartEvent;
import ch.e2e.builder.regtest.gui.DiffPane;
import ch.e2e.builder.regtest.gui.TestSuiteTreeCellRenderer;
import ch.e2e.builder.regtest.model.ErrorViewTreeModel;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.test.E2ETest;
import ch.e2e.test.E2ETestcase;
import ch.e2e.test.ErrorElement;
import ch.e2e.test.TestErrorEvent;
import ch.e2e.test.TestFailureEvent;
import ch.e2e.test.TestSelectedEvent;
import ch.e2e.test.Testable;
import ch.e2e.test.Utilities;
import java.awt.Component;
import java.util.EventObject;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ErrorTreeView
extends JScrollPane
implements TreeSelectionListener {
    private ErrorViewTreeModel model;
    private Tree tree;
    private TreeSelectionListener runListener;
    private List<Testable> selectedTests;

    public ErrorTreeView(E2EBuilderModule module, final DiffPane diffPane) {
        super(20, 30);
        this.createGui(module);
        this.addEventHandler();
        this.runListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ErrorTreeView.this.showError(e, diffPane);
            }
        };
    }

    public void testSelected(TestSelectedEvent event) {
        List newSelectedTests = event.getTests();
        if (this.selectedTests == null || !this.selectedTests.equals(newSelectedTests)) {
            this.tree.removeTreeSelectionListener(this.runListener);
            this.model.clear();
            this.tree.clearSelection();
            for (Testable test : newSelectedTests) {
                this.collectErrors(test);
            }
            this.tree.addTreeSelectionListener(this.runListener);
            this.selectedTests = newSelectedTests;
        }
    }

    private void collectErrors(Testable testable) {
        if (testable instanceof TreeTestSuite) {
            for (Testable testcase : ((TreeTestSuite)testable).getTestcases()) {
                this.collectErrors(testcase);
            }
        } else if (testable instanceof Testcase && !((Testcase)testable).getErrors().isEmpty()) {
            this.model.addTestcase((Testcase)testable);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.fireTestcaseSelected();
    }

    public void clear() {
    }

    public void refresh(E2ETestcase testcase) {
    }

    private void createGui(E2EBuilderModule module) {
        this.model = new ErrorViewTreeModel();
        TestSuiteTreeCellRenderer renderer = new TestSuiteTreeCellRenderer(this.model);
        this.tree = new Tree((AbstractTreeModel)this.model, (TreeCellRenderer)((Object)renderer));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(false);
        this.tree.setToolTipsEnabled(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.setViewportView((Component)this.tree);
    }

    private void addEventHandler() {
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                ErrorTreeView.this.testError(event.getSource());
            }
        }, TestErrorEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                ErrorTreeView.this.testError(event.getSource());
            }
        }, TestFailureEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                ErrorTreeView.this.testUnitStarting();
            }
        }, TestUnitStartEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                ErrorTreeView.this.testUnitFinished();
            }
        }, TestUnitFinishedEvent.class);
    }

    private void testUnitFinished() {
        this.tree.removeTreeSelectionListener(this.runListener);
        this.tree.addTreeSelectionListener((TreeSelectionListener)this);
    }

    public void fireTestcaseSelected() {
        TreePath selection = this.tree.getSelectionPath();
        Testcase selectedTestcase = null;
        if (selection != null) {
            if (selection.getLastPathComponent() instanceof ErrorElement) {
                E2ETest test = ((ErrorElement)selection.getLastPathComponent()).getOwner();
                if (test.getOwner() instanceof Testcase) {
                    selectedTestcase = (Testcase)test.getOwner();
                }
            } else if (selection.getLastPathComponent() instanceof Testcase) {
                selectedTestcase = (Testcase)selection.getLastPathComponent();
            }
        }
        if (selectedTestcase != null) {
            EventController.fire((EventObject)new SelectTestcaseEvent(this, selectedTestcase));
        }
    }

    private void testUnitStarting() {
        this.tree.removeTreeSelectionListener(this.runListener);
        this.model.clear();
        this.tree.clearSelection();
        this.tree.addTreeSelectionListener(this.runListener);
    }

    private void testError(Object source) {
        if (source instanceof E2ETest && ((E2ETest)source).getOwner() instanceof Testcase) {
            this.tree.removeTreeSelectionListener(this.runListener);
            TreePath selectedPath = this.tree.getSelectionPath();
            this.model.addTestcase((Testcase)((E2ETest)source).getOwner());
            this.tree.setSelectionPath(selectedPath);
            this.tree.addTreeSelectionListener(this.runListener);
        }
    }

    private void showError(TreeSelectionEvent e, DiffPane diffPane) {
        Object lastPathComponent;
        if (e.getNewLeadSelectionPath() != null && (lastPathComponent = e.getNewLeadSelectionPath().getLastPathComponent()) instanceof Testcase) {
            Testcase testcase = (Testcase)lastPathComponent;
            Utilities.replaceProperties((E2ETestcase)testcase);
            diffPane.setTestcase(testcase, null);
        }
    }
}

