/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.tree;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.execute.TestcaseRunListener;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeEvent;
import ch.e2e.builder.trace.gui.tree.TestcaseTreeListener;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.tree.ClearTestcaseExecuter;
import ch.e2e.builder.trace.tree.CopyTestcaseExecuter;
import ch.e2e.builder.trace.tree.CreateTestcaseExecuter;
import ch.e2e.builder.trace.tree.DeleteTestcaseExecuter;
import ch.e2e.builder.trace.tree.EditPreferencesExecuter;
import ch.e2e.builder.trace.tree.ExportTestcaseExecuter;
import ch.e2e.builder.trace.tree.MockBackendsExecuter;
import ch.e2e.builder.trace.tree.RenameTestcaseExecuter;
import ch.e2e.builder.trace.tree.RunTestcaseExecuter;
import java.util.Collection;

public class DefaultTestcaseTreeListener
implements TestcaseTreeListener {
    private CreateTestcaseExecuter createExecuter;
    private ClearTestcaseExecuter clearExecuter;
    private CopyTestcaseExecuter copyExecuter;
    private DeleteTestcaseExecuter deleteExecuter;
    private ExportTestcaseExecuter exportExecuter;
    private RenameTestcaseExecuter renameExecuter;
    private RunTestcaseExecuter runExecuter;
    private EditPreferencesExecuter editExecuter;
    private Collection<? extends TestcaseRunListener> runListeners;
    private MockBackendsExecuter mockBackendsExecuter;

    public DefaultTestcaseTreeListener(E2EBuilderModule module, Collection<? extends TestcaseRunListener> runListeners, boolean showTraceProperties) {
        this.runListeners = runListeners;
        String testcaseInputPattern = module.getTranslation("testcase.input.pattern");
        this.createExecuter = new CreateTestcaseExecuter(testcaseInputPattern, module);
        this.clearExecuter = new ClearTestcaseExecuter(module);
        this.copyExecuter = new CopyTestcaseExecuter(testcaseInputPattern, module);
        this.deleteExecuter = new DeleteTestcaseExecuter(module);
        this.exportExecuter = new ExportTestcaseExecuter(testcaseInputPattern, module);
        this.renameExecuter = new RenameTestcaseExecuter(testcaseInputPattern, module);
        this.runExecuter = new RunTestcaseExecuter(module);
        this.editExecuter = new EditPreferencesExecuter(module, showTraceProperties);
        this.mockBackendsExecuter = new MockBackendsExecuter(module, showTraceProperties);
    }

    @Override
    public void clearTestcase(TestcaseTreeEvent event) {
        this.clearExecuter.clearTestcase(event.getTestcase());
    }

    @Override
    public void createTestcase(TestcaseTreeEvent event) {
        this.createExecuter.createTestcase(event.getTestcaseFolder());
    }

    @Override
    public void copyTestcase(TestcaseTreeEvent event) {
        this.copyExecuter.copyTestcase(event.getTestcase(), event.getTestcaseFolder());
    }

    public void copyTestcase(AbstractSynchronousTestcase testcase) {
        this.copyExecuter.copyTestcase(testcase);
    }

    @Override
    public void deleteTestcase(TestcaseTreeEvent event) {
        this.deleteExecuter.deleteTestcase((Testcase)event.getTestcase());
    }

    public void deleteTestcase(AbstractSynchronousTestcase testcase) {
        this.deleteExecuter.deleteTestcase((Testcase)testcase);
    }

    @Override
    public void exportTestcase(TestcaseTreeEvent event) {
        this.exportExecuter.exportTestcase(event.getTestcase());
    }

    @Override
    public void editPreferences(TestcaseTreeEvent event) {
        this.editExecuter.editPreferences(event.getTestcase());
    }

    @Override
    public void mockBackendsManually(TestcaseTreeEvent event) {
        this.mockBackendsExecuter.editPreferences(event.getTestcase(), event.getAdapter());
    }

    @Override
    public void mockBackends(TestcaseTreeEvent event) {
        this.mockBackendsExecuter.loadMockBackends(event.getTestcase());
    }

    @Override
    public void renameTestcase(TestcaseTreeEvent event) {
        this.renameExecuter.renameTestcase(event.getTestcase());
    }

    public void renameTestcase(AbstractSynchronousTestcase testcase) {
        this.renameExecuter.renameTestcase(testcase);
    }

    @Override
    public void runTestcase(TestcaseTreeEvent event) {
        this.runExecuter.runTestcase(event.getTestcase(), this.runListeners);
    }

    protected RunTestcaseExecuter getRunExecuter() {
        return this.runExecuter;
    }

    protected Collection<? extends TestcaseRunListener> getRunListeners() {
        return this.runListeners;
    }
}

