/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.watch;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.model.TreeModel;
import ch.e2e.builder.trace.gui.testcase.ViewTestcaseParameterAction;
import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.request.Request;
import java.awt.event.ActionListener;
import javax.swing.tree.TreePath;

public abstract class AbstractWatchTreeModel
extends TreeModel {
    private final E2EBuilderModule module;
    private final ViewTestcaseParameterAction showValueAction;

    public AbstractWatchTreeModel(E2EBuilderModule module) {
        super("ch.e2e.builder.trace.properties.watches");
        this.module = module;
        this.showValueAction = new ViewTestcaseParameterAction(module);
    }

    public E2EBuilderModule getModule() {
        return this.module;
    }

    @Override
    public int getType(Object value) {
        int result = value instanceof TestcaseParameter ? ((TestcaseParameter)value).getType() : (value instanceof Request ? ((Request)value).getType() : super.getType(value));
        return result;
    }

    public String getTypeString(int type) {
        String result = null;
        switch (type) {
            case 10004: {
                result = "watches.array";
                break;
            }
            case 10005: {
                result = "watches.blob";
                break;
            }
            case 10006: {
                result = "watches.boolean";
                break;
            }
            case 10009: {
                result = "watches.complex";
                break;
            }
            case 10010: {
                result = "watches.datetime";
                break;
            }
            case 10011: {
                result = "watches.float";
                break;
            }
            case 10014: {
                result = "watches.integer";
                break;
            }
            case 10019: {
                result = "watches.string";
                break;
            }
            case 10045: {
                result = "watches.ellipsis";
                break;
            }
            case 10048: {
                result = "watches.exception";
            }
        }
        return result;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return super.getIndexOfChild(parent, child);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public ActionListener getExecuteAction(TreePath[] paths) {
        ActionListener actionListener;
        Object component = paths[0].getLastPathComponent();
        if (component instanceof TestcaseParameter) {
            if (((TestcaseParameter)component).isSimpleType()) {
                this.showValueAction.setParameter((TestcaseParameter)component);
                actionListener = this.showValueAction;
            } else {
                actionListener = super.getExecuteAction(paths);
            }
        } else {
            this.showValueAction.setParameter(null);
            actionListener = super.getExecuteAction(paths);
        }
        return actionListener;
    }
}

