/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.sequence;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.gui.uml.UmlCellViewFactory;
import ch.e2e.builder.trace.gui.uml.UmlGraph;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.gui.uml.activity.InfoCell;
import ch.e2e.builder.trace.gui.uml.sequence.ActivationBoxCell;
import ch.e2e.builder.trace.gui.uml.sequence.CallMessageEdge;
import ch.e2e.builder.trace.gui.uml.sequence.LifelineCell;
import ch.e2e.builder.trace.gui.uml.sequence.ReplyMessageEdge;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseWatch;
import ch.e2e.builder.trace.testcase.uml.Activity;
import ch.e2e.builder.trace.testcase.uml.Adapter;
import ch.e2e.builder.trace.testcase.uml.AdapterIO;
import ch.e2e.builder.trace.testcase.uml.Flow;
import ch.e2e.builder.trace.testcase.uml.Postprocessor;
import ch.e2e.builder.trace.testcase.uml.Preprocessor;
import ch.e2e.builder.trace.testcase.uml.RootObject;
import ch.e2e.builder.trace.testcase.uml.Script;
import ch.e2e.builder.trace.testcase.uml.ScriptObject;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlObjectVisitor;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;

public class SequenceGraphBuilder
extends UmlObjectVisitor {
    private static final String TITLE = "Overview: Client - Service - Backend Interactions";
    private static final double OFFSET_X = 10.0;
    private static final double BACKEND_ACTIVATION_BOX_HEIGHT = 30.0;
    private static final double BACKEND_OFFSET_X = 500.0;
    private static final double LIFELINE_SPACE = 195.0;
    private static final double LIFELINE_MIN_HEIGHT = 100.0;
    private Testcase testcase;
    private E2ETraceModule module;
    private UmlGraph graph;
    private List<DefaultGraphCell> cells;
    private List<LifelineCell> lifelines;
    private List<Adapter> adapters;
    private Map<String, Map<String, LifelineCell>> backends = new LinkedHashMap<String, Map<String, LifelineCell>>();
    private double lifelineHeight;
    private Preprocessor preprocessor;
    private Postprocessor postprocessor;
    private RootObject root;

    public SequenceGraphBuilder(Testcase testcase, UmlTree tree, E2ETraceModule module) {
        this.testcase = testcase;
        this.module = module;
        this.cells = new ArrayList<DefaultGraphCell>();
        this.lifelines = new ArrayList<LifelineCell>();
        this.adapters = new ArrayList<Adapter>();
        this.initializeGraph();
        if (tree == null) {
            this.cells.add(new InfoCell(this.getMessage(testcase), TITLE));
        } else {
            this.visit(tree);
        }
        this.graph.getGraphLayoutCache().insert(this.getCells());
        this.graph.setRunDate(new Date().getTime());
    }

    private String getMessage(Testcase testcase) {
        String msgKey;
        if (testcase.getStatus() == 8) {
            int idx = testcase.getResponseWatches().size() > 1 ? 1 : 0;
            Object watch = testcase.getResponseWatches().get(idx);
            msgKey = watch instanceof TestcaseWatch ? ((TestcaseWatch)watch).getValueAsString() : watch.toString();
        } else {
            msgKey = testcase.getStatus() == 7 ? "testcase.not.run.subtitle" : (!testcase.getTraceSettings().isEnabled() ? "testcase.trace.not.enabled.subtitle" : "testcase.compiler.trace.flag.not.set.subtitle");
        }
        return this.module.getTranslation(msgKey, msgKey);
    }

    private void initializeGraph() {
        DefaultGraphModel model = new DefaultGraphModel();
        this.graph = new UmlGraph(this.module, (GraphModel)model, new GraphLayoutCache((GraphModel)model, (CellViewFactory)new UmlCellViewFactory()));
    }

    public UmlGraph getGraph() {
        return this.graph;
    }

    public void visit(UmlTree tree) {
        this.cells.clear();
        this.lifelines.clear();
        this.backends.clear();
        this.visitChilds((UmlObject)tree);
        this.lifelineHeight = Math.max((double)(2 * this.adapters.size() + 1) * 30.0, 100.0) + 60.0 + 10.0 + 10.0;
        InfoCell info = new InfoCell(this.testcase, TITLE);
        this.cells.add(info);
        double y = info.getMaxY() + 35.0;
        this.createClientLifeline(y);
        this.createPortLifeline(y);
        this.createBackendLifelines(y);
    }

    public void visit(Script script) {
        this.visitChilds((UmlObject)script);
    }

    public void visit(ScriptObject object) {
        this.visitChilds((UmlObject)object);
    }

    public void visit(Preprocessor preprocessor) {
        this.preprocessor = preprocessor;
    }

    public void visit(RootObject root) {
        this.root = root;
        this.cells.clear();
        this.lifelines.clear();
        this.backends.clear();
        this.visitChilds((UmlObject)root);
    }

    public void visit(Postprocessor postprocessor) {
        this.postprocessor = postprocessor;
    }

    public Object[] getCells() {
        return this.cells.toArray();
    }

    public void visit(Flow flow) {
        this.visitChilds((UmlObject)flow);
    }

    public void visit(Activity activity) {
        this.visitChilds((UmlObject)activity);
    }

    public void visit(Adapter adapter) {
        if (adapter.isMockup()) {
            this.adapters.add(adapter);
        } else {
            this.visitChilds((UmlObject)adapter, AdapterIO.class);
        }
    }

    public void visit(AdapterIO adapterIO) {
        if (adapterIO.getTarget() != null || adapterIO.getSource() != null) {
            this.adapters.add((Adapter)adapterIO.getParent());
        }
    }

    private void createClientLifeline(double y) {
        LifelineCell lifeline = new LifelineCell(":Client", 10.0, y, this.lifelineHeight);
        this.cells.addAll(lifeline.getCells());
        this.lifelines.add(lifeline);
        ActivationBoxCell activationBox = new ActivationBoxCell(y + 25.0 + 30.0, this.lifelineHeight - 60.0 - 25.0);
        this.cells.add(activationBox);
        lifeline.addActivationBox(activationBox);
    }

    private void createPortLifeline(double y) {
        LifelineCell lifeline = new LifelineCell(this.getPorttype(), 205.0, y, this.lifelineHeight);
        this.cells.addAll(lifeline.getCells());
        this.lifelines.add(lifeline);
        ActivationBoxCell activationBox = new ActivationBoxCell(y + 25.0 + 30.0 + 10.0, this.lifelineHeight - 60.0 - 25.0 - 10.0);
        this.cells.add(activationBox);
        lifeline.addActivationBox(activationBox);
        LifelineCell clientLifeline = this.lifelines.get(0);
        ActivationBoxCell clientActivationBox = clientLifeline.getActivationBox(0);
        Rectangle2D bounds = UmlGraphConstants.getBounds((Map)clientActivationBox.getAttributes());
        Point2D.Double p = new Point2D.Double(1000.0, 10.0 / (bounds.getHeight() - 1.0) * 1000.0);
        Port port = (Port)clientActivationBox.addPort(p);
        this.cells.add((DefaultGraphCell)new CallMessageEdge((Object)this.root, this.preprocessor, port, activationBox.getCallMessagePort(), (E2EBuilderModule)this.module));
        p = new Point2D.Double(1000.0, 1000.0);
        port = (Port)clientActivationBox.addPort(p);
        this.cells.add((DefaultGraphCell)new ReplyMessageEdge((Object)this.testcase, this.postprocessor, activationBox.getReplyMessagePort(), port, (E2EBuilderModule)this.module));
    }

    private void createBackendLifelines(double y) {
        double x = 510.0;
        double dx = 195.0;
        for (Adapter adapter : this.adapters) {
            LifelineCell lifeline;
            Map<String, LifelineCell> backend;
            String value;
            String type = adapter.getAdapterType();
            if (type == null) {
                type = "unkown";
            }
            if ((value = adapter.getTarget()) == null) {
                value = adapter.getSource();
            }
            if (value == null) {
                value = "unkown";
            }
            if ((backend = this.backends.get(type)) == null) {
                backend = new LinkedHashMap<String, LifelineCell>();
                this.backends.put(type, backend);
            }
            if ((lifeline = backend.get(value)) != null) continue;
            lifeline = new LifelineCell(type + ":" + value, x, y, this.lifelineHeight);
            this.cells.addAll(lifeline.getCells());
            this.lifelines.add(lifeline);
            backend.put(value, lifeline);
            x += dx;
        }
        LifelineCell portLifeline = this.lifelines.get(1);
        ActivationBoxCell portActivationBox = portLifeline.getActivationBox(0);
        Rectangle2D bounds = UmlGraphConstants.getBounds((Map)portActivationBox.getAttributes());
        double height = (double)(2 * this.adapters.size() - 1) * 30.0;
        double yOffset = bounds.getY() + (bounds.getHeight() - height) * 0.5;
        double dy = 60.0;
        for (Adapter adapter : this.adapters) {
            String value;
            String type = adapter.getAdapterType();
            if (type == null) {
                type = "unkown";
            }
            if ((value = adapter.getTarget()) == null) {
                value = adapter.getSource();
            }
            if (value == null) {
                value = "unknown";
            }
            LifelineCell lifeline = this.backends.get(type).get(value);
            ActivationBoxCell activationBox = new ActivationBoxCell(adapter, yOffset, 30.0);
            this.cells.add(activationBox);
            lifeline.addActivationBox(activationBox);
            Point2D.Double p = new Point2D.Double(1000.0, (yOffset - bounds.getY()) / (bounds.getHeight() - 1.0) * 1000.0);
            Port port = (Port)portActivationBox.addPort(p);
            this.cells.add((DefaultGraphCell)new CallMessageEdge(adapter, port, activationBox.getCallMessagePort(), this.module));
            p = new Point2D.Double(1000.0, (yOffset + 30.0 - bounds.getY()) / bounds.getHeight() * 1000.0);
            port = (Port)portActivationBox.addPort(p);
            this.cells.add((DefaultGraphCell)new ReplyMessageEdge(adapter, activationBox.getReplyMessagePort(), port, this.module));
            yOffset += dy;
        }
    }

    private String getPorttype() {
        String name;
        block3: {
            name = "";
            try {
                Method m = this.testcase.getClass().getMethod("getPorttype", new Class[0]);
                name = ":" + m.invoke((Object)this.testcase, new Object[0]);
            }
            catch (Exception e) {
                if (this.root == null) break block3;
                Pattern p = Pattern.compile("urn:([^\\.]+\\.)*(.*)");
                Matcher m = p.matcher(this.root.getOriginalName());
                if (m.matches()) {
                    name = m.group(1);
                    name = ":" + name.substring(0, name.length() - 1);
                }
                name = ":" + this.root.getName();
            }
        }
        return name;
    }
}

