/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.sequence;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.gui.uml.sequence.MessageEdge;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseWatch;
import ch.e2e.builder.trace.testcase.uml.Adapter;
import ch.e2e.builder.trace.testcase.uml.AdapterIO;
import ch.e2e.builder.trace.testcase.uml.DataContainer;
import ch.e2e.builder.trace.testcase.uml.Flow;
import ch.e2e.builder.trace.testcase.uml.Message;
import ch.e2e.builder.trace.testcase.uml.Postprocessor;
import ch.e2e.builder.trace.testcase.uml.Processor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Map;
import org.jgraph.graph.Port;

public class ReplyMessageEdge
extends MessageEdge {
    private static final String RETURN = "return";

    public ReplyMessageEdge(Object userObject, Port sourcePort, Port targetPort, E2EBuilderModule module) {
        this(userObject, (Postprocessor)null, sourcePort, targetPort, module);
    }

    public ReplyMessageEdge(Object userObject, Postprocessor postprocessor, Port sourcePort, Port targetPort, E2EBuilderModule module) {
        super(userObject, (Processor)postprocessor, sourcePort, targetPort, module);
        this.initialize(postprocessor);
    }

    private void initialize(Postprocessor postprocessor) {
        UmlGraphConstants.setLabelPosition((Map)this.attributes, (Point2D)new Point2D.Double(500.0, 10.0));
        UmlGraphConstants.setDashPattern((Map)this.attributes, (float[])UmlGraphConstants.DASH_PATTERN);
        UmlGraphConstants.setLineEnd((Map)this.attributes, (int)4);
        if (postprocessor != null) {
            UmlGraphConstants.setSelectable((Map)this.attributes, (boolean)true);
            UmlGraphConstants.setExtraLabels((Map)this.attributes, (Object[])new Object[]{postprocessor});
            UmlGraphConstants.setExtraLabelPositions((Map)this.attributes, (Point2D[])new Point2D[]{new Point2D.Double(500.0, -11.0)});
        }
    }

    @Override
    public Cursor getCursor() {
        if (this.parametersModel.size() > 0 || this.adapterIOModel.size() > 0) {
            return Cursor.getPredefinedCursor(12);
        }
        return null;
    }

    @Override
    protected void initializeParameters(Object userObject) {
        this.parametersModel = new MessageEdge.MessageDataModel();
        boolean error = false;
        if (userObject instanceof Testcase) {
            Testcase testcase = (Testcase)userObject;
            if (testcase.isRPCEncoding()) {
                ArrayList watches = testcase.getResponseWatches();
                for (Object watch : watches) {
                    if (!(watch instanceof TestcaseWatch)) continue;
                    this.parametersModel.add(watch);
                    if (!((TestcaseWatch)watch).getName().equals("faultcode")) continue;
                    error = true;
                }
            } else {
                Object root = testcase.getUmlTree().getChild(0);
                if (root instanceof Flow) {
                    DataContainer data;
                    Flow flow = (Flow)root;
                    if (flow.hasErrors()) {
                        error = true;
                    }
                    if ((data = flow.getOutput()) != null) {
                        for (int i = 0; i < data.getChildCount(); ++i) {
                            this.parametersModel.add(data.getChild(i));
                        }
                    }
                }
            }
        } else if (userObject instanceof Adapter) {
            Adapter adapter = (Adapter)userObject;
            if (adapter.hasErrors()) {
                error = true;
                for (int i = 0; i < adapter.getChildCount(); ++i) {
                    Object child = adapter.getChild(i);
                    if (!(child instanceof Message)) continue;
                    this.parametersModel.add(child);
                    break;
                }
            } else {
                DataContainer data = adapter.getOutput();
                for (int i = 0; i < data.getChildCount(); ++i) {
                    this.parametersModel.add(data.getChild(i));
                }
            }
        }
        this.parametersModel.setHasErrors(error);
        UmlGraphConstants.setForeground((Map)this.attributes, (Color)(error ? UmlGraphConstants.ERROR_COLOR : Color.BLUE));
    }

    @Override
    protected void initializeAdapterIO(Object userObject) {
        DataContainer container;
        AdapterIO io;
        this.adapterIOModel = new MessageEdge.MessageDataModel();
        if (userObject instanceof Adapter && (io = ((Adapter)userObject).getAdapterIO()) != null && (container = io.getOutput()) != null) {
            int n = container.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.adapterIOModel.add(container.getChild(i));
            }
        }
    }

    @Override
    public String toString() {
        return RETURN;
    }
}

