/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.gui.uml.ContextMenu;
import ch.e2e.builder.trace.gui.uml.UmlEdge;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.testcase.uml.Branches;
import ch.e2e.builder.trace.testcase.uml.Script;
import ch.e2e.event.EventController;
import ch.e2e.swing.MouseOverList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UnfoldedBranchesEdge
extends UmlEdge
implements CellWithContextMenu {
    private static EdgeContextMenu contextMenu;
    private BranchesModel branchesModel;
    private String label;

    public UnfoldedBranchesEdge(Object userObject, E2EBuilderModule module) {
        super(userObject, module);
        UmlGraphConstants.setDashPattern((Map)this.attributes, (float[])UmlGraphConstants.DASH_PATTERN);
        UmlGraphConstants.setLabelAlongEdge((Map)this.attributes, (boolean)true);
        List notFollowedBranches = ((Branches)userObject).getNotFollowedBranches();
        int nBranches = notFollowedBranches.size();
        this.label = nBranches + " not followed " + (nBranches > 1 ? "branches" : "branch");
        this.branchesModel = new BranchesModel(notFollowedBranches);
    }

    @Override
    public String toString() {
        return this.label;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public EdgeContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new EdgeContextMenu(this);
        }
        contextMenu.setCell(this);
        return contextMenu;
    }

    public AbstractCellAction<UnfoldedBranchesEdge> getDefaultAction() {
        return this.getContextMenu().getDefaultAction();
    }

    @Override
    public boolean isContextMenuAlwaysTriggered() {
        return true;
    }

    private static class BranchesModel
    extends ArrayList<Script>
    implements ListModel {
        public BranchesModel(Collection<? extends Script> scripts) {
            super(scripts);
        }

        @Override
        public int getSize() {
            return this.size();
        }

        public Object getElementAt(int index) {
            return this.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    private static class EdgeContextMenu
    extends ContextMenu<UnfoldedBranchesEdge> {
        private MouseOverList branches;

        public EdgeContextMenu(UnfoldedBranchesEdge cell) {
            super(cell);
            this.createMenu();
        }

        @Override
        public void setCell(UnfoldedBranchesEdge cell) {
            super.setCell(cell);
            this.branches.setModel((ListModel)cell.branchesModel);
            this.setItemEnabled(this.getTranslation("uml.diagram.action.show.not.followed.branches"), !cell.branchesModel.isEmpty());
            int dummy = 42;
        }

        @Override
        public AbstractCellAction<UnfoldedBranchesEdge> getDefaultAction() {
            return new AbstractCellAction<UnfoldedBranchesEdge>("gugus"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int dummy = 42;
                }
            };
        }

        private void createMenu() {
            this.branches = new MouseOverList((ListModel)((UnfoldedBranchesEdge)this.getCell()).branchesModel);
            this.branches.setSelectionMode(0);
            this.branches.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Script selected = (Script)branches.getSelectedValue();
                    if (selected != null) {
                        branches.clearSelection();
                        this.setVisible(false);
                        EventController.fire((EventObject)new OpenLinkEvent(this, "file:///showScript?script=" + selected.getIoId()));
                    }
                }
            });
            this.branches.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    this.setText("expession " + (index + 1));
                    return component;
                }
            });
            JMenu branchesMenu = new JMenu(this.getTranslation("uml.diagram.action.show.not.followed.branches"));
            branchesMenu.add((Component)this.branches);
            this.add(branchesMenu);
        }
    }
}

