/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.event.SelectInTreeEvent;
import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.gui.uml.ContextMenu;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.testcase.uml.Data;
import ch.e2e.builder.trace.testcase.uml.DataContainer;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.event.EventController;
import ch.e2e.swing.MouseOverList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.util.EventObject;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jgraph.graph.DefaultGraphCell;

public abstract class ExpansionNodeCell
extends DefaultGraphCell
implements CellWithContextMenu {
    private static ExpansionNodeMenu contextMenu;
    private final E2EBuilderModule module;
    private NodeListModel nodeListModel;

    public ExpansionNodeCell(Object userObject, E2EBuilderModule module) {
        super(userObject);
        this.module = module;
        this.nodeListModel = new NodeListModel((DataContainer)userObject);
        UmlGraphConstants.setBorderColor((Map)this.attributes, (Color)Color.BLACK);
        UmlGraphConstants.setOpaque((Map)this.attributes, (boolean)true);
        UmlGraphConstants.setDisconnectable((Map)this.attributes, (boolean)false);
    }

    @Override
    public E2EBuilderModule getModule() {
        return this.module;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    public ContextMenu<? extends CellWithContextMenu> getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new ExpansionNodeMenu(this);
        }
        contextMenu.setCell(this);
        return contextMenu;
    }

    @Override
    public AbstractCellAction<? extends CellWithContextMenu> getDefaultAction() {
        return this.getContextMenu().getDefaultAction();
    }

    @Override
    public boolean isContextMenuAlwaysTriggered() {
        return false;
    }

    public String toString() {
        return null;
    }

    private static class NodeListModel
    implements ListModel {
        private DataContainer container;

        private NodeListModel(DataContainer container) {
            this.container = container;
        }

        @Override
        public int getSize() {
            return this.container.getChildCount();
        }

        public Object getElementAt(int index) {
            return this.container.getChild(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    private static class ExpansionNodeMenu
    extends ContextMenu<ExpansionNodeCell> {
        private MouseOverList showNodeInTreeList;
        private MouseOverList showNodeValueList;

        public ExpansionNodeMenu(ExpansionNodeCell cell) {
            super(cell);
            this.createMenu();
        }

        @Override
        public void setCell(ExpansionNodeCell cell) {
            super.setCell(cell);
            this.showNodeInTreeList.setModel((ListModel)cell.nodeListModel);
            this.showNodeValueList.setModel((ListModel)cell.nodeListModel);
            boolean enabled = cell.nodeListModel.getSize() > 0;
            this.setItemEnabled(this.getTranslation("uml.diagram.action.show.in.tree"), enabled);
            this.setItemEnabled(this.getTranslation("uml.diagram.action.show.pin.value"), enabled);
        }

        private void createMenu() {
            this.showNodeInTreeList = new MouseOverList((ListModel)((ExpansionNodeCell)this.getCell()).nodeListModel);
            this.showNodeInTreeList.setSelectionMode(0);
            this.showNodeInTreeList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Data data = (Data)showNodeInTreeList.getSelectedValue();
                    if (data != null) {
                        EventController.fire((EventObject)new SelectInTreeEvent(this.getCell(), (UmlObject)data));
                        this.setVisible(false);
                        showNodeInTreeList.clearSelection();
                    }
                }
            });
            JMenu menu = new JMenu(this.getTranslation("uml.diagram.action.show.in.tree"));
            menu.add((Component)this.showNodeInTreeList);
            this.add(menu);
            this.showNodeValueList = new MouseOverList((ListModel)((ExpansionNodeCell)this.getCell()).nodeListModel);
            this.showNodeValueList.setSelectionMode(0);
            this.showNodeValueList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Data data = (Data)showNodeValueList.getSelectedValue();
                    if (data != null) {
                        EventController.fire((EventObject)new OpenLinkEvent(this.getCell(), "file:///addToWatches?entry=" + data.getValue()));
                        this.setVisible(false);
                        showNodeValueList.clearSelection();
                    }
                }
            });
            menu = new JMenu(this.getTranslation("uml.diagram.action.show.pin.value"));
            menu.add((Component)this.showNodeValueList);
            this.add(menu);
        }
    }
}

