/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.trace.gui.uml.UmlVertexView;
import java.awt.Graphics;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.VertexView;

public class DecisionView
extends UmlVertexView {
    private static final DecisionRenderer RENDERER = new DecisionRenderer();

    public DecisionView() {
    }

    public DecisionView(Object cell) {
        super(cell);
    }

    @Override
    public CellViewRenderer getRenderer() {
        return RENDERER;
    }

    @Override
    public Point2D getPerimeterPoint(EdgeView edge, Point2D source, Point2D p) {
        return this.getRenderer() instanceof DecisionRenderer ? ((DecisionRenderer)this.getRenderer()).getPerimeterPoint(this, source, p) : super.getPerimeterPoint(edge, source, p);
    }

    protected static class DecisionRenderer
    extends UmlVertexView.UmlVertexRenderer {
        protected DecisionRenderer() {
        }

        @Override
        public void paint(Graphics g) {
            int halfWidth = this.getWidth() / 2 - 1;
            int halfHeight = this.getHeight() / 2;
            int[] xPoints = new int[]{halfWidth, 0, halfWidth, this.getWidth() - 1};
            int[] yPoints = new int[]{0, halfHeight, this.getHeight() - 1, halfHeight};
            g.setColor(this.getBorderColor());
            g.drawPolygon(xPoints, yPoints, 4);
            xPoints = new int[]{halfWidth, 1, halfWidth, this.getWidth() - 2};
            yPoints = new int[]{1, halfHeight, this.getHeight() - 2, halfHeight};
            g.drawPolygon(xPoints, yPoints, 4);
        }

        @Override
        public Point2D getPerimeterPoint(VertexView view, Point2D source, Point2D p) {
            Rectangle2D bounds = view.getBounds();
            double centerX = bounds.getCenterX();
            double centerY = bounds.getCenterY();
            double x = p.getX();
            double y = p.getY();
            double dx = x - centerX;
            double dy = y - centerY;
            Line2D.Double line2 = new Line2D.Double(p, source == null ? new Point2D.Double(centerX, centerY) : source);
            Line2D.Double line1 = dx < 0.0 ? (dy < 0.0 ? new Line2D.Double(bounds.getX(), bounds.getCenterY(), bounds.getCenterX(), bounds.getY()) : new Line2D.Double(bounds.getCenterX(), bounds.getMaxY(), bounds.getX(), bounds.getCenterY())) : (dy < 0.0 ? new Line2D.Double(bounds.getCenterX(), bounds.getY(), bounds.getMaxX(), bounds.getCenterY()) : new Line2D.Double(bounds.getMaxX(), bounds.getCenterY(), bounds.getCenterX(), bounds.getMaxY()));
            return DecisionRenderer.getIntersection(line1, line2);
        }

        private static Point2D getIntersection(Line2D line1, Line2D line2D) {
            Point2D.Double p = null;
            if (line1.intersectsLine(line2D)) {
                double x1 = line1.getX1();
                double y1 = line1.getY1();
                double x2 = line1.getX2();
                double y2 = line1.getY2();
                double x3 = line2D.getX1();
                double y3 = line2D.getY1();
                double x4 = line2D.getX2();
                double y4 = line2D.getY2();
                double x = DecisionRenderer.det(DecisionRenderer.det(x1, y1, x2, y2), x1 - x2, DecisionRenderer.det(x3, y3, x4, y4), x3 - x4) / DecisionRenderer.det(x1 - x2, y1 - y2, x3 - x4, y3 - y4);
                double y = DecisionRenderer.det(DecisionRenderer.det(x1, y1, x2, y2), y1 - y2, DecisionRenderer.det(x3, y3, x4, y4), y3 - y4) / DecisionRenderer.det(x1 - x2, y1 - y2, x3 - x4, y3 - y4);
                p = new Point2D.Double(x, y);
            }
            return p;
        }

        private static double det(double a, double b, double c, double d) {
            return a * d - b * c;
        }
    }
}

