/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.E2ETraceModule;
import ch.e2e.builder.trace.gui.uml.GroupingCell;
import ch.e2e.builder.trace.gui.uml.UmlCellViewFactory;
import ch.e2e.builder.trace.gui.uml.UmlGraph;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.gui.uml.activity.ActionCell;
import ch.e2e.builder.trace.gui.uml.activity.ActivityEdge;
import ch.e2e.builder.trace.gui.uml.activity.ClassCell;
import ch.e2e.builder.trace.gui.uml.activity.DecisionCell;
import ch.e2e.builder.trace.gui.uml.activity.ExpansionRegionCell;
import ch.e2e.builder.trace.gui.uml.activity.FinalNodeCell;
import ch.e2e.builder.trace.gui.uml.activity.InfoCell;
import ch.e2e.builder.trace.gui.uml.activity.InitialNodeCell;
import ch.e2e.builder.trace.gui.uml.activity.InputExpansionNodeCell;
import ch.e2e.builder.trace.gui.uml.activity.InputPinCell;
import ch.e2e.builder.trace.gui.uml.activity.IteratedCell;
import ch.e2e.builder.trace.gui.uml.activity.OutputExpansionNodeCell;
import ch.e2e.builder.trace.gui.uml.activity.OutputPinCell;
import ch.e2e.builder.trace.gui.uml.activity.ReferenceCell;
import ch.e2e.builder.trace.gui.uml.activity.SignalCell;
import ch.e2e.builder.trace.gui.uml.activity.ThrowCell;
import ch.e2e.builder.trace.gui.uml.activity.UnfoldedBranchesEdge;
import ch.e2e.builder.trace.gui.uml.activity.ValuePinCell;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.uml.Action;
import ch.e2e.builder.trace.testcase.uml.Activity;
import ch.e2e.builder.trace.testcase.uml.Adapter;
import ch.e2e.builder.trace.testcase.uml.Branches;
import ch.e2e.builder.trace.testcase.uml.Catch;
import ch.e2e.builder.trace.testcase.uml.Catches;
import ch.e2e.builder.trace.testcase.uml.Data;
import ch.e2e.builder.trace.testcase.uml.DataContainer;
import ch.e2e.builder.trace.testcase.uml.Flow;
import ch.e2e.builder.trace.testcase.uml.Function;
import ch.e2e.builder.trace.testcase.uml.GenericFlow;
import ch.e2e.builder.trace.testcase.uml.IOUmlObject;
import ch.e2e.builder.trace.testcase.uml.Input;
import ch.e2e.builder.trace.testcase.uml.InputExpansionNode;
import ch.e2e.builder.trace.testcase.uml.InputPin;
import ch.e2e.builder.trace.testcase.uml.IteratorFlow;
import ch.e2e.builder.trace.testcase.uml.Message;
import ch.e2e.builder.trace.testcase.uml.Output;
import ch.e2e.builder.trace.testcase.uml.OutputExpansionNode;
import ch.e2e.builder.trace.testcase.uml.OutputPin;
import ch.e2e.builder.trace.testcase.uml.Pin;
import ch.e2e.builder.trace.testcase.uml.Referenceable;
import ch.e2e.builder.trace.testcase.uml.RootObject;
import ch.e2e.builder.trace.testcase.uml.Script;
import ch.e2e.builder.trace.testcase.uml.Throw;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlObjectVisitor;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public class ActivityGraphBuilder
extends UmlObjectVisitor {
    private static final String GENERATED_BY_COMPILER = "diagram.generated.by.compiler";
    private static final double DY = 120.0;
    private static final int DX_DATA = 450;
    private static final int DY_DATA = 40;
    private static final int X_OFFSET = 550;
    private final Testcase testcase;
    private final UmlObject root;
    private final E2ETraceModule module;
    private final UmlGraph graph;
    private final Referencer referencer;
    private final ArrayList<DefaultGraphCell> cells;
    private int yOffset = 120;
    private DefaultGraphCell previousCell = null;
    private DefaultGraphCell endCell = null;

    public ActivityGraphBuilder(Testcase testcase, UmlObject root, E2ETraceModule module) {
        this.testcase = testcase;
        this.root = root;
        this.module = module;
        this.referencer = new Referencer(module);
        this.cells = new ArrayList();
        this.cells.add(new InfoCell(testcase, this.getTitle()));
        this.previousCell = this.createStartCell();
        DefaultGraphModel model = new DefaultGraphModel();
        this.graph = new UmlGraph(module, (GraphModel)model, new GraphLayoutCache((GraphModel)model, (CellViewFactory)new UmlCellViewFactory()));
        this.graph.setBackground(root.isGenerated() ? UmlGraphConstants.GENERATED_ACTIVITY_COLOR : Color.WHITE);
        this.visit(root);
        this.graph.getGraphLayoutCache().insert(this.getCells());
        this.graph.setRunDate(new Date().getTime());
    }

    private String getTitle() {
        String title = "";
        if (this.root != null) {
            if (this.testcase.getType() == 24 || this.testcase.getType() == 40) {
                title = this.root.getName();
            } else {
                title = this.root.getAttribute("name");
                if (title == null) {
                    title = this.root.getName();
                }
            }
            int index = title.indexOf("...");
            if (index > -1) {
                title = title.substring(0, index);
            }
            if (this.root.isGenerated()) {
                title = title + " (" + this.module.getTranslation(GENERATED_BY_COMPILER, "generated by the compiler") + ")";
            }
        }
        return title;
    }

    public UmlGraph getGraph() {
        return this.graph;
    }

    public Object[] getCells() {
        if (this.endCell == null) {
            this.endCell = this.createEndCell();
        }
        return this.cells.toArray();
    }

    public void visit(RootObject rootObject) {
        this.visitChilds((UmlObject)rootObject);
    }

    public void visit(Activity activity) {
        if (activity.getType() != 10012) {
            if (activity.getChildCount() == 0) {
                this.previousCell = this.createActionCell((UmlObject)activity);
            } else {
                this.visitChilds((UmlObject)activity);
            }
        }
    }

    public void visit(Message message) {
        UmlObject parent = message.getParent();
        if (parent instanceof Activity) {
            this.previousCell = this.createActionCell(parent);
        }
    }

    public void visit(Flow flow) {
        if (this.showChildren(flow)) {
            this.visitChilds((UmlObject)flow);
        } else {
            this.previousCell = this.createActionCell((UmlObject)flow);
            this.createIoCells((IOUmlObject)flow);
        }
    }

    public void visit(IteratorFlow iteratorFlow) {
        this.previousCell = this.createExpansionRegion(iteratorFlow);
        this.createInputExpansionNode(iteratorFlow);
        this.createOutputExpansionNodes(iteratorFlow);
        this.createIteratedAction(iteratorFlow);
    }

    public void visit(IOUmlObject object) {
        this.previousCell = this.createActionCell((UmlObject)object);
        this.createIoCells(object);
    }

    public void visit(Branches branches) {
        this.previousCell = this.createDecisionCell((UmlObject)branches);
    }

    public void visit(Catches catches) {
        this.previousCell = this.createDecisionCell((UmlObject)catches);
    }

    public void visit(Action action) {
        this.previousCell = this.createSignalCell(action);
        this.createIoCells((IOUmlObject)action);
    }

    public void visit(Throw t) {
        this.previousCell = this.createThrowCell(t);
    }

    public void visit(Function function) {
    }

    public void visit(Pin pin) {
    }

    private boolean isRoot(UmlObject object) {
        return object == this.root;
    }

    private boolean showChildren(Flow flow) {
        return this.isRoot((UmlObject)flow) && (flow instanceof GenericFlow || !(flow.getParent() instanceof IteratorFlow));
    }

    private DefaultGraphCell createStartCell() {
        InitialNodeCell cell = new InitialNodeCell();
        this.cells.add(cell);
        AttributeMap attributes = cell.getAttributes();
        UmlGraphConstants.setBounds((Map)attributes, (Rectangle2D)this.computeStartBounds());
        cell.addPort();
        return cell;
    }

    private DefaultGraphCell createActionCell(UmlObject object) {
        assert (object != null);
        ActionCell cell = new ActionCell(object, this.module);
        cell.addPort();
        this.cells.add(cell);
        AttributeMap attributes = cell.getAttributes();
        UmlGraphConstants.setBounds((Map)attributes, (Rectangle2D)this.computeActionBounds());
        UmlGraphConstants.setOpaque((Map)attributes, (boolean)true);
        UmlGraphConstants.setBorderColor((Map)attributes, (Color)Color.BLACK);
        this.connect(this.previousCell, cell, false);
        GroupingCell container = new GroupingCell();
        container.add((MutableTreeNode)((Object)cell));
        this.cells.add(container);
        return cell;
    }

    private DefaultGraphCell createExpansionRegion(IteratorFlow iteratorFlow) {
        assert (iteratorFlow != null);
        ExpansionRegionCell cell = new ExpansionRegionCell(iteratorFlow, this.module);
        cell.addPort();
        this.cells.add(cell);
        AttributeMap attributes = cell.getAttributes();
        UmlGraphConstants.setBounds((Map)attributes, (Rectangle2D)this.computeExpansionRegionBounds());
        UmlGraphConstants.setDashedBorder((Map)attributes, true);
        UmlGraphConstants.setOpaque((Map)attributes, (boolean)true);
        if (iteratorFlow.hasErrors()) {
            UmlGraphConstants.setBackground((Map)attributes, (Color)UmlGraphConstants.ERROR_COLOR);
        } else {
            UmlGraphConstants.setBackground((Map)attributes, (Color)UmlGraphConstants.EXPANSION_REGION_COLOR);
        }
        UmlGraphConstants.setBorderColor((Map)attributes, (Color)Color.BLACK);
        this.connect(this.previousCell, cell, false);
        GroupingCell container = new GroupingCell();
        container.add((MutableTreeNode)((Object)cell));
        this.cells.add(container);
        return cell;
    }

    private void createInputExpansionNode(IteratorFlow iteratorFlow) {
        DataContainer input = iteratorFlow.getInput();
        if (input instanceof InputExpansionNode) {
            InputExpansionNode node = (InputExpansionNode)input;
            InputExpansionNodeCell cell = new InputExpansionNodeCell(node, this.module);
            cell.addPort();
            this.cells.add(cell);
            ((DefaultGraphCell)this.previousCell.getParent()).add((MutableTreeNode)((Object)cell));
            UmlGraphConstants.setBackground((Map)cell.getAttributes(), (Color)UmlGraphConstants.getBackground((Map)this.previousCell.getAttributes()));
            Rectangle2D bounds = UmlGraphConstants.getBounds((Map)this.previousCell.getAttributes());
            Rectangle2D.Double inputCellBounds = new Rectangle2D.Double(bounds.getX() - 5.0, bounds.getY() + 20.0, 10.0, 30.0);
            UmlGraphConstants.setBounds((Map)cell.getAttributes(), (Rectangle2D)inputCellBounds);
            if (!node.isLeaf()) {
                if (node.usesReference()) {
                    this.createReferenceCell(cell, this.referencer.add((Referenceable)node), -450, 0);
                } else {
                    this.createDataCell(cell, node.getData(), -450, 0);
                }
            }
        } else if (input instanceof Input) {
            Input node = (Input)input;
            InputExpansionNodeCell cell = new InputExpansionNodeCell(node, this.module);
            cell.addPort();
            this.cells.add(cell);
            ((DefaultGraphCell)this.previousCell.getParent()).add((MutableTreeNode)((Object)cell));
            UmlGraphConstants.setBackground((Map)cell.getAttributes(), (Color)UmlGraphConstants.getBackground((Map)this.previousCell.getAttributes()));
            Rectangle2D bounds = UmlGraphConstants.getBounds((Map)this.previousCell.getAttributes());
            Rectangle2D.Double inputCellBounds = new Rectangle2D.Double(bounds.getX() - 5.0, bounds.getY() + 20.0, 10.0, 30.0);
            UmlGraphConstants.setBounds((Map)cell.getAttributes(), (Rectangle2D)inputCellBounds);
            if (!node.isLeaf()) {
                this.createDataCell(cell, (Data)node.getChild(0), -450, 0);
            }
        }
    }

    private void createOutputExpansionNodes(IteratorFlow iteratorFlow) {
        DataContainer dataContainer = iteratorFlow.getOutput();
        if (dataContainer != null && dataContainer.getChildCount() > 0) {
            OutputExpansionNodeCell cell = new OutputExpansionNodeCell(dataContainer, this.module);
            cell.addPort();
            this.cells.add(cell);
            ((DefaultGraphCell)this.previousCell.getParent()).add((MutableTreeNode)((Object)cell));
            UmlGraphConstants.setBackground((Map)cell.getAttributes(), (Color)UmlGraphConstants.getBackground((Map)this.previousCell.getAttributes()));
            Rectangle2D bounds = UmlGraphConstants.getBounds((Map)this.previousCell.getAttributes());
            Rectangle2D.Double outputCellBounds = new Rectangle2D.Double(bounds.getMaxX() - 5.0, bounds.getY() + 20.0, 10.0, 30.0);
            UmlGraphConstants.setBounds((Map)cell.getAttributes(), (Rectangle2D)outputCellBounds);
            int childCount = dataContainer.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                Data data = (Data)dataContainer.getChild(i);
                this.createDataCell(cell, data, 450, i * 40);
            }
        }
    }

    private void createIteratedAction(IteratorFlow iteratorFlow) {
        if (!iteratorFlow.getIterations().isEmpty()) {
            IteratedCell iteratedCell = new IteratedCell(iteratorFlow, this.module);
            iteratedCell.addPort();
            this.cells.add(iteratedCell);
            ((DefaultGraphCell)this.previousCell.getParent()).add((MutableTreeNode)((Object)iteratedCell));
            UmlGraphConstants.setOpaque((Map)iteratedCell.getAttributes(), (boolean)true);
            UmlGraphConstants.setBackground((Map)iteratedCell.getAttributes(), (Color)UmlGraphConstants.getBackground((Map)this.previousCell.getAttributes()));
            UmlGraphConstants.setBorderColor((Map)iteratedCell.getAttributes(), (Color)Color.BLACK);
            Rectangle2D bounds = UmlGraphConstants.getBounds((Map)this.previousCell.getAttributes());
            Rectangle2D.Double iterationCellBounds = new Rectangle2D.Double(bounds.getCenterX() - 105.0, bounds.getCenterY() - 10.0, 210.0, 60.0);
            UmlGraphConstants.setBounds((Map)iteratedCell.getAttributes(), (Rectangle2D)iterationCellBounds);
            this.createNonIteratedIoCells(iteratedCell, iteratorFlow);
        }
    }

    private void createNonIteratedIoCells(IteratedCell iteratedCell, IteratorFlow iteratorFlow) {
        List dataList = iteratorFlow.getNonIteratedInputs();
        int n = dataList.size();
        for (Data data : dataList) {
            this.createDataCell(iteratedCell, data, -450, --n * -40);
        }
        dataList = iteratorFlow.getNonIteratedOutputs();
        n = 0;
        for (Data data : dataList) {
            this.createDataCell(iteratedCell, data, 450, n++ * 40);
        }
    }

    private DefaultGraphCell createDecisionCell(UmlObject object) {
        assert (object instanceof Branches || object instanceof Catches);
        DecisionCell cell = new DecisionCell(object);
        this.cells.add(cell);
        AttributeMap attributes = cell.getAttributes();
        UmlGraphConstants.setBounds((Map)attributes, (Rectangle2D)this.computeDecisionBounds());
        UmlGraphConstants.setOpaque((Map)attributes, (boolean)true);
        UmlGraphConstants.setBackground((Map)attributes, (Color)Color.WHITE);
        UmlGraphConstants.setBorderColor((Map)attributes, (Color)Color.BLACK);
        this.connect(this.previousCell, cell, false);
        this.createUnfoldedBranchesEdge(cell);
        return cell;
    }

    private DefaultGraphCell createSignalCell(Action action) {
        assert (action != null);
        SignalCell cell = new SignalCell(action, this.module);
        cell.addPort();
        this.cells.add(cell);
        AttributeMap attributes = cell.getAttributes();
        UmlGraphConstants.setBounds((Map)attributes, (Rectangle2D)this.computeActionBounds());
        UmlGraphConstants.setOpaque((Map)attributes, (boolean)true);
        if (action.hasErrors()) {
            UmlGraphConstants.setBackground((Map)attributes, (Color)UmlGraphConstants.ERROR_COLOR);
        } else {
            UmlGraphConstants.setBackground((Map)attributes, (Color)UmlGraphConstants.ACTION_COLOR);
        }
        UmlGraphConstants.setBorderColor((Map)attributes, (Color)Color.BLACK);
        this.connect(this.previousCell, cell, false);
        GroupingCell container = new GroupingCell();
        container.add((MutableTreeNode)((Object)cell));
        this.cells.add(container);
        return cell;
    }

    private DefaultGraphCell createThrowCell(Throw t) {
        assert (t != null);
        ThrowCell cell = new ThrowCell(t, this.module);
        cell.addPort();
        this.cells.add(cell);
        AttributeMap attributes = cell.getAttributes();
        UmlGraphConstants.setBounds((Map)attributes, (Rectangle2D)this.computeActionBounds());
        UmlGraphConstants.setOpaque((Map)attributes, (boolean)true);
        UmlGraphConstants.setBackground((Map)attributes, (Color)UmlGraphConstants.THROW_COLOR);
        UmlGraphConstants.setBorderColor((Map)attributes, (Color)Color.BLACK);
        this.connect(this.previousCell, cell, false);
        GroupingCell container = new GroupingCell();
        container.add((MutableTreeNode)((Object)cell));
        this.cells.add(container);
        return cell;
    }

    private void createIoCells(IOUmlObject object) {
        this.createInput(object);
        this.createOutput(object);
    }

    private void createInput(IOUmlObject object) {
        this.createValuePins(object);
        this.createInputPins(object);
        this.createInputCells(object);
    }

    private void createValuePins(IOUmlObject object) {
        List pins = object.getValuePins();
        if (pins.size() > 0) {
            Color color = UmlGraphConstants.getBackground((Map)this.previousCell.getAttributes());
            Rectangle2D bounds = UmlGraphConstants.getBounds((Map)this.previousCell.getAttributes());
            ValuePinCell pinCell = new ValuePinCell(pins, this.module);
            this.cells.add(pinCell);
            UmlGraphConstants.setBackground((Map)pinCell.getAttributes(), (Color)color);
            Rectangle2D.Double pinCellBounds = new Rectangle2D.Double(bounds.getX() + 0.25 * bounds.getWidth() - 5.0, bounds.getY() - 9.0, 10.0, 10.0);
            UmlGraphConstants.setBounds((Map)pinCell.getAttributes(), (Rectangle2D)pinCellBounds);
            ((DefaultGraphCell)this.previousCell.getParent()).add((MutableTreeNode)((Object)pinCell));
        }
    }

    private void createInputPins(IOUmlObject object) {
        List pins = object.getInputPins();
        if (!pins.isEmpty()) {
            Color color = UmlGraphConstants.getBackground((Map)this.previousCell.getAttributes());
            Rectangle2D bounds = UmlGraphConstants.getBounds((Map)this.previousCell.getAttributes());
            InputPinCell pinCell = new InputPinCell(pins, this.module);
            pinCell.addPort();
            this.cells.add(pinCell);
            UmlGraphConstants.setBackground((Map)pinCell.getAttributes(), (Color)color);
            Rectangle2D.Double pinCellBounds = new Rectangle2D.Double(bounds.getX() - 9.0, bounds.getY() + 0.25 * bounds.getHeight(), 10.0, 10.0);
            UmlGraphConstants.setBounds((Map)pinCell.getAttributes(), (Rectangle2D)pinCellBounds);
            ((DefaultGraphCell)this.previousCell.getParent()).add((MutableTreeNode)((Object)pinCell));
            int n = object.getInput().getChildCount() - object.getValuePins().size();
            for (InputPin pin : pins) {
                if (pin.usesReference()) {
                    this.createReferenceCell(pinCell, this.referencer.add((Referenceable)pin), -450, --n * -40);
                    continue;
                }
                this.createDataCell(pinCell, pin.getData(), -450, --n * -40);
            }
        }
    }

    private void createInputCells(IOUmlObject object) {
        Input input = (Input)object.getInput();
        if (input != null) {
            int nChildren = input.getChildCount();
            int n = nChildren - object.getInputPins().size() - object.getValuePins().size();
            for (int i = 0; i < nChildren; ++i) {
                Data data = (Data)input.getChild(i);
                if (this.connectedThroughPin(data, object)) continue;
                this.createDataCell(this.previousCell, data, -450, --n * -40);
            }
        }
    }

    private void createOutput(IOUmlObject object) {
        this.createOutputPins(object);
        this.createOutputCells(object);
    }

    private void createOutputCells(IOUmlObject object) {
        Output output = (Output)object.getOutput();
        if (output != null) {
            int n = object.getOutputPins().size();
            for (int i = 0; i < output.getChildCount(); ++i) {
                Data data = (Data)output.getChild(i);
                if (this.connectedThroughPin(data, object)) continue;
                this.createDataCell(this.previousCell, data, 450, n++ * 40);
            }
        }
    }

    private void createOutputPins(IOUmlObject object) {
        List pins = object.getOutputPins();
        if (pins.size() > 0) {
            Color color = UmlGraphConstants.getBackground((Map)this.previousCell.getAttributes());
            Rectangle2D bounds = UmlGraphConstants.getBounds((Map)this.previousCell.getAttributes());
            OutputPinCell pinCell = new OutputPinCell(pins, this.module);
            pinCell.addPort();
            this.cells.add(pinCell);
            UmlGraphConstants.setBackground((Map)pinCell.getAttributes(), (Color)color);
            Rectangle2D.Double pinCellBounds = new Rectangle2D.Double(bounds.getMaxX() - 1.0, bounds.getY() + 0.25 * bounds.getHeight(), 10.0, 10.0);
            UmlGraphConstants.setBounds((Map)pinCell.getAttributes(), (Rectangle2D)pinCellBounds);
            ((DefaultGraphCell)this.previousCell.getParent()).add((MutableTreeNode)((Object)pinCell));
            int n = 0;
            for (OutputPin pin : pins) {
                if (pin.usesReference()) {
                    this.createReferenceCell(pinCell, this.referencer.add(pin), 450, n++ * 40);
                    continue;
                }
                this.createDataCell(pinCell, pin.getData(), 450, n++ * 40);
            }
        }
    }

    private void createReferenceCell(DefaultGraphCell baseCell, ReferenceCell cell, int xOffset, int yOffset) {
        if (cell != null) {
            double y;
            double x;
            this.cells.add(cell);
            Rectangle2D baseBounds = UmlGraphConstants.getBounds((Map)baseCell.getAttributes());
            if (xOffset > 0) {
                this.connect(baseCell, cell, false);
                x = 530.0 + (double)xOffset;
                y = baseBounds.getCenterY() - 10.0 + (double)yOffset;
            } else {
                this.connect(cell, baseCell, false);
                x = 550 + xOffset;
                y = baseBounds.getCenterY() - 10.0 + (double)yOffset;
            }
            cell.getAttributes().translate(x, y);
        } else {
            LOGGER.warning("No reference cell for " + baseCell.getClass().getSimpleName() + " '" + baseCell + "'");
        }
    }

    private boolean connectedThroughPin(Data data, IOUmlObject object) {
        boolean throughPin = false;
        String key = data.getOriginalName();
        for (Pin pin : object.getInputPins()) {
            if (!pin.getName().equals(key)) continue;
            throughPin = true;
            break;
        }
        if (!throughPin) {
            for (Pin pin : object.getOutputPins()) {
                if (!pin.getName().equals(key)) continue;
                throughPin = true;
                break;
            }
        }
        if (!throughPin) {
            for (Pin pin : object.getValuePins()) {
                if (!pin.getName().equals(key)) continue;
                throughPin = true;
                break;
            }
        }
        return throughPin;
    }

    private void createDataCell(DefaultGraphCell base, Data data, int xOffset, int yOffset) {
        double x;
        ClassCell cell = new ClassCell(data, this.module);
        Object userObject = base.getUserObject();
        if (userObject instanceof Adapter && ((Adapter)userObject).isMockup()) {
            UmlGraphConstants.setBackground((Map)cell.getAttributes(), (Color)UmlGraphConstants.MOCK_ADAPTER_COLOR);
        }
        cell.addPort();
        this.cells.add(cell);
        Rectangle2D baseBounds = UmlGraphConstants.getBounds((Map)base.getAttributes());
        if (xOffset > 0) {
            this.connect(base, cell, data, false);
            x = 390.0 + (double)xOffset;
        } else {
            this.connect(cell, base, data, false);
            x = 550 + xOffset;
        }
        double y = baseBounds.getCenterY() - 10.0 + (double)yOffset;
        cell.getAttributes().translate(x, y);
    }

    private DefaultGraphCell createEndCell() {
        FinalNodeCell cell = new FinalNodeCell();
        cell.addPort();
        this.cells.add(cell);
        AttributeMap attributes = cell.getAttributes();
        UmlGraphConstants.setBounds((Map)attributes, (Rectangle2D)this.computeEndBounds());
        UmlGraphConstants.setOpaque((Map)attributes, (boolean)true);
        UmlGraphConstants.setBackground((Map)attributes, (Color)Color.BLACK);
        this.connect(this.previousCell, cell, false);
        return cell;
    }

    private void connect(DefaultGraphCell source, DefaultGraphCell target, Boolean dashed) {
        this.connect(source, target, null, dashed);
    }

    private void connect(DefaultGraphCell source, DefaultGraphCell target, Object edgeUserObject, Boolean dashed) {
        if (source != null && target != null) {
            boolean transformed = edgeUserObject instanceof Data && ((Data)edgeUserObject).isTransformed();
            ActivityEdge edge = new ActivityEdge(transformed ? "<<Transformation>>" : null, this.module);
            this.cells.add((DefaultGraphCell)edge);
            AttributeMap attributes = edge.getAttributes();
            UmlGraphConstants.setRouting((Map)attributes, (Edge.Routing)GraphConstants.ROUTING_SIMPLE);
            UmlGraphConstants.setLineStyle((Map)attributes, (int)11);
            UmlGraphConstants.setLineEnd((Map)attributes, (int)4);
            if (transformed) {
                UmlGraphConstants.setLabelPosition((Map)attributes, (Point2D)new Point2D.Double(500.0, -10.0));
                UmlGraphConstants.setToolTipText((Map)attributes, edgeUserObject.toString());
            }
            if (source instanceof DecisionCell) {
                edge.setSource(((DecisionCell)source).getSuccessBranchPort());
                if (source.getUserObject() instanceof Branches) {
                    Branches branches = (Branches)source.getUserObject();
                    Script followedBranch = branches.getFollowedBranch();
                    if (followedBranch != null) {
                        edge.setLabel("branching expression");
                        edge.setUserObject(followedBranch);
                    }
                } else if (source.getUserObject() instanceof Catches) {
                    Catches catches = (Catches)source.getUserObject();
                    int nCatches = catches.getChildCount();
                    Catch c = (Catch)catches.getChild(nCatches - 1);
                    if (nCatches > 1 || !c.getUmlLabel().equals("[nothing caught]")) {
                        edge.setUserObject(c);
                        if (c.getUmlLabel().equals("[nothing caught]")) {
                            UmlGraphConstants.setForeground((Map)edge.getAttributes(), (Color)UmlGraphConstants.GREEN);
                        } else {
                            UmlGraphConstants.setForeground((Map)edge.getAttributes(), (Color)UmlGraphConstants.ORANGE);
                        }
                    } else {
                        edge.setUserObject(null);
                    }
                }
            } else {
                edge.setSource(source.getChildAt(0));
            }
            if (target instanceof DecisionCell) {
                edge.setTarget(((DecisionCell)target).getEntryPort());
            } else {
                edge.setTarget(target.getChildAt(0));
            }
            if (!(source instanceof ClassCell) && !(target instanceof ClassCell)) {
                UmlGraphConstants.setLineWidth((Map)attributes, (float)2.0f);
            }
            if (dashed != null && dashed.booleanValue()) {
                UmlGraphConstants.setDashPattern((Map)attributes, (float[])UmlGraphConstants.DASH_PATTERN);
            }
        }
    }

    private void createUnfoldedBranchesEdge(DecisionCell cell) {
        DefaultEdge edge;
        Rectangle2D bounds = UmlGraphConstants.getBounds((Map)cell.getAttributes());
        bounds = new Rectangle2D.Double(bounds.getMaxX() + 200.0, bounds.getCenterY(), 4.0, 4.0);
        DefaultGraphCell dummy = new DefaultGraphCell();
        dummy.addPort();
        this.cells.add(dummy);
        UmlGraphConstants.setBounds((Map)dummy.getAttributes(), (Rectangle2D)bounds);
        UmlGraphConstants.setSizeable((Map)dummy.getAttributes(), (boolean)false);
        UmlGraphConstants.setOpaque((Map)dummy.getAttributes(), (boolean)false);
        if (cell.getUserObject() instanceof Catches) {
            Catches catches = (Catches)cell.getUserObject();
            edge = new DefaultEdge((Object)"[not followed branches]");
            if (catches.getChildCount() > 1) {
                Catch c = (Catch)catches.getChild(0);
                UmlGraphConstants.setExtraLabels((Map)edge.getAttributes(), (Object[])new String[]{c.getUmlLabel()});
                UmlGraphConstants.setExtraLabelPositions((Map)edge.getAttributes(), (Point2D[])new Point2D[]{new Point2D.Double(500.0, 14.0)});
            }
            UmlGraphConstants.setDashPattern((Map)edge.getAttributes(), (float[])UmlGraphConstants.DASH_PATTERN);
            UmlGraphConstants.setLabelAlongEdge((Map)edge.getAttributes(), (boolean)true);
        } else {
            Branches branches = (Branches)cell.getUserObject();
            edge = new UnfoldedBranchesEdge(branches, this.module);
        }
        edge.setSource((Object)cell.getUnfoldedBranchesPort());
        edge.setTarget((Object)dummy.getChildAt(0));
        this.cells.add((DefaultGraphCell)edge);
    }

    private Rectangle2D computeStartBounds() {
        double x = 538.0;
        double y = this.yOffset;
        this.yOffset = (int)((double)this.yOffset + 132.0);
        return new Rectangle2D.Double(x, y, 24.0, 24.0);
    }

    private Rectangle2D computeActionBounds() {
        double x = 445.0;
        double y = this.yOffset;
        this.yOffset = (int)((double)this.yOffset + 180.0);
        return new Rectangle2D.Double(x, y, 210.0, 60.0);
    }

    private Rectangle2D computeExpansionRegionBounds() {
        double x = 405.0;
        double y = this.yOffset;
        this.yOffset = (int)((double)this.yOffset + 250.0);
        return new Rectangle2D.Double(x, y, 290.0, 130.0);
    }

    private Rectangle2D computeDecisionBounds() {
        double x = 525.0;
        double y = this.yOffset;
        this.yOffset = (int)((double)this.yOffset + 170.0);
        return new Rectangle2D.Double(x, y, 50.0, 50.0);
    }

    private Rectangle2D computeEndBounds() {
        double x = 538.0;
        return new Rectangle2D.Double(x, this.yOffset, 24.0, 24.0);
    }

    private static class Referencer {
        private static final char[] LETTERS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        private final E2EBuilderModule module;
        private final Map<String, String> refMap = new HashMap<String, String>();
        private final Map<String, ReferenceCell> cellMap = new HashMap<String, ReferenceCell>();

        private Referencer(E2EBuilderModule module) {
            this.module = module;
        }

        public ReferenceCell add(OutputPin pin) {
            if (this.size() > 25) {
                throw new ArrayIndexOutOfBoundsException(this.size());
            }
            String externalName = pin.getExternalName();
            String refName = this.refMap.get(externalName);
            ReferenceCell refCell = null;
            if (refName == null) {
                refName = this.newReferenceName();
                this.refMap.put(externalName, refName);
                refCell = new ReferenceCell(refName, pin.getData(), this.module);
                refCell.addPort();
                this.cellMap.put(externalName, refCell);
                pin.setExternalName(refName);
            }
            return refCell;
        }

        public List<ReferenceCell> add(OutputExpansionNode node) {
            if (this.size() > 25) {
                throw new ArrayIndexOutOfBoundsException(this.size());
            }
            int childCount = node.getChildCount();
            List<ReferenceCell> referenceCells = childCount > 0 ? new ArrayList<ReferenceCell>(childCount) : Collections.emptyList();
            return referenceCells;
        }

        public ReferenceCell add(Referenceable referenceable) {
            String externalName = referenceable.getExternalName();
            String refName = this.refMap.get(externalName);
            ReferenceCell refCell = null;
            if (refName != null) {
                ReferenceCell cell = this.cellMap.get(externalName);
                if (cell != null) {
                    refCell = new ReferenceCell(refName, cell.getUserObject(), this.module);
                    refCell.addPort();
                    cell.setUserObject(referenceable.getData());
                    referenceable.setExternalName(refName);
                } else {
                    UmlObjectVisitor.LOGGER.warning("No reference cell found for '" + externalName + "'");
                }
            }
            return refCell;
        }

        private String newReferenceName() {
            return String.valueOf(LETTERS[this.size()]);
        }

        private int size() {
            return this.refMap.size();
        }
    }
}

