/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.MockBackendEvent;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.event.SelectInTreeEvent;
import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.gui.uml.ContextMenu;
import ch.e2e.builder.trace.gui.uml.UmlCell;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcaseRoot;
import ch.e2e.builder.trace.testcase.uml.Adapter;
import ch.e2e.builder.trace.testcase.uml.AdapterIO;
import ch.e2e.builder.trace.testcase.uml.Data;
import ch.e2e.builder.trace.testcase.uml.DataContainer;
import ch.e2e.builder.trace.testcase.uml.GenericFlow;
import ch.e2e.builder.trace.testcase.uml.Message;
import ch.e2e.builder.trace.testcase.uml.Script;
import ch.e2e.builder.trace.testcase.uml.TransformerFlow;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.event.EventController;
import ch.e2e.resource.ImageLoader;
import ch.e2e.swing.MouseOverList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ActionCell
extends UmlCell
implements CellWithContextMenu {
    private static final String SUBACTIVITY_ICON = "ch/e2e/builder/trace/images/ActionWithSubactivity.gif";
    private static ActionContextMenu contextMenu;
    private AdapterIOModel adapterIOModel;
    private Message errorMessage;
    private E2EBuilderModule module;

    public ActionCell(Object userObject, E2EBuilderModule module) {
        super(userObject);
        this.module = module;
        this.initialize();
        this.initializeAdapterIO();
    }

    @Override
    public E2EBuilderModule getModule() {
        return this.module;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public ActionContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new ActionContextMenu(this);
        }
        contextMenu.setCell(this);
        return contextMenu;
    }

    public AbstractCellAction<ActionCell> getDefaultAction() {
        return this.getContextMenu().getDefaultAction();
    }

    @Override
    public boolean isContextMenuAlwaysTriggered() {
        return false;
    }

    @Override
    protected void setToolTipText() {
        UmlGraphConstants.setToolTipText((Map)this.getAttributes(), this.userObject.toString());
    }

    private void initialize() {
        UmlGraphConstants.setRoundedCorners((Map)this.getAttributes(), true);
        this.setIcon();
        this.setToolTipText();
        if (this.userObject instanceof UmlObject) {
            UmlObject object = (UmlObject)this.userObject;
            if (object.hasErrors()) {
                this.errorMessage = object.findErrorMessage();
                if (object.hasCausedError()) {
                    this.adjustErrorColor(object);
                } else if (this.errorMessage != null) {
                    this.adjustErrorColor(this.errorMessage.getParent());
                }
            } else if (object instanceof Adapter && ((Adapter)object).isMockup()) {
                UmlGraphConstants.setBackground((Map)this.attributes, (Color)UmlGraphConstants.MOCK_ADAPTER_COLOR);
            } else if (object.getChildCount() == 0) {
                UmlGraphConstants.setBackground((Map)this.attributes, (Color)UmlGraphConstants.NO_TRACE_COLOR);
            } else {
                UmlGraphConstants.setBackground((Map)this.attributes, (Color)UmlGraphConstants.ACTION_COLOR);
            }
        }
    }

    private void adjustErrorColor(UmlObject object) {
        if (object.getErrorHandling().equals((Object)UmlObject.ErrorHandling.ERROR_CAUGHT)) {
            Color color = this.module.isIgnoreCaughtErrors() ? UmlGraphConstants.ACTION_COLOR : UmlGraphConstants.CAUGHT_ERROR_COLOR;
            UmlGraphConstants.setBackground((Map)this.attributes, (Color)color);
        }
    }

    private void setIcon() {
        ImageIcon icon = null;
        UmlGraphConstants.IconPosition iconPos = UmlGraphConstants.IconPosition.TOP_RIGHT;
        if (this.userObject instanceof GenericFlow) {
            icon = ImageLoader.loadIcon((String)SUBACTIVITY_ICON, (boolean)false);
            iconPos = UmlGraphConstants.IconPosition.BOTTOM_RIGHT;
        }
        if (icon != null) {
            UmlGraphConstants.setIconPosition((Map)this.getAttributes(), iconPos);
            UmlGraphConstants.setIcon((Map)this.getAttributes(), (Icon)icon);
        }
    }

    private void initializeAdapterIO() {
        this.adapterIOModel = new AdapterIOModel();
        if (this.userObject instanceof Adapter) {
            Adapter adapter = (Adapter)this.userObject;
            int nChildren = adapter.getChildCount();
            for (int i = 0; i < nChildren; ++i) {
                int j;
                int n;
                Object child = adapter.getChild(i);
                if (!(child instanceof AdapterIO)) continue;
                AdapterIO adapterIO = (AdapterIO)child;
                DataContainer container = adapterIO.getInput();
                if (container != null) {
                    n = container.getChildCount();
                    for (j = 0; j < n; ++j) {
                        this.adapterIOModel.add((Data)container.getChild(j));
                    }
                }
                if ((container = adapterIO.getOutput()) == null) continue;
                n = container.getChildCount();
                for (j = 0; j < n; ++j) {
                    this.adapterIOModel.add((Data)container.getChild(j));
                }
            }
        }
    }

    private static class AdapterIOModel
    extends ArrayList<Data>
    implements ListModel {
        private AdapterIOModel() {
        }

        @Override
        public int getSize() {
            return this.size();
        }

        public Object getElementAt(int index) {
            return this.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    private static class ActionContextMenu
    extends ContextMenu<ActionCell> {
        private MouseOverList adapterIOList;

        public ActionContextMenu(ActionCell cell) {
            super(cell);
            this.createMenu();
        }

        @Override
        public void setCell(ActionCell cell) {
            super.setCell(cell);
            this.adapterIOList.setModel((ListModel)cell.adapterIOModel);
            if (cell.userObject instanceof TransformerFlow) {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.action.script"));
            } else if (cell.userObject instanceof GenericFlow) {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.subactivity"));
            } else {
                this.setDefaultItem(this.getTranslation("uml.diagram.action.show.in.tree"));
            }
            this.setItemVisible(this.getTranslation("uml.diagram.action.show.action.script"), cell.userObject instanceof TransformerFlow);
            this.setItemVisible(this.getTranslation("uml.diagram.action.show.subactivity"), cell.userObject instanceof GenericFlow);
            String name = this.getTranslation("uml.diagram.action.show.adapterIO");
            this.setItemVisible(name, cell.userObject instanceof Adapter);
            this.setItemEnabled(name, cell.userObject instanceof Adapter && !cell.adapterIOModel.isEmpty());
            name = this.getTranslation("uml.diagram.action.mock.backend.manually");
            boolean flag = cell.userObject instanceof Adapter && ((Adapter)cell.userObject).getPath()[0] instanceof AbstractSynchronousTestcaseRoot;
            this.setItemVisible(name, flag);
            this.setItemEnabled(name, flag);
            this.setItemVisible(this.getTranslation("uml.diagram.action.show.error"), cell.errorMessage != null);
        }

        private void createMenu() {
            this.addDefaultItem(new AbstractCellAction<ActionCell>(this.getTranslation("uml.diagram.action.show.in.tree")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object o = ((ActionCell)this.getCell()).getUserObject();
                    if (o instanceof UmlObject) {
                        EventController.fire((EventObject)new SelectInTreeEvent(this.getCell(), (UmlObject)o));
                    }
                }
            }, ACCELERATOR_SHOW_IN_TREE);
            this.addItem(new AbstractCellAction<ActionCell>(this.getTranslation("uml.diagram.action.show.action.script")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransformerFlow flow = (TransformerFlow)((ActionCell)this.getCell()).getUserObject();
                    Script script = flow.getScript();
                    EventController.fire((EventObject)new OpenLinkEvent(this.getCell(), "file:///showScript?script=" + (script == null ? "" : script.getIoId())));
                }
            });
            this.addItem(new AbstractCellAction<ActionCell>(this.getTranslation("uml.diagram.action.show.subactivity")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventController.fire((EventObject)new OpenLinkEvent(this.getCell(), "file:///openActivity?activity=" + ((GenericFlow)((ActionCell)this.getCell()).getUserObject()).getOriginalName()));
                }
            });
            this.adapterIOList = new MouseOverList((ListModel)((ActionCell)this.getCell()).adapterIOModel);
            this.adapterIOList.setSelectionMode(0);
            this.adapterIOList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Data data = (Data)adapterIOList.getSelectedValue();
                    if (data != null) {
                        EventController.fire((EventObject)new OpenLinkEvent(this, "file:///addToWatches?entry=" + data.getValue()));
                        this.setVisible(false);
                        adapterIOList.clearSelection();
                    }
                }
            });
            JMenu adapterIOMenu = new JMenu(this.getTranslation("uml.diagram.action.show.adapterIO"));
            adapterIOMenu.add((Component)this.adapterIOList);
            this.add(adapterIOMenu);
            this.addItem(new AbstractCellAction<ActionCell>(this.getTranslation("uml.diagram.action.mock.backend.manually")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventController.fire((EventObject)new MockBackendEvent(this, (Adapter)((ActionCell)this.getCell()).getUserObject()));
                }
            });
            this.addItem(new AbstractCellAction<ActionCell>(this.getTranslation("uml.diagram.action.show.error")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventController.fire((EventObject)new OpenLinkEvent(this, "file:///addToWatches?entry=" + ((ActionCell)this.getCell()).errorMessage.getName()));
                }
            });
        }
    }
}

