/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.testcase.AbstractXmlCodeEditor;
import ch.e2e.builder.trace.gui.testcase.TabbedView;
import ch.e2e.builder.trace.gui.watch.WatchTreeModel;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.swing.Tree;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public abstract class DataTabbedView
extends JPanel
implements TabbedView {
    protected static final String MODE_RPC = "rpc";
    protected static final String MODE_XML = "xml";
    protected E2EBuilderModule module;
    private Tree tree;
    private JPanel editorPanel;
    private AbstractXmlCodeEditor editor;
    private Testcase testcase;
    private boolean selected;
    private Runnable textSetter;
    private long lastModified = 0L;
    private JPanel dataPanel;
    private String mode = "rpc";

    public DataTabbedView(E2EBuilderModule module, boolean editable) {
        super(new BorderLayout());
        this.module = module;
        this.textSetter = new Runnable(){

            @Override
            public void run() {
                DataTabbedView.this.getEditor().setText(DataTabbedView.this.getData());
            }
        };
        this.createGui(editable);
    }

    private void createGui(boolean editable) {
        this.dataPanel = new JPanel(new CardLayout());
        this.add((Component)this.dataPanel, "Center");
        this.tree = this.createTree();
        this.dataPanel.add((Component)new JScrollPane((Component)this.tree), MODE_RPC);
        this.editor = this.createEditor(editable);
        this.editorPanel = new JPanel(new BorderLayout());
        this.editorPanel.add((Component)((Object)this.editor), "Center");
        this.dataPanel.add((Component)this.editorPanel, MODE_XML);
    }

    private AbstractXmlCodeEditor createEditor(boolean editable) {
        AbstractXmlCodeEditor editor = AbstractXmlCodeEditor.createEditor(false);
        editor.setEditable(editable);
        editor.setVirtualSpaceAllowed(false);
        editor.setFontSize(this.getFont().getSize());
        return editor;
    }

    @Override
    public void setTestcase(Testcase testcase) {
        this.testcase = testcase;
        if (!(testcase == null || this.lastModified(testcase) == this.lastModified && testcase.equals((Object)this.testcase))) {
            this.setEditorText();
            if (testcase.isRPCEncoding()) {
                ((WatchTreeModel)((Object)this.tree.getModel())).setRoot(testcase);
                this.tree.refresh();
                this.setMode(MODE_RPC);
            } else {
                this.setMode(MODE_XML);
            }
        }
    }

    protected String getMode() {
        return this.mode;
    }

    protected void setMode(String mode) {
        this.mode = mode;
        ((CardLayout)this.dataPanel.getLayout()).show(this.dataPanel, mode);
    }

    @Override
    public void setRoot(Object root) {
    }

    public Testcase getTestcase() {
        return this.testcase;
    }

    @Override
    public Object getPrintableObject() {
        return this.testcase == null ? null : (this.testcase.isRPCEncoding() ? this.tree : this.editor);
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
    }

    protected abstract Tree createTree();

    protected abstract String getData();

    protected abstract long lastModified(Testcase var1);

    public JPanel getEditorPanel() {
        return this.editorPanel;
    }

    protected Tree getTree() {
        return this.tree;
    }

    protected AbstractXmlCodeEditor getEditor() {
        return this.editor;
    }

    protected void setEditorText() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getEditor().setText(this.getData());
        } else {
            try {
                SwingUtilities.invokeAndWait(this.textSetter);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.lastModified = this.lastModified(this.testcase);
    }
}

