/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.model;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.BlobViewerDialog;
import ch.e2e.builder.trace.gui.menu.ArrayPopupMenu;
import ch.e2e.builder.trace.gui.menu.BlobPopupMenu;
import ch.e2e.builder.trace.gui.menu.ComplexPopupMenu;
import ch.e2e.builder.trace.gui.menu.ParameterPopupMenu;
import ch.e2e.builder.trace.gui.watch.WatchTreeModel;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.parameter.ArrayParameter;
import ch.e2e.builder.trace.testcase.parameter.BlobParameter;
import ch.e2e.builder.trace.testcase.parameter.ComplexParameter;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import ch.e2e.builder.trace.testcase.parameter.SimpleTypeParameter;
import ch.e2e.builder.trace.testcase.request.Request;
import ch.e2e.swing.TreeObject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TestcaseRequestModel
extends WatchTreeModel {
    private final ArrayPopupMenu arrayPopup;
    private final ComplexPopupMenu complexPopup;
    private final ParameterPopupMenu parameterPopup;
    private final BlobPopupMenu blobPopup;
    private Request root;

    public TestcaseRequestModel(E2EBuilderModule module) {
        super(module);
        this.arrayPopup = new ArrayPopupMenu(this, module);
        this.complexPopup = new ComplexPopupMenu(this, module);
        this.parameterPopup = new ParameterPopupMenu(this, module);
        this.blobPopup = new BlobPopupMenu(this, module);
    }

    public boolean isEditable(Object node) {
        return !(node instanceof BlobParameter) && node instanceof Parameter && ((Parameter)node).isSimpleType();
    }

    @Override
    public void setRoot(Testcase testcase) {
        try {
            this.root = testcase.getRequest();
        }
        catch (IOException e) {
            this.root = null;
        }
        catch (SAXException e) {
            this.root = null;
        }
        catch (ParserConfigurationException e) {
            this.root = null;
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        super.valueForPathChanged(path, newValue);
        Parameter parameter = (Parameter)path.getLastPathComponent();
        parameter.setValue(newValue);
        if (parameter.isChanged()) {
            int index = parameter.getParent() == null ? ((TreeObject)path.getParentPath().getLastPathComponent()).getIndexOfChild((Object)parameter) : parameter.getParent().getIndexOfChild((Object)parameter);
            this.nodeChanged(path.getParentPath(), index, parameter);
        }
    }

    @Override
    public JPopupMenu getPopupMenu(TreePath[] paths) {
        ParameterPopupMenu result = null;
        if (paths.length == 1) {
            Object selection = paths[0].getLastPathComponent();
            if (selection instanceof ArrayParameter) {
                this.arrayPopup.setParameter((TestcaseParameter)selection, paths[0]);
                result = this.arrayPopup;
            } else if (selection instanceof ComplexParameter && this.complexPopup.hasVisibleItems((TestcaseParameter)selection)) {
                this.complexPopup.setParameter((TestcaseParameter)selection, paths[0]);
                result = this.complexPopup;
            } else if (selection instanceof BlobParameter) {
                this.blobPopup.setParameter((TestcaseParameter)selection, paths[0]);
                result = this.blobPopup;
            } else if (selection instanceof SimpleTypeParameter && this.parameterPopup.hasVisibleItems((TestcaseParameter)selection)) {
                this.parameterPopup.setParameter((TestcaseParameter)selection, paths[0]);
                result = this.parameterPopup;
            }
        }
        return result;
    }

    @Override
    public ActionListener getExecuteAction(TreePath[] paths) {
        ActionListener result = null;
        if (paths.length == 1) {
            Object selection = paths[0].getLastPathComponent();
            if (selection instanceof RecordParameter && ((RecordParameter)selection).isNull()) {
                result = new CreateAction((RecordParameter)selection, paths[0]);
            } else if (selection instanceof BlobParameter && !((BlobParameter)selection).isNull()) {
                result = new ShowValueAction((BlobParameter)selection);
            }
        }
        return result;
    }

    private class ShowValueAction
    implements ActionListener {
        private final BlobParameter parameter;

        private ShowValueAction(BlobParameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BlobViewerDialog.getDialog(TestcaseRequestModel.this.getModule()).show(this.parameter.getBlob());
        }
    }

    private class CreateAction
    implements ActionListener {
        private final RecordParameter parameter;
        private final TreePath path;

        public CreateAction(RecordParameter parameter, TreePath path) {
            this.parameter = parameter;
            this.path = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parameter.create();
            TestcaseRequestModel.this.nodeStructureChanged(this.path);
        }
    }
}

