/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.jdom;

import java.util.Stack;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.option.jdom.JDOMDocumentWrapper;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class JDOMWriter
extends Builder {
    private Document document;
    private Stack<Parent> ancestors = new Stack();
    private boolean implicitDocumentNode = false;
    private FastStringBuffer textBuffer = new FastStringBuffer(256);

    public JDOMWriter(PipelineConfiguration pipe) {
        super(pipe);
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.document = new Document();
        this.document.setBaseURI(this.systemId);
        this.ancestors.push((Parent)this.document);
        this.textBuffer.setLength(0);
    }

    @Override
    public void endDocument() throws XPathException {
        this.ancestors.pop();
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.flush();
        String local = nameCode.getLocalPart();
        String uri = nameCode.getURI();
        String prefix = nameCode.getPrefix();
        if (this.ancestors.isEmpty()) {
            this.startDocument(0);
            this.implicitDocumentNode = true;
        }
        Element element = new Element(local, prefix, uri);
        if (this.ancestors.size() == 1) {
            this.document.setRootElement(element);
        } else {
            ((Element)this.ancestors.peek()).addContent((Content)element);
        }
        this.ancestors.push((Parent)element);
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        for (NamespaceBinding nsb : namespaceBindings) {
            Namespace ns;
            String prefix = nsb.getPrefix();
            String uri = nsb.getURI();
            try {
                ns = prefix.isEmpty() ? Namespace.getNamespace((String)uri) : Namespace.getNamespace((String)prefix, (String)uri);
            }
            catch (IllegalNameException e) {
                throw new XPathException("Invalid namespace URI " + uri);
            }
            ((Element)this.ancestors.peek()).addNamespaceDeclaration(ns);
        }
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        String local = nameCode.getLocalPart();
        String uri = nameCode.getURI();
        String prefix = nameCode.getPrefix();
        Namespace ns = prefix.isEmpty() ? Namespace.getNamespace((String)uri) : Namespace.getNamespace((String)prefix, (String)uri);
        Attribute att = new Attribute(local, value.toString(), ns);
        if (uri.equals("http://www.w3.org/XML/1998/namespace") && local.equals("id")) {
            value = Whitespace.trim(value);
            att.setAttributeType(2);
        }
        ((Element)this.ancestors.peek()).getAttributes().add(att);
    }

    @Override
    public void startContent() throws XPathException {
        this.flush();
    }

    @Override
    public void endElement() throws XPathException {
        this.flush();
        this.ancestors.pop();
        Parent parent = this.ancestors.peek();
        if (parent == this.document && this.implicitDocumentNode) {
            this.endDocument();
        }
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.textBuffer.append(chars);
    }

    private void flush() {
        if (!this.textBuffer.isEmpty()) {
            Text text = new Text(this.textBuffer.toString());
            if (this.ancestors.size() == 1) {
                ((Document)this.ancestors.peek()).addContent((Content)text);
            } else {
                ((Element)this.ancestors.peek()).addContent((Content)text);
            }
            this.textBuffer.setLength(0);
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        this.flush();
        ProcessingInstruction pi = new ProcessingInstruction(target, data.toString());
        if (this.ancestors.size() == 1) {
            ((Document)this.ancestors.peek()).addContent((Content)pi);
        } else {
            ((Element)this.ancestors.peek()).addContent((Content)pi);
        }
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.flush();
        Comment comment = new Comment(chars.toString());
        if (this.ancestors.size() == 1) {
            ((Document)this.ancestors.peek()).addContent((Content)comment);
        } else {
            ((Element)this.ancestors.peek()).addContent((Content)comment);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public NodeInfo getCurrentRoot() {
        return new JDOMDocumentWrapper(this.document, this.config).getRootNode();
    }
}

