/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.jdom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Transform;
import net.sf.saxon.option.jdom.JDOMDocumentWrapper;
import net.sf.saxon.trans.XPathException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

public class JDOMTransform
extends Transform {
    @Override
    public List<Source> preprocess(List<Source> sources) throws XPathException {
        try {
            ArrayList<Source> jdomSources = new ArrayList<Source>(sources.size());
            for (Source src : sources) {
                InputSource is;
                Source ss;
                if (src instanceof SAXSource) {
                    ss = (SAXSource)src;
                    is = ((SAXSource)ss).getInputSource();
                } else if (src instanceof StreamSource) {
                    ss = (StreamSource)src;
                    is = ((StreamSource)ss).getInputStream() != null ? new InputSource(((StreamSource)ss).getInputStream()) : (((StreamSource)ss).getReader() != null ? new InputSource(((StreamSource)ss).getReader()) : new InputSource(((StreamSource)ss).getSystemId()));
                } else {
                    throw new IllegalArgumentException("Unknown kind of source");
                }
                is.setSystemId(src.getSystemId());
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(is);
                doc.setBaseURI(is.getSystemId());
                JDOMDocumentWrapper jdom = new JDOMDocumentWrapper(doc, this.getConfiguration());
                jdomSources.add(jdom.getRootNode());
            }
            return jdomSources;
        }
        catch (JDOMException e) {
            throw new XPathException(e);
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    public static void main(String[] args) {
        new JDOMTransform().doTransform(args, "JDOMTransform");
    }
}

