/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.axiom;

import java.util.Iterator;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.option.axiom.AxiomAttributeWrapper;
import net.sf.saxon.option.axiom.AxiomDocument;
import net.sf.saxon.option.axiom.AxiomDocumentNodeWrapper;
import net.sf.saxon.option.axiom.AxiomElementNodeWrapper;
import net.sf.saxon.option.axiom.AxiomParentNodeWrapper;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.AbstractNodeWrapper;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.type.SchemaType;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;

public class AxiomLeafNodeWrapper
extends AbstractNodeWrapper
implements SiblingCountingNode {
    protected OMNode node;
    protected short nodeKind;
    private AxiomParentNodeWrapper parent;
    private AxiomDocument docWrapper;
    protected int index;

    protected AxiomLeafNodeWrapper(OMNode node, AxiomDocument docWrapper, AxiomParentNodeWrapper parent, int index) {
        if (docWrapper == null) {
            throw new NullPointerException();
        }
        int kind = node.getType();
        switch (kind) {
            case 4: {
                this.nodeKind = (short)3;
                break;
            }
            case 5: {
                this.nodeKind = (short)8;
                break;
            }
            case 3: {
                this.nodeKind = (short)7;
                break;
            }
            default: {
                AxiomLeafNodeWrapper.throwIllegalNode(node);
                return;
            }
        }
        this.node = node;
        this.parent = parent;
        this.docWrapper = docWrapper;
        this.index = index;
        this.treeInfo = docWrapper;
    }

    private static void throwIllegalNode(OMNode node) {
        String str = node == null ? "NULL" : node.getClass() + " instance " + node;
        throw new IllegalArgumentException("Bad node type in XOM! " + str);
    }

    public OMNode getUnderlyingNode() {
        return this.node;
    }

    @Override
    public int getNodeKind() {
        return this.nodeKind;
    }

    @Override
    public SchemaType getSchemaType() {
        return null;
    }

    @Override
    public int compareOrder(NodeInfo other) {
        if (other instanceof AxiomDocument) {
            return 1;
        }
        if (other instanceof AxiomAttributeWrapper) {
            if (other.getParent() == this.getParent()) {
                return 1;
            }
            return this.getParent().compareOrder(other.getParent());
        }
        if (other instanceof NamespaceNode) {
            return -other.compareOrder(this);
        }
        return Navigator.compareOrder(this, (SiblingCountingNode)other);
    }

    @Override
    public CharSequence getStringValueCS() {
        switch (this.nodeKind) {
            case 3: {
                return ((OMText)this.node).getText();
            }
            case 8: {
                return ((OMComment)this.node).getValue();
            }
            case 7: {
                return ((OMProcessingInstruction)this.node).getValue();
            }
        }
        throw new AssertionError();
    }

    @Override
    public String getLocalPart() {
        switch (this.nodeKind) {
            case 7: {
                return ((OMProcessingInstruction)this.node).getTarget();
            }
        }
        return "";
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public String getURI() {
        return "";
    }

    @Override
    public String getDisplayName() {
        switch (this.nodeKind) {
            case 7: {
                return ((OMProcessingInstruction)this.node).getTarget();
            }
        }
        return "";
    }

    @Override
    public AxiomParentNodeWrapper getParent() {
        if (this.parent == null) {
            OMContainer rawParent = this.node.getParent();
            this.parent = rawParent instanceof OMDocument ? (AxiomDocumentNodeWrapper)this.docWrapper.getRootNode() : (AxiomElementNodeWrapper)AxiomDocument.makeWrapper((OMNode)((OMElement)rawParent), this.docWrapper, null, -1);
        }
        return this.parent;
    }

    @Override
    public int getSiblingPosition() {
        if (this.index != -1) {
            return this.index;
        }
        OMContainer p = this.node.getParent();
        int ix = 0;
        Iterator kids = p.getChildren();
        while (kids.hasNext()) {
            if (kids.next() == this.node) {
                this.index = ix;
                return this.index;
            }
            ++ix;
        }
        throw new IllegalStateException("Bad child/parent relationship in Axiom tree");
    }

    @Override
    protected AxisIterator iterateAttributes(NodeTest nodeTest) {
        return EmptyIterator.OfNodes.THE_INSTANCE;
    }

    @Override
    protected AxisIterator iterateChildren(NodeTest nodeTest) {
        return EmptyIterator.OfNodes.THE_INSTANCE;
    }

    @Override
    protected AxisIterator iterateSiblings(NodeTest nodeTest, boolean forwards) {
        if (forwards) {
            if (nodeTest instanceof AnyNodeTest) {
                return new AxiomDocument.FollowingSiblingIterator(this.node, this.parent, this.docWrapper);
            }
            return new Navigator.AxisFilter(new AxiomDocument.FollowingSiblingIterator(this.node, this.parent, this.docWrapper), nodeTest);
        }
        if (nodeTest instanceof AnyNodeTest) {
            return new AxiomDocument.PrecedingSiblingIterator(this.node, this.parent, this.docWrapper);
        }
        return new Navigator.AxisFilter(new AxiomDocument.PrecedingSiblingIterator(this.node, this.parent, this.docWrapper), nodeTest);
    }

    @Override
    protected AxisIterator iterateDescendants(NodeTest nodeTest, boolean includeSelf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeInfo getRoot() {
        return this.getParent().getRoot();
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        Navigator.appendSequentialKey(this, buffer, true);
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return null;
    }
}

