/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.serialize;

import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.ptree.PTreeEmitter;
import com.saxonica.serialize.AttributeSorter;
import com.saxonica.serialize.Base64BinaryEmitter;
import com.saxonica.serialize.DecimalCharacterReferenceGenerator;
import com.saxonica.serialize.HTMLEntityReferenceGenerator;
import com.saxonica.serialize.HTMLIndenterPE;
import com.saxonica.serialize.HexBinaryEmitter;
import com.saxonica.serialize.NamespaceSorter;
import com.saxonica.serialize.OuterNewlineInserter;
import com.saxonica.serialize.SequenceWrapperPE;
import com.saxonica.serialize.XMLIndenterPE;
import com.saxonica.serialize.XQueryEmitter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceNormalizerWithSpaceSeparator;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TransformerReceiver;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.query.SequenceWrapper;
import net.sf.saxon.serialize.BinaryTextDecoder;
import net.sf.saxon.serialize.CharacterMapExpander;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.HTML40Emitter;
import net.sf.saxon.serialize.HTML50Emitter;
import net.sf.saxon.serialize.HTMLEmitter;
import net.sf.saxon.serialize.HexCharacterReferenceGenerator;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.serialize.XHTML1Emitter;
import net.sf.saxon.serialize.XHTML5Emitter;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public class SerializerFactoryPE
extends SerializerFactory {
    public SerializerFactoryPE(ProfessionalConfiguration config) {
        super(config);
    }

    @Override
    protected SequenceReceiver createSaxonSerializationMethod(String method, SerializationProperties serProps, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer, StreamResult result) throws XPathException {
        Properties props = serProps.getProperties();
        pipe.getConfiguration().checkLicensedFeature(8, "custom serialization", -1);
        if ("{http://saxon.sf.net/}xquery".equals(method)) {
            XQueryEmitter emitter = new XQueryEmitter();
            emitter.setPipelineConfiguration(pipe);
            emitter.setStreamResult(result);
            props.setProperty("omit-xml-declaration", "yes");
            emitter.setOutputProperties(props);
            return this.createXMLSerializer(emitter, serProps);
        }
        if ("{http://saxon.sf.net/}base64Binary".equals(method)) {
            Base64BinaryEmitter emitter = new Base64BinaryEmitter();
            emitter.setPipelineConfiguration(pipe);
            emitter.setStreamResult(result);
            props.setProperty("omit-xml-declaration", "yes");
            emitter.setOutputProperties(props);
            return emitter;
        }
        if ("{http://saxon.sf.net/}hexBinary".equals(method)) {
            HexBinaryEmitter emitter = new HexBinaryEmitter();
            emitter.setPipelineConfiguration(pipe);
            emitter.setStreamResult(result);
            props.setProperty("omit-xml-declaration", "yes");
            emitter.setOutputProperties(props);
            return emitter;
        }
        if ("{http://saxon.sf.net/}ptree".equals(method)) {
            return new PTreeEmitter(pipe);
        }
        XPathException err = new XPathException("Unknown serialization method " + method);
        err.setErrorCode("SXCH0004");
        throw err;
    }

    @Override
    protected ProxyReceiver newHTMLIndenter(Receiver next, Properties outputProperties) {
        HTMLIndenterPE r = new HTMLIndenterPE(next, "html");
        r.setOutputProperties(outputProperties);
        return r;
    }

    @Override
    protected ProxyReceiver newXHTMLIndenter(Receiver next, Properties outputProperties) {
        String method = "xhtml";
        String htmlVersion = outputProperties.getProperty("html-version");
        if (htmlVersion != null && htmlVersion.startsWith("5")) {
            method = "xhtml5";
        }
        HTMLIndenterPE r = new HTMLIndenterPE(next, method);
        r.setOutputProperties(outputProperties);
        return r;
    }

    @Override
    protected ProxyReceiver newXMLIndenter(XMLEmitter next, Properties outputProperties) {
        if ("yes".equals(outputProperties.getProperty("{http://saxon.sf.net/}canonical"))) {
            return new OuterNewlineInserter(next);
        }
        XMLIndenterPE r = new XMLIndenterPE(next);
        r.setOutputProperties(outputProperties);
        return r;
    }

    @Override
    protected Emitter newXMLEmitter(Properties properties) {
        XMLEmitter emitter = new XMLEmitter();
        String rep = properties.getProperty("{http://saxon.sf.net/}character-representation");
        if ("decimal".equals(rep = Whitespace.trim(rep))) {
            emitter.setCharacterReferenceGenerator(DecimalCharacterReferenceGenerator.THE_INSTANCE);
        }
        return emitter;
    }

    @Override
    protected Emitter newHTMLEmitter(Properties properties) {
        HTMLEmitter emitter = SaxonOutputKeys.isHtmlVersion5(properties) ? new HTML50Emitter() : new HTML40Emitter();
        this.setCharacterRepresention(emitter, properties);
        return emitter;
    }

    @Override
    protected ProxyReceiver newAttributeSorter(Receiver next, Properties outputProperties) {
        AttributeSorter r = new AttributeSorter(next);
        r.setOutputProperties(outputProperties);
        return r;
    }

    @Override
    protected Receiver newNamespaceSorter(Receiver next, Properties outputProperties) {
        return new NamespaceSorter(next);
    }

    private void setCharacterRepresention(XMLEmitter emitter, Properties properties) {
        String rep = properties.getProperty("{http://saxon.sf.net/}character-representation");
        if (rep != null) {
            String excludedRep;
            String nonASCIIrep;
            int semi = rep.indexOf(59);
            if (semi < 0) {
                excludedRep = nonASCIIrep = Whitespace.trim(rep);
            } else {
                nonASCIIrep = Whitespace.trim(rep.substring(0, semi));
                excludedRep = Whitespace.trim(rep.substring(semi + 1));
            }
            if ("native".equals(excludedRep)) {
                excludedRep = "entity";
            }
            if (!"native".equals(nonASCIIrep)) {
                emitter.setEscapeNonAscii(true);
                if ("entity".equals(nonASCIIrep)) {
                    if ("decimal".equals(excludedRep)) {
                        emitter.setCharacterReferenceGenerator(HTMLEntityReferenceGenerator.DECIMAL);
                    } else {
                        emitter.setCharacterReferenceGenerator(HTMLEntityReferenceGenerator.HEX);
                    }
                } else if ("decimal".equals(nonASCIIrep)) {
                    emitter.setCharacterReferenceGenerator(DecimalCharacterReferenceGenerator.THE_INSTANCE);
                } else {
                    emitter.setCharacterReferenceGenerator(HexCharacterReferenceGenerator.THE_INSTANCE);
                }
            }
        }
    }

    @Override
    protected Emitter newXHTMLEmitter(Properties properties) {
        boolean is5 = SaxonOutputKeys.isXhtmlHtmlVersion5(properties);
        XMLEmitter emitter = is5 ? new XHTML5Emitter() : new XHTML1Emitter();
        this.setCharacterRepresention(emitter, properties);
        return emitter;
    }

    @Override
    public Receiver addTextOutputFilter(Receiver next, Properties properties) throws XPathException {
        boolean recognize = "yes".equals(properties.getProperty("{http://saxon.sf.net/}recognize-binary"));
        if (recognize) {
            return new BinaryTextDecoder(next, properties);
        }
        return next;
    }

    @Override
    public SequenceReceiver prepareNextStylesheet(PipelineConfiguration pipe, String href, String baseURI, Result result) throws XPathException {
        Configuration config = pipe.getConfiguration();
        config.checkLicensedFeature(8, "saxon:next-in-chain", -1);
        PreparedStylesheet thisStylesheet = (PreparedStylesheet)pipe.getController().getExecutable();
        PreparedStylesheet next = thisStylesheet.getCachedStylesheet(href, baseURI);
        if (next == null) {
            Source source = null;
            try {
                if (pipe.getURIResolver() != null) {
                    source = pipe.getURIResolver().resolve(href, baseURI);
                }
                if (source == null) {
                    source = pipe.getController().getStandardURIResolver().resolve(href, baseURI);
                }
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
            CompilerInfo compilerInfo = new CompilerInfo(config.getDefaultXsltCompilerInfo());
            compilerInfo.setGenerateByteCode(config.isGenerateByteCode(50));
            compilerInfo.setTargetEdition(config.getEditionCode());
            compilerInfo.setJustInTimeCompilation(config.isJITEnabled());
            next = Compilation.compileSingletonPackage(config, compilerInfo, source);
            thisStylesheet.putCachedStylesheet(href, baseURI, next);
        }
        Receiver destination = next.getConfiguration().getSerializerFactory().getReceiver(result, next.getDeclaredSerializationProperties(), pipe);
        XsltController nextController = next.newController();
        TransformerReceiver nextTransformer = new TransformerReceiver(nextController);
        nextController.initializeController(new GlobalParameterSet());
        nextTransformer.setSystemId(pipe.getController().getBaseOutputURI());
        nextTransformer.setPipelineConfiguration(new PipelineConfiguration(pipe));
        nextTransformer.setDestination(destination);
        return new SequenceNormalizerWithSpaceSeparator(nextTransformer);
    }

    @Override
    public SequenceWrapper newSequenceWrapper(Receiver destination) {
        return new SequenceWrapperPE(destination);
    }

    @Override
    public String checkOutputProperty(String key, String value) throws XPathException {
        block53: {
            block52: {
                Configuration config = this.getConfiguration();
                if (!key.startsWith("{http://saxon.sf.net/}")) break block52;
                switch (key) {
                    case "{http://saxon.sf.net/}newline": {
                        break;
                    }
                    case "{http://saxon.sf.net/}attribute-order": {
                        if (value != null) {
                            SerializerFactoryPE.checkListOfClarkNamesAllowingStar(key, value);
                            break;
                        }
                        break block53;
                    }
                    case "{http://saxon.sf.net/}canonical": {
                        if (value != null) {
                            value = SerializerFactoryPE.checkYesOrNo(key, value);
                            break;
                        }
                        break block53;
                    }
                    case "{http://saxon.sf.net/}stylesheet-version": {
                        break;
                    }
                    case "{http://saxon.sf.net/}indent-spaces": {
                        if (value != null) {
                            this.checkExtensions(key);
                            SerializerFactoryPE.checkNonNegativeInteger(key, value);
                            break;
                        }
                        break block53;
                    }
                    case "{http://saxon.sf.net/}line-length": {
                        if (value != null) {
                            this.checkExtensions(key);
                            SerializerFactoryPE.checkNonNegativeInteger(key, value);
                            break;
                        }
                        break block53;
                    }
                    case "{http://saxon.sf.net/}character-representation": {
                        this.checkExtensions(key);
                        break;
                    }
                    case "{http://saxon.sf.net/}next-in-chain": {
                        this.checkExtensions(key);
                        break;
                    }
                    case "{http://saxon.sf.net/}next-in-chain-base-uri": {
                        break;
                    }
                    case "{http://saxon.sf.net/}require-well-formed": {
                        if (value != null) {
                            value = SerializerFactoryPE.checkYesOrNo(key, value);
                            break;
                        }
                        break block53;
                    }
                    case "{http://saxon.sf.net/}recognize-binary": {
                        if (value != null) {
                            this.checkExtensions(key);
                            value = SerializerFactoryPE.checkYesOrNo(key, value);
                            break;
                        }
                        break block53;
                    }
                    case "{http://saxon.sf.net/}double-space": {
                        if (value != null) {
                            this.checkExtensions(key);
                            SerializerFactoryPE.checkListOfClarkNames(key, value);
                            break;
                        }
                        break block53;
                    }
                    case "{http://saxon.sf.net/}wrap-result-sequence": {
                        if (value != null) {
                            this.checkExtensions(key);
                            value = SerializerFactoryPE.checkYesOrNo(key, value);
                            break;
                        }
                        break block53;
                    }
                    case "{http://saxon.sf.net/}supply-source-locator": {
                        if (value != null) {
                            value = SerializerFactoryPE.checkYesOrNo(key, value);
                            break;
                        }
                        break block53;
                    }
                    case "{http://saxon.sf.net/}single-quotes": {
                        if (value != null) {
                            this.checkExtensions(key);
                            value = SerializerFactoryPE.checkYesOrNo(key, value);
                            break;
                        }
                        break block53;
                    }
                    case "{http://saxon.sf.net/}unfailing": {
                        if (value != null) {
                            value = SerializerFactoryPE.checkYesOrNo(key, value);
                            break;
                        }
                        break block53;
                    }
                    case "{http://saxon.sf.net/}property-order": {
                        break;
                    }
                    case "parameter-document": 
                    case "{http://saxon.sf.net/}parameter-document-base-uri": {
                        break;
                    }
                    default: {
                        throw new XPathException("Unknown serialization parameter " + Err.wrap(key), "XQST0109");
                    }
                }
                break block53;
            }
            return super.checkOutputProperty(key, value);
        }
        return value;
    }

    @Override
    protected void checkExtensions(String key) {
        this.getConfiguration().checkLicensedFeature(8, "custom serialization " + key, -1);
    }

    @Override
    protected Comparator<AtomicValue> getPropertySorter(String propertyOrder) {
        int MIDDLE_GROUND = 10000000;
        HashMap<String, Integer> knownKeys = new HashMap<String, Integer>();
        int pos = 0;
        StringTokenizer st2 = new StringTokenizer(propertyOrder, " \t\n\r", false);
        while (st2.hasMoreTokens()) {
            String key = st2.nextToken();
            if (key.equals("*")) {
                pos += 10000000;
                continue;
            }
            knownKeys.put(key, pos++);
        }
        return (n0, n1) -> {
            Integer r0 = (Integer)knownKeys.get(n0.getStringValue());
            Integer r1 = (Integer)knownKeys.get(n1.getStringValue());
            if (r0 != null) {
                if (r1 == null) {
                    return r0.compareTo(10000000);
                }
                return r0.compareTo(r1);
            }
            if (r1 != null) {
                return Integer.compare(10000000, r1);
            }
            return n0.getStringValue().compareTo(n1.getStringValue());
        };
    }
}

