/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.EvaluationNuisance;
import com.saxonica.config.JavaExtensionLibrary;
import com.saxonica.config.Verifier;
import com.saxonica.config.pe.ConfigurationReaderPE;
import com.saxonica.config.pe.DynamicLoaderPE;
import com.saxonica.config.pe.StyleNodeFactoryPE;
import com.saxonica.expr.HofParserExtension;
import com.saxonica.expr.MemoFunction;
import com.saxonica.expr.ObjectLookupExpression;
import com.saxonica.expr.StaticQueryContextPE;
import com.saxonica.expr.XQueryParserExtensionPE;
import com.saxonica.functions.extfn.EXPathFileFunctionSet;
import com.saxonica.functions.extfn.ObjectMap;
import com.saxonica.functions.extfn.VendorFunctionSetPE;
import com.saxonica.functions.hof.FunctionSequenceCoercer;
import com.saxonica.functions.hof.TypeHierarchyPE;
import com.saxonica.functions.registry.UseWhen30HOFunctionSet;
import com.saxonica.functions.registry.XPath30HOFunctionSet;
import com.saxonica.functions.registry.XPath31HOFunctionSet;
import com.saxonica.functions.registry.XQUpdate10FunctionSet;
import com.saxonica.functions.registry.XSLT30HOFunctionSet;
import com.saxonica.ptree.PTreeSource;
import com.saxonica.serialize.SerializerFactoryPE;
import com.saxonica.trans.EvaluateInstr;
import com.saxonica.trans.ModePE;
import com.saxonica.trans.PackageLoaderPE;
import com.saxonica.xsltextn.ExtensionElementFactory;
import com.saxonica.xsltextn.TypeAliasManagerPE;
import com.saxonica.xsltextn.style.Saxon6ElementFactory;
import com.saxonica.xsltextn.style.SaxonElementFactory;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.MathFunctionSet;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.functions.registry.ConstructorFunctionLibrary;
import net.sf.saxon.functions.registry.ExsltCommonFunctionSet;
import net.sf.saxon.functions.registry.OnDemandFunctionSet;
import net.sf.saxon.functions.registry.UseWhen30FunctionSet;
import net.sf.saxon.functions.registry.XPath30FunctionSet;
import net.sf.saxon.functions.registry.XPath31FunctionSet;
import net.sf.saxon.functions.registry.XSLT30FunctionSet;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.lib.StaticQueryContextFactory;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.PatternParser30;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLEvaluate;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.ConfigurationReader;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.TypeAliasManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;

public class ProfessionalConfiguration
extends Configuration {
    private transient HashMap<String, FunctionLibrary> extensionBinders;
    private boolean licenseFound = false;
    private boolean licenseNotFound = false;
    private transient Verifier verifier;
    private transient HashMap<String, ExtensionElementFactory> xsltExtensionElementNamespaceMap;
    protected BuiltInFunctionSet vendorFunctionSet;
    private HashMap<Class, JavaExternalObjectType> externalObjectTypeCache = new HashMap();
    private IndependentContext staticContextForSystemFunctions;

    public ProfessionalConfiguration() {
        if (!"com.saxonica.config.ProfessionalConfiguration".equals(this.getClass().getName()) && !"com.saxonica.config.EnterpriseConfiguration".equals(this.getClass().getName())) {
            throw new LicenseException("Unauthorized subclass of Configuration", 6);
        }
        this.setDynamicLoader(new DynamicLoaderPE());
        this.verifier = new Verifier();
        this.declareBuiltInExtensionElementNamespaces();
        this.declareBuiltInExtensionFunctions();
        this.setSerializerFactory(new SerializerFactoryPE(this));
        this.setStaticQueryContextFactory(new StaticQueryContextFactory(){

            @Override
            public StaticQueryContext newStaticQueryContext(Configuration config, boolean copyFromDefault) {
                return new StaticQueryContextPE(ProfessionalConfiguration.this, copyFromDefault);
            }
        });
        this.internalSetBooleanProperty(Feature.DISABLE_XSL_EVALUATE, false);
    }

    @Override
    protected ConfigurationReader makeConfigurationReader() {
        return new ConfigurationReaderPE();
    }

    public static Configuration makeProfessionalConfiguration(ClassLoader classLoader, String className) throws RuntimeException {
        if (className == null) {
            className = "com.saxonica.config.ProfessionalConfiguration";
        }
        try {
            return ProfessionalConfiguration.instantiateConfiguration(className, classLoader);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getEditionCode() {
        return "PE";
    }

    @Override
    public TypeHierarchy getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.typeHierarchy = new TypeHierarchyPE(this);
        }
        return this.typeHierarchy;
    }

    @Override
    public TypeAliasManager makeTypeAliasManager() {
        if (this.isLicensedFeature(8)) {
            return new TypeAliasManagerPE();
        }
        return super.makeTypeAliasManager();
    }

    @Override
    public PackageLoaderPE makePackageLoader() {
        return new PackageLoaderPE(this);
    }

    @Override
    public void setConfigurationProperty(String name, Object value) {
        if (name.equals("http://saxonica.com/oem-data")) {
            this.supplyLicenseKey(new BufferedReader(new StringReader((String)value)));
        } else {
            Feature<?> f = Feature.byName(name);
            if (f != null) {
                this.setConfigurationProperty(f, value);
            } else if (name.startsWith("http://saxon.sf.net/feature/parserFeature?uri=") || name.startsWith("http://saxon.sf.net/feature/parserProperty?uri=")) {
                super.setConfigurationProperty(name, value);
            } else {
                super.setConfigurationProperty(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void setConfigurationProperty(Feature<T> feature, T value) {
        if (feature == Feature.ALLOW_OLD_JAVA_URI_FORMAT) {
            this.internalSetBooleanProperty(Feature.ALLOW_OLD_JAVA_URI_FORMAT, value);
            boolean b = ProfessionalConfiguration.requireBoolean(feature.name, value);
            ((JavaExtensionLibrary)this.getExtensionBinder("java")).setStrictJavaUriFormat(!b);
        } else if (feature == Feature.LICENSE_FILE_LOCATION) {
            Verifier verifier = this.verifier;
            synchronized (verifier) {
                this.verifier.loadLicense((String)value);
                this.licenseFound = true;
                this.licenseNotFound = false;
                this.setLicensedFeatures();
            }
        } else {
            super.setConfigurationProperty(feature, value);
        }
    }

    public void supplyLicenseKey(BufferedReader reader) {
        this.verifier.supplyLicenseKey(reader);
        this.licenseFound = true;
        this.licenseNotFound = false;
        this.setLicensedFeatures();
    }

    protected final void forceLoadLicense() throws LicenseException {
        this.verifier.loadLicense(this);
    }

    @Override
    public void importLicenseDetails(Configuration other) {
        if (other instanceof ProfessionalConfiguration) {
            ProfessionalConfiguration pc = (ProfessionalConfiguration)other;
            this.verifier = pc.verifier;
            this.licenseFound = pc.licenseFound;
            this.licenseNotFound = pc.licenseNotFound;
            this.setLicensedFeatures();
        }
    }

    protected String getFeature(String name) {
        String f = this.verifier.getFeature(name, this);
        if (!this.licenseFound) {
            this.licenseFound = true;
            this.licenseNotFound = false;
            this.setLicensedFeatures();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkLicensedFeature(int feature, String name, int localLicenseId) throws LicenseException {
        if (feature != 8) {
            throw new LicenseException("Requested feature (" + name + ") requires Saxon-EE, but the current Configuration is an instance of com.saxonica.config.ProfessionalConfiguration", 6);
        }
        if (localLicenseId >= 0 && this.isFeatureAllowedBySecondaryLicense(localLicenseId, feature)) {
            return;
        }
        if (this.licenseNotFound) {
            try {
                this.loadLicense();
            }
            catch (Exception err) {
                int reason = err instanceof LicenseException ? ((LicenseException)err).getReason() : 5;
                String msg = err.getMessage() + ". A license is needed to use " + name;
                throw new LicenseException(msg, reason);
            }
        }
        if (this.licenseFound) {
            if (!this.testFeature(feature)) {
                throw new LicenseException("Requested feature (" + name + ") requires Saxon-EE, but the current Configuration is an instance of com.saxonica.config.ProfessionalConfiguration", 6);
            }
        } else {
            Verifier verifier = this.verifier;
            synchronized (verifier) {
                this.loadLicense();
                this.licenseFound = true;
                this.reportIfMissingLicenseFeature(feature, name);
            }
        }
    }

    @Override
    public void disableLicensing() {
        this.verifier.disableLicensing();
        this.licenseNotFound = true;
        this.licenseFound = false;
    }

    @Override
    public boolean isFeatureAllowedBySecondaryLicense(int localLicenseId, int feature) {
        return this.verifier.isFeatureAllowedBySecondaryLicense(localLicenseId, feature);
    }

    protected void reportIfMissingLicenseFeature(int feature, String name) {
        if (!this.testFeature(feature)) {
            throw new LicenseException("A valid license was found (" + this.verifier.getSerialNumber() + "), but does not support the requested feature (" + name + ")", 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLicensedFeature(int feature) throws LicenseException {
        if (this.licenseNotFound) {
            return false;
        }
        Verifier verifier = this.verifier;
        synchronized (verifier) {
            if (!this.licenseFound) {
                try {
                    this.loadLicense();
                }
                catch (LicenseException e) {
                    if (e.getReason() == 3) {
                        this.licenseNotFound = true;
                        return false;
                    }
                    throw e;
                }
            }
            this.licenseFound = true;
            return this.testFeature(feature);
        }
    }

    @Override
    public final String getLicenseFeature(String name) {
        return this.verifier.getFeature(name, this);
    }

    protected final void loadLicense() throws LicenseException {
        this.verifier.loadPrimaryLicense(this);
        if (System.currentTimeMillis() % 100L == 42L && "yes".equals(this.verifier.getFeature("Evaluation", this))) {
            SerializerFactoryPE sf = new SerializerFactoryPE(this){

                @Override
                public Receiver getReceiver(Result result, SerializationProperties params, PipelineConfiguration pipe) throws XPathException {
                    Receiver r = super.getReceiver(result, params, pipe);
                    if (r instanceof EvaluationNuisance) {
                        return r;
                    }
                    return new EvaluationNuisance(r);
                }
            };
            this.setSerializerFactory(sf);
        }
        this.setLicensedFeatures();
    }

    protected void setLicensedFeatures() {
    }

    @Override
    public int registerLocalLicense(String dmk) {
        return this.verifier.registerSecondaryLicense(dmk);
    }

    protected boolean testFeature(int feature) {
        return feature == 8;
    }

    public boolean isLicenseNotFound() {
        return this.licenseNotFound;
    }

    public boolean isLicenseFound() {
        return this.licenseFound;
    }

    @Override
    public void displayLicenseMessage() {
        if (this.licenseNotFound) {
            if (this.isTiming()) {
                this.getStandardErrorOutput().println("No license file found - running with licensable features disabled");
            }
        } else {
            try {
                this.verifier.displayLicenseMessage(this);
                this.licenseFound = true;
                this.setLicensedFeatures();
            }
            catch (LicenseException err) {
                this.licenseFound = false;
                this.licenseNotFound = true;
                if (err.getReason() == 3) {
                    this.getStandardErrorOutput().println("No license file found - running with licensable features disabled");
                }
                throw err;
            }
        }
    }

    @Override
    public StyleNodeFactory makeStyleNodeFactory(Compilation compilation) {
        int feature;
        int locLic;
        PackageData pack = compilation.getPackageData();
        if (pack != null && !this.isFeatureAllowedBySecondaryLicense(locLic = pack.getLocalLicenseId(), feature = 8) && !this.isLicensedFeature(feature)) {
            return super.makeStyleNodeFactory(compilation);
        }
        return new StyleNodeFactoryPE(this, compilation);
    }

    @Override
    public Expression makeEvaluateInstruction(XSLEvaluate source, ComponentDeclaration decl) throws XPathException {
        Expression xpath = source.getTargetExpression();
        SequenceType requiredType = source.getRequiredType();
        Expression contextItem = source.getContextItemExpression();
        Expression baseUri = source.getBaseUriExpression();
        Expression namespaceContext = source.getNamespaceContextExpression();
        Expression schemaAware = source.getSchemaAwareExpression();
        Expression withParams = source.getWithParamsExpression();
        EvaluateInstr inst = new EvaluateInstr(xpath, requiredType, contextItem, baseUri, namespaceContext, schemaAware);
        WithParam[] params = source.getWithParamInstructions(inst, source.getCompilation(), decl, false);
        inst.setActualParams(params);
        inst.setDynamicParams(withParams);
        inst.setDefaultXPathNamespace(source.getDefaultXPathNamespace());
        inst.setOptionsExpression(source.getOptionsExpression());
        return inst;
    }

    @Override
    public XPathParser newExpressionParser(String language, boolean updating, int languageVersion) throws XPathException {
        if (updating) {
            throw new IllegalArgumentException("XQuery Update requires Saxon-EE");
        }
        if ("XQ".equals(language)) {
            if (languageVersion == 31 || languageVersion == 30 || languageVersion == 10) {
                XQueryParser parser = new XQueryParser();
                parser.setLanguage(3, 31);
                if (this.isLicensedFeature(8)) {
                    parser.setParserExtension(new XQueryParserExtensionPE());
                }
                return parser;
            }
            throw new IllegalArgumentException("Unknown XQuery version " + languageVersion);
        }
        if ("XP".equals(language)) {
            XPathParser parser = super.newExpressionParser(language, updating, languageVersion);
            if (languageVersion > 20 && this.isLicensedFeature(8)) {
                parser.setParserExtension(new HofParserExtension());
            }
            return parser;
        }
        if ("PATTERN".equals(language)) {
            PatternParser30 parser = new PatternParser30();
            if (this.isLicensedFeature(8)) {
                parser.setParserExtension(new HofParserExtension());
            }
            return parser;
        }
        return super.newExpressionParser(language, updating, languageVersion);
    }

    @Override
    public Expression makeFunctionSequenceCoercer(SpecificFunctionType type, Expression exp, RoleDiagnostic role) {
        return new FunctionSequenceCoercer(exp, type, role);
    }

    @Override
    public BuiltInFunctionSet getXSLT30FunctionSet() {
        if (this.isLicensedFeature(8)) {
            return XSLT30HOFunctionSet.getInstance();
        }
        return XSLT30FunctionSet.getInstance();
    }

    @Override
    public BuiltInFunctionSet getUseWhenFunctionSet() {
        if (this.isLicensedFeature(8)) {
            return UseWhen30HOFunctionSet.getInstance();
        }
        return UseWhen30FunctionSet.getInstance();
    }

    @Override
    public BuiltInFunctionSet getXPath30FunctionSet() {
        if (this.isLicensedFeature(8)) {
            return XPath30HOFunctionSet.getInstance();
        }
        return XPath30FunctionSet.getInstance();
    }

    @Override
    public BuiltInFunctionSet getXPath31FunctionSet() {
        if (this.isLicensedFeature(8)) {
            return XPath31HOFunctionSet.getInstance();
        }
        return XPath31FunctionSet.getInstance();
    }

    @Override
    public BuiltInFunctionSet getXQueryUpdateFunctionSet() {
        return XQUpdate10FunctionSet.getInstance();
    }

    public void setExtensionBinder(String scheme, FunctionLibrary binder) {
        if (this.extensionBinders == null) {
            this.extensionBinders = new HashMap(4);
        }
        this.extensionBinders.put(scheme, binder);
    }

    public FunctionLibrary getExtensionBinder(String scheme) {
        if (this.extensionBinders == null) {
            return null;
        }
        return this.extensionBinders.get(scheme);
    }

    @Override
    public void addExtensionBinders(FunctionLibraryList list) {
        if (this.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS) && this.extensionBinders != null) {
            for (FunctionLibrary functionLibrary : this.extensionBinders.values()) {
                list.addFunctionLibrary(functionLibrary);
            }
        }
    }

    @Override
    public Function getSystemFunction(StructuredQName name, int arity) throws XPathException {
        if (this.isLicensedFeature(8)) {
            try {
                if (this.staticContextForSystemFunctions == null) {
                    this.staticContextForSystemFunctions = new IndependentContext(this);
                }
                FunctionLibraryList lib = new FunctionLibraryList();
                lib.addFunctionLibrary(XPath31FunctionSet.getInstance());
                lib.addFunctionLibrary(this.getBuiltInExtensionLibraryList());
                lib.addFunctionLibrary(new ConstructorFunctionLibrary(this));
                lib.addFunctionLibrary(this.getIntegratedFunctionLibrary());
                lib.addFunctionLibrary(this.getExtensionBinder("java"));
                SymbolicName.F symbolicName = new SymbolicName.F(name, arity);
                return lib.getFunctionItem(symbolicName, this.staticContextForSystemFunctions);
            }
            catch (XPathException e) {
                return null;
            }
        }
        throw new XPathException("Dynamic function calls require a licensed Saxon Configuration");
    }

    @Override
    public FunctionLibraryList getBuiltInExtensionLibraryList() {
        if (!this.isLicensedFeature(8)) {
            return super.getBuiltInExtensionLibraryList();
        }
        if (this.builtInExtensionLibraryList == null) {
            this.vendorFunctionSet = new VendorFunctionSetPE(this);
            this.builtInExtensionLibraryList = new FunctionLibraryList();
            this.builtInExtensionLibraryList.addFunctionLibrary(this.vendorFunctionSet);
            this.builtInExtensionLibraryList.addFunctionLibrary(MathFunctionSet.getInstance());
            this.builtInExtensionLibraryList.addFunctionLibrary(MapFunctionSet.getInstance());
            this.builtInExtensionLibraryList.addFunctionLibrary(ArrayFunctionSet.getInstance());
            this.builtInExtensionLibraryList.addFunctionLibrary(ExsltCommonFunctionSet.getInstance());
            if (this.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS)) {
                this.builtInExtensionLibraryList.addFunctionLibrary(EXPathFileFunctionSet.getInstance());
                OnDemandFunctionSet sql = new OnDemandFunctionSet(this, "http://saxon.sf.net/sql", "com.saxonica.functions.sql.SQLFunctionSet");
                this.builtInExtensionLibraryList.addFunctionLibrary(sql);
            }
        }
        return this.builtInExtensionLibraryList;
    }

    public BuiltInFunctionSet getVendorFunctionSet() {
        return this.vendorFunctionSet;
    }

    @Override
    public UserFunction newUserFunction(boolean memoFunction, FunctionStreamability streamability) {
        if (memoFunction) {
            return new MemoFunction();
        }
        return new UserFunction();
    }

    public void declareBuiltInExtensionFunctions() {
    }

    public void declareBuiltInExtensionElementNamespaces() {
        try {
            this.setExtensionElementNamespace("http://saxon.sf.net/", SaxonElementFactory.class.getName());
            this.setExtensionElementNamespace("http://icl.com/saxon", Saxon6ElementFactory.class.getName());
        }
        catch (XPathException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void setExtensionElementNamespace(String namespace, String className) throws XPathException {
        if (NamespaceConstant.isReserved(namespace)) {
            throw new XPathException("Namespace " + namespace + " is reserved: it cannot be used for extension instructions");
        }
        if (this.xsltExtensionElementNamespaceMap == null) {
            this.xsltExtensionElementNamespaceMap = new HashMap(4);
        }
        try {
            ExtensionElementFactory factory = (ExtensionElementFactory)this.getInstance(className, null);
            this.xsltExtensionElementNamespaceMap.put(namespace, factory);
        }
        catch (ClassCastException e) {
            throw new XPathException("Class " + className + " is not an ExtensionElementFactory");
        }
    }

    public ExtensionElementFactory getExtensionElementFactory(String namespace) {
        if (this.xsltExtensionElementNamespaceMap == null) {
            return null;
        }
        return this.xsltExtensionElementNamespaceMap.get(namespace);
    }

    @Override
    public boolean isExtensionElementAvailable(StructuredQName qName) {
        ExtensionElementFactory eef = this.getExtensionElementFactory(qName.getURI());
        return eef != null && eef.getExtensionClass(qName.getLocalPart()) != null;
    }

    @Override
    public synchronized JavaExternalObjectType getJavaExternalObjectType(Class theClass) {
        JavaExternalObjectType jeot = this.externalObjectTypeCache.get(theClass);
        if (jeot == null) {
            jeot = new JavaExternalObjectType(this, theClass);
            this.externalObjectTypeCache.put(theClass, jeot);
        }
        return jeot;
    }

    @Override
    public Map<String, Function> makeMethodMap(Class javaClass, String required) {
        return ObjectMap.makeMethodMap(this, javaClass, required);
    }

    @Override
    public MapItem externalObjectAsMap(ObjectValue value, String required) {
        return ObjectMap.toMap(this, value, required);
    }

    @Override
    public Expression makeObjectLookupExpression(Expression lhs, Expression rhs) {
        return new ObjectLookupExpression(lhs, rhs);
    }

    @Override
    public Source resolveSource(Source source, Configuration config) throws XPathException {
        Source s = super.resolveSource(source, config);
        if (s != null) {
            return s;
        }
        if (source instanceof PTreeSource) {
            this.checkLicensedFeature(8, "PTree", -1);
            return ((PTreeSource)source).load(this).getRootNode();
        }
        if (source instanceof PullProvider) {
            this.checkLicensedFeature(8, "pull processing", -1);
            return source;
        }
        return null;
    }

    @Override
    public SimpleMode makeMode(StructuredQName modeName, CompilerInfo compilerInfo) {
        return new ModePE(modeName);
    }
}

