/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.sequence;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.event.SelectInTreeEvent;
import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.gui.uml.ContextMenu;
import ch.e2e.builder.trace.gui.uml.UmlEdge;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.gui.uml.sequence.CallMessageEdge;
import ch.e2e.builder.trace.testcase.TestcaseWatch;
import ch.e2e.builder.trace.testcase.uml.Adapter;
import ch.e2e.builder.trace.testcase.uml.Data;
import ch.e2e.builder.trace.testcase.uml.Message;
import ch.e2e.builder.trace.testcase.uml.Processor;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.event.EventController;
import ch.e2e.swing.MouseOverList;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jgraph.graph.Port;

public abstract class MessageEdge
extends UmlEdge
implements CellWithContextMenu {
    private static MessageContextMenu contextMenu;
    protected MessageDataModel parametersModel;
    protected MessageDataModel adapterIOModel;
    protected Processor processor;

    public MessageEdge(Object userObject, Processor processor, Port sourcePort, Port targetPort, E2EBuilderModule module) {
        super(userObject, module);
        this.processor = processor;
        if (sourcePort != null) {
            this.setSource(sourcePort);
        }
        if (targetPort != null) {
            this.setTarget(targetPort);
        }
        UmlGraphConstants.setMoveable((Map)this.attributes, (boolean)false);
        this.initializeParameters(userObject);
        this.initializeAdapterIO(userObject);
    }

    protected abstract void initializeParameters(Object var1);

    protected abstract void initializeAdapterIO(Object var1);

    public MessageContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new MessageContextMenu(this);
        }
        contextMenu.setCell(this);
        return contextMenu;
    }

    public AbstractCellAction<MessageEdge> getDefaultAction() {
        return this.getContextMenu().getDefaultAction();
    }

    @Override
    public boolean isContextMenuAlwaysTriggered() {
        return this.processor != null;
    }

    private static class ParameterRenderer
    extends DefaultListCellRenderer {
        private ParameterRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Message) {
                this.setText("message");
            }
            return this;
        }
    }

    protected static class MessageDataModel
    extends ArrayList<Object>
    implements ListModel {
        private boolean hasErrors = false;

        protected MessageDataModel() {
        }

        @Override
        public int getSize() {
            return this.size();
        }

        public Object getElementAt(int index) {
            return this.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }

        public void setHasErrors(boolean hasErrors) {
            this.hasErrors = hasErrors;
        }
    }

    private static class MessageContextMenu
    extends ContextMenu<MessageEdge> {
        private MouseOverList parameterList;
        private MouseOverList adapterIOList;

        public MessageContextMenu(MessageEdge cell) {
            super(cell);
            this.createMenu();
        }

        @Override
        public void setCell(MessageEdge cell) {
            super.setCell(cell);
            this.parameterList.setModel((ListModel)cell.parametersModel);
            this.adapterIOList.setModel((ListModel)cell.adapterIOModel);
            this.parameterList.setForeground(cell.parametersModel.hasErrors ? UmlGraphConstants.ERROR_COLOR : Color.BLACK);
            this.setDefaultItem(cell instanceof CallMessageEdge ? this.getTranslation("uml.diagram.action.show.activity") : null);
            this.setItemVisible(this.getTranslation("uml.diagram.action.show.activity"), cell instanceof CallMessageEdge);
            this.setItemEnabled(this.getTranslation("uml.diagram.action.show.parameters"), !cell.parametersModel.isEmpty());
            String name = this.getTranslation("uml.diagram.action.show.adapterIO");
            this.getItem(name).setText(cell instanceof CallMessageEdge ? "Show adapter input" : "Show adapter output");
            this.setItemVisible(name, cell.getUserObject() instanceof Adapter);
            this.setItemEnabled(name, !cell.adapterIOModel.isEmpty());
            name = this.getTranslation("uml.diagram.action.show.preprocessor");
            if (cell.processor != null) {
                this.getItem(name).setText("Show " + cell.processor.getClass().getSimpleName().toLowerCase());
            }
            this.setItemVisible(name, cell.processor != null);
        }

        private void createMenu() {
            this.addItem(new AbstractCellAction<MessageEdge>(this.getTranslation("uml.diagram.action.show.activity")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object o = ((MessageEdge)this.getCell()).getUserObject();
                    if (o instanceof UmlObject) {
                        EventController.fire((EventObject)new SelectInTreeEvent(this.getCell(), (UmlObject)o));
                    }
                }
            }, ACCELERATOR_SHOW_IN_TREE);
            this.parameterList = new MouseOverList((ListModel)((MessageEdge)this.getCell()).parametersModel);
            this.parameterList.setCellRenderer((ListCellRenderer)new ParameterRenderer());
            this.parameterList.setSelectionMode(0);
            this.parameterList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Object selected = parameterList.getSelectedValue();
                    if (selected != null) {
                        String entry = null;
                        if (selected instanceof Data) {
                            entry = ((Data)selected).getValue();
                        } else if (selected instanceof Message) {
                            entry = ((Message)selected).getName();
                        } else if (selected instanceof TestcaseWatch) {
                            entry = ((TestcaseWatch)selected).getId();
                        }
                        if (entry != null) {
                            EventController.fire((EventObject)new OpenLinkEvent(this, "file:///addToWatches?entry=" + entry));
                            this.setVisible(false);
                            parameterList.clearSelection();
                        }
                    }
                }
            });
            JMenu parametersMenu = new JMenu(this.getTranslation("uml.diagram.action.show.parameters"));
            parametersMenu.add((Component)this.parameterList);
            this.add(parametersMenu);
            this.adapterIOList = new MouseOverList((ListModel)((MessageEdge)this.getCell()).adapterIOModel);
            this.adapterIOList.setSelectionMode(0);
            this.adapterIOList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Data data = (Data)adapterIOList.getSelectedValue();
                    if (data != null) {
                        EventController.fire((EventObject)new OpenLinkEvent(this, "file:///addToWatches?entry=" + data.getValue()));
                        this.setVisible(false);
                        adapterIOList.clearSelection();
                    }
                }
            });
            JMenu adapterIOMenu = new JMenu(this.getTranslation("uml.diagram.action.show.adapterIO"));
            adapterIOMenu.add((Component)this.adapterIOList);
            this.add(adapterIOMenu);
            this.addItem(new AbstractCellAction<MessageEdge>(this.getTranslation("uml.diagram.action.show.preprocessor")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventController.fire((EventObject)new OpenLinkEvent(this, "file:///openActivity?activity=" + ((MessageEdge)this.getCell()).processor.getClass().getSimpleName().toLowerCase()));
                }
            });
        }
    }
}

