/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml;

import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.VertexView;

public class UmlVertexView
extends VertexView {
    private static final UmlVertexRenderer RENDERER = new UmlVertexRenderer();

    public UmlVertexView() {
    }

    public UmlVertexView(Object cell) {
        super(cell);
    }

    public CellViewRenderer getRenderer() {
        return RENDERER;
    }

    public Point2D getPerimeterPoint(EdgeView edge, Point2D source, Point2D p) {
        return this.getRenderer() instanceof UmlVertexRenderer ? ((UmlVertexRenderer)this.getRenderer()).getPerimeterPoint(this, source, p) : super.getPerimeterPoint(edge, source, p);
    }

    protected static class UmlVertexRenderer
    extends JPanel
    implements CellViewRenderer,
    Serializable {
        protected transient UmlVertexView view;
        protected transient boolean hasFocus;
        protected transient boolean selected;
        protected transient boolean preview;
        protected transient boolean childrenSelected;
        protected transient Color defaultForeground;
        protected transient Color defaultBackground;
        protected transient Color borderColor;
        protected transient int borderWidth;
        protected transient boolean dashedBorder = false;
        protected transient Color gradientColor = null;
        protected transient Color gridColor = Color.black;
        protected transient Color highlightColor = Color.YELLOW;
        protected transient Color lockedHandleColor = Color.YELLOW;
        protected transient boolean roundedCorners = true;
        protected transient boolean showStereotypes = false;
        protected transient UmlGraphConstants.IconPosition iconPosition = UmlGraphConstants.IconPosition.TOP_RIGHT;
        private transient JLabel stereotypeItem;
        private transient JLabel nameItem;
        private transient JLabel runtimeItem;
        private transient Icon icon;
        private static final transient Color STEREOTYPE_FOREGROUND = Color.BLUE;
        private String stereotype;
        private Long runtime;

        public UmlVertexRenderer() {
            this.defaultForeground = UIManager.getColor("Tree.textForeground");
            this.defaultBackground = UIManager.getColor("Tree.textBackground");
            this.createGui();
        }

        private void createGui() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.insets = new Insets(5, 5, 0, 5);
            this.stereotypeItem = new JLabel();
            this.stereotypeItem.setForeground(STEREOTYPE_FOREGROUND);
            this.add((Component)this.stereotypeItem, c);
            this.nameItem = new JLabel();
            Font font = this.nameItem.getFont();
            this.nameItem.setFont(font.deriveFont(font.getStyle() | 1));
            c.gridy = 1;
            c.weighty = 1.0;
            c.insets = new Insets(0, 5, 5, 5);
            this.add((Component)this.nameItem, c);
            this.runtimeItem = new JLabel();
            font = this.runtimeItem.getFont();
            this.runtimeItem.setFont(font.deriveFont(font.getStyle(), 10.0f));
            c.gridy = 2;
            c.weighty = 0.0;
            c.insets = new Insets(0, 25, 0, 0);
            c.anchor = 21;
            this.add((Component)this.runtimeItem, c);
        }

        public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
            UmlVertexRenderer component = null;
            if (view instanceof UmlVertexView) {
                this.gridColor = graph.getGridColor();
                this.highlightColor = graph.getHighlightColor();
                this.lockedHandleColor = graph.getLockedHandleColor();
                component = this;
                this.view = (UmlVertexView)view;
                if (view.isLeaf() || UmlGraphConstants.isGroupOpaque((Map)view.getAllAttributes())) {
                    this.installAttributes(view);
                } else {
                    this.resetAttributes();
                }
                this.setComponentOrientation(graph.getComponentOrientation());
                String stereotypeText = null;
                String nameText = null;
                String runtimeText = null;
                if (graph.getEditingCell() != view.getCell()) {
                    if (this.showStereotypes && this.stereotype != null) {
                        stereotypeText = "\u00ab" + this.stereotype + "\u00bb";
                    }
                    if (this.runtime != null) {
                        runtimeText = this.runtime + "ms";
                    }
                    nameText = graph.convertValueToString((Object)view);
                }
                this.stereotypeItem.setText(stereotypeText);
                this.nameItem.setText(nameText);
                this.runtimeItem.setText(runtimeText);
                this.hasFocus = focus;
                this.childrenSelected = graph.getSelectionModel().isChildrenSelected(view.getCell());
                this.selected = sel;
                this.preview = preview;
            }
            return component;
        }

        protected void resetAttributes() {
            this.stereotypeItem.setText(null);
            this.nameItem.setText(null);
            this.runtimeItem.setText(null);
            this.setToolTipText(null);
            this.setOpaque(false);
            this.setRoundedCorners(false);
            this.setDashedBorder(false);
            this.setBorderColor(Color.BLACK);
            this.setBorder(null);
            this.setGradientColor(null);
            this.setIcon(null);
            this.setIconPosition(UmlGraphConstants.IconPosition.TOP_RIGHT);
            this.setStereotype(null);
            this.setShowStereotypes(false);
            this.setRuntime(null);
        }

        protected void installAttributes(CellView view) {
            Color foreground;
            AttributeMap map = view.getAllAttributes();
            this.setToolTipText(UmlGraphConstants.getToolTipText((Map)map));
            this.setOpaque(UmlGraphConstants.isOpaque((Map)map));
            this.setBorder(UmlGraphConstants.getBorder((Map)map));
            this.setHorizontalAlignment((Map)map);
            this.setVerticalAlignment((Map)map);
            this.setHorizontalTextPosition((Map)map);
            this.setVerticalTextPosition((Map)map);
            this.roundedCorners = UmlGraphConstants.getRoundedCorners((Map)map);
            this.dashedBorder = UmlGraphConstants.getDashedBorder((Map)map);
            this.borderColor = UmlGraphConstants.getBorderColor((Map)map);
            this.borderWidth = Math.max(1, Math.round(UmlGraphConstants.getLineWidth((Map)map)));
            if (!this.roundedCorners && this.getBorder() == null && this.borderColor != null) {
                this.setBorder(BorderFactory.createLineBorder(this.borderColor, this.borderWidth));
            }
            this.setForeground((foreground = UmlGraphConstants.getForeground((Map)map)) != null ? foreground : this.defaultForeground);
            Color gradientColor = UmlGraphConstants.getGradientColor((Map)map);
            this.setGradientColor(gradientColor);
            Color background = UmlGraphConstants.getBackground((Map)map);
            this.setBackground(background != null ? background : this.defaultBackground);
            this.setFont(UmlGraphConstants.getFont((Map)map));
            this.setIcon(UmlGraphConstants.getIcon((Map)map));
            this.setIconPosition(UmlGraphConstants.getIconPosition((Map)map));
            this.setStereotype(UmlGraphConstants.getStereotype((Map)map));
            this.setShowStereotypes(UmlGraphConstants.getShowStereotype((Map)map));
            this.setRuntime(UmlGraphConstants.getRuntime((Map)map));
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke stroke = g2d.getStroke();
            if (this.dashedBorder) {
                g2d.setStroke(UmlGraphConstants.DASHED_STROKE);
            }
            if (this.isOpaque()) {
                if (this.roundedCorners) {
                    Color color = g.getColor();
                    Color background = this.getBackground();
                    if (this.gradientColor != null && !this.preview) {
                        g2d.setPaint(new GradientPaint(0.0f, 0.0f, background, this.getWidth(), this.getHeight(), this.gradientColor, true));
                    } else if (background != null) {
                        g.setColor(background);
                    }
                    g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.getArcWidth(), this.getArcHeight());
                    g.setColor(this.borderColor);
                    g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.getArcWidth(), this.getArcHeight());
                    g.setColor(color);
                    this.setOpaque(false);
                } else if (this.gradientColor != null && !this.preview) {
                    g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    this.setOpaque(false);
                }
                this.paintIcon(g);
            }
            g2d.setStroke(stroke);
            super.paint(g);
            this.paintSelectionBorder(g);
        }

        protected void paintIcon(Graphics g) {
            if (this.icon != null && !this.preview) {
                int y;
                int x;
                switch (this.iconPosition) {
                    case BOTTOM_LEFT: {
                        x = 5;
                        y = this.getHeight() - this.icon.getIconHeight() - 5;
                        break;
                    }
                    case BOTTOM_RIGHT: {
                        x = this.getWidth() - this.icon.getIconWidth() - 5;
                        y = this.getHeight() - this.icon.getIconHeight() - 5;
                        break;
                    }
                    case CENTER_LEFT: {
                        x = 5;
                        y = (this.getHeight() - this.icon.getIconHeight()) / 2;
                        break;
                    }
                    case CENTER_RIGHT: {
                        x = this.getWidth() - this.icon.getIconWidth() - 5;
                        y = (this.getHeight() - this.icon.getIconHeight()) / 2;
                        break;
                    }
                    case TOP_LEFT: {
                        x = 5;
                        y = 5;
                        break;
                    }
                    default: {
                        x = this.getWidth() - this.icon.getIconWidth() - 5;
                        y = 5;
                    }
                }
                this.icon.paintIcon(this, g, x, y);
            }
        }

        protected void paintSelectionBorder(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke previousStroke = g2d.getStroke();
            if (this.childrenSelected || this.selected) {
                g2d.setStroke(UmlGraphConstants.SELECTION_STROKE);
                if (this.childrenSelected) {
                    g.setColor(this.gridColor);
                } else if (this.hasFocus && this.selected) {
                    g.setColor(this.lockedHandleColor);
                } else {
                    g.setColor(this.highlightColor);
                }
                Dimension d = this.getSize();
                if (this.roundedCorners) {
                    g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.getArcWidth(), this.getArcHeight());
                } else {
                    g.drawRect(0, 0, d.width - 1, d.height - 1);
                }
            } else {
                g2d.setStroke(previousStroke);
            }
        }

        public Point2D getPerimeterPoint(VertexView view, Point2D source, Point2D p) {
            double yOut;
            double xOut;
            Rectangle2D bounds = view.getBounds();
            double x = bounds.getX();
            double y = bounds.getY();
            double width = bounds.getWidth();
            double height = bounds.getHeight();
            double xCenter = x + width / 2.0;
            double yCenter = y + height / 2.0;
            double dx = p.getX() - xCenter;
            double dy = p.getY() - yCenter;
            double alpha = Math.atan2(dy, dx);
            double pi = Math.PI;
            double pi2 = 1.5707963267948966;
            double beta = pi2 - alpha;
            double t = Math.atan2(height, width);
            if (alpha < -pi + t || alpha > pi - t) {
                xOut = x;
                yOut = yCenter - width * Math.tan(alpha) / 2.0;
            } else if (alpha < -t) {
                yOut = y;
                xOut = xCenter - height * Math.tan(beta) / 2.0;
            } else if (alpha < t) {
                xOut = x + width;
                yOut = yCenter + width * Math.tan(alpha) / 2.0;
            } else {
                yOut = y + height;
                xOut = xCenter + height * Math.tan(beta) / 2.0;
            }
            return new Point2D.Double(xOut, yOut);
        }

        public Color getGradientColor() {
            return this.gradientColor;
        }

        public void setGradientColor(Color gradientColor) {
            this.gradientColor = gradientColor;
        }

        public boolean hasDashedBorder() {
            return this.dashedBorder;
        }

        public void setDashedBorder(boolean dashed) {
            this.dashedBorder = dashed;
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public void setBorderColor(Color color) {
            this.borderColor = color;
        }

        public boolean hasRoundedCorners() {
            return this.roundedCorners;
        }

        public void setRoundedCorners(boolean flag) {
            this.roundedCorners = flag;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public UmlGraphConstants.IconPosition getIconPosition() {
            return this.iconPosition;
        }

        public void setIconPosition(UmlGraphConstants.IconPosition position) {
            this.iconPosition = position;
        }

        public String getStereotype() {
            return this.stereotype;
        }

        public void setStereotype(String stereotype) {
            this.stereotype = stereotype;
        }

        public boolean getShowStereotypes() {
            return this.showStereotypes;
        }

        public void setShowStereotypes(boolean flag) {
            this.showStereotypes = flag;
        }

        public Long getRuntime() {
            return this.runtime;
        }

        public void setRuntime(Long runtime) {
            this.runtime = runtime;
        }

        private void setHorizontalAlignment(Map attributes) {
            this.stereotypeItem.setHorizontalAlignment(UmlGraphConstants.getStereotypeHorizontalAlignment(attributes));
            this.nameItem.setHorizontalAlignment(UmlGraphConstants.getHorizontalAlignment((Map)attributes));
        }

        private void setVerticalAlignment(Map attributes) {
            this.stereotypeItem.setVerticalAlignment(UmlGraphConstants.getStereotypeHorizontalAlignment(attributes));
            this.nameItem.setVerticalAlignment(UmlGraphConstants.getHorizontalAlignment((Map)attributes));
        }

        private void setHorizontalTextPosition(Map attributes) {
            this.stereotypeItem.setHorizontalTextPosition(UmlGraphConstants.getStereotypeHorizontalTextPosition(attributes));
            this.nameItem.setHorizontalTextPosition(UmlGraphConstants.getHorizontalTextPosition((Map)attributes));
        }

        private void setVerticalTextPosition(Map attributes) {
            this.stereotypeItem.setVerticalTextPosition(UmlGraphConstants.getStereotypeVerticalTextPosition(attributes));
            this.nameItem.setVerticalTextPosition(UmlGraphConstants.getVerticalTextPosition((Map)attributes));
        }

        private int getArcWidth() {
            return 25;
        }

        private int getArcHeight() {
            return 25;
        }
    }
}

