/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.hex.swing;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.fife.ui.hex.ByteBuffer;
import org.fife.ui.hex.swing.HexEditor;

public class HexTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private HexEditor editor;
    private ByteBuffer doc;
    private int bytesPerRow;
    private UndoManager undoManager;
    private String[] columnNames;
    private byte[] bitBuf = new byte[16];
    private char[] dumpColBuf;
    private String[] byteStrVals;

    public HexTableModel(HexEditor hexEditor, ResourceBundle resourceBundle) {
        int n;
        this.editor = hexEditor;
        this.doc = new ByteBuffer(16);
        this.bytesPerRow = 16;
        this.undoManager = new UndoManager();
        this.columnNames = new String[17];
        for (n = 0; n < 16; ++n) {
            this.columnNames[n] = "+" + Integer.toHexString(n).toUpperCase();
        }
        this.columnNames[16] = resourceBundle.getString("AsciiDump");
        this.dumpColBuf = new char[16];
        Arrays.fill(this.dumpColBuf, ' ');
        this.byteStrVals = new String[256];
        for (n = 0; n < this.byteStrVals.length; ++n) {
            this.byteStrVals[n] = Integer.toHexString(n);
        }
    }

    public byte getByte(int n) {
        return this.doc.getByte(n);
    }

    public int getByteCount() {
        return this.doc.getSize();
    }

    public int getBytesPerRow() {
        return this.bytesPerRow;
    }

    @Override
    public int getColumnCount() {
        return this.getBytesPerRow() + 1;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getRowCount() {
        return this.doc.getSize() / this.bytesPerRow + (this.doc.getSize() % this.bytesPerRow > 0 ? 1 : 0);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == this.bytesPerRow) {
            int n3 = this.editor.cellToOffset(n, 0);
            if (n3 == -1) {
                return "";
            }
            int n4 = this.doc.read(n3, this.bitBuf);
            for (int i = 0; i < n4; ++i) {
                int n5 = this.bitBuf[i];
                if (n5 < 32 || n5 > 126) {
                    n5 = 46;
                }
                this.dumpColBuf[i] = n5;
            }
            return new String(this.dumpColBuf, 0, n4);
        }
        int n6 = this.editor.cellToOffset(n, n2);
        return n6 == -1 ? "" : this.byteStrVals[this.doc.getByte(n6) & 0xFF];
    }

    public boolean redo() {
        boolean bl = this.undoManager.canRedo();
        if (bl) {
            this.undoManager.redo();
            bl = this.undoManager.canRedo();
        } else {
            UIManager.getLookAndFeel().provideErrorFeedback(this.editor);
        }
        return bl;
    }

    public void removeBytes(int n, int n2) {
        this.replaceBytes(n, n2, null);
    }

    public void replaceBytes(int n, int n2, byte[] byArray) {
        byte[] byArray2 = null;
        if (n2 > 0) {
            byArray2 = new byte[n2];
            this.doc.remove(n, n2, byArray2);
        }
        byte[] byArray3 = null;
        if (byArray != null && byArray.length > 0) {
            this.doc.insertBytes(n, byArray);
            byArray3 = (byte[])byArray.clone();
        }
        if (byArray2 != null || byArray3 != null) {
            this.undoManager.addEdit(new BytesReplacedUndoableEdit(n, byArray2, byArray3));
            this.fireTableDataChanged();
            int n3 = byArray3 == null ? 0 : byArray3.length;
            int n4 = byArray2 == null ? 0 : byArray2.length;
            this.editor.fireHexEditorEvent(n, n3, n4);
        }
    }

    public void setBytes(String string) throws IOException {
        this.doc = new ByteBuffer(string);
        this.undoManager.discardAllEdits();
        this.fireTableDataChanged();
        this.editor.fireHexEditorEvent(0, this.doc.getSize(), 0);
    }

    public void setBytes(InputStream inputStream) throws IOException {
        this.doc = new ByteBuffer(inputStream);
        this.undoManager.discardAllEdits();
        this.fireTableDataChanged();
        this.editor.fireHexEditorEvent(0, this.doc.getSize(), 0);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        byte by = (byte)Integer.parseInt((String)object, 16);
        int n3 = this.editor.cellToOffset(n, n2);
        if (n3 > -1) {
            byte by2 = this.doc.getByte(n3);
            if (by2 == by) {
                return;
            }
            this.doc.setByte(n3, by);
            this.undoManager.addEdit(new ByteChangedUndoableEdit(n3, by2, by));
            this.fireTableCellUpdated(n, n2);
            this.fireTableCellUpdated(n, this.bytesPerRow);
            this.editor.fireHexEditorEvent(n3, 1, 1);
        }
    }

    public boolean undo() {
        boolean bl = this.undoManager.canUndo();
        if (bl) {
            this.undoManager.undo();
            bl = this.undoManager.canUndo();
        } else {
            UIManager.getLookAndFeel().provideErrorFeedback(this.editor);
        }
        return bl;
    }

    private class BytesReplacedUndoableEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private int offs;
        private byte[] removed;
        private byte[] added;

        public BytesReplacedUndoableEdit(int n, byte[] byArray, byte[] byArray2) {
            this.offs = n;
            this.removed = byArray;
            this.added = byArray2;
        }

        @Override
        public void undo() {
            super.undo();
            if (HexTableModel.this.getByteCount() < this.offs) {
                throw new CannotUndoException();
            }
            this.removeAndAdd(this.added, this.removed);
        }

        @Override
        public void redo() {
            super.redo();
            if (HexTableModel.this.getByteCount() < this.offs) {
                throw new CannotRedoException();
            }
            this.removeAndAdd(this.removed, this.added);
        }

        private void removeAndAdd(byte[] byArray, byte[] byArray2) {
            int n = byArray == null ? 0 : byArray.length;
            int n2 = byArray2 == null ? 0 : byArray2.length;
            HexTableModel.this.doc.remove(this.offs, n);
            HexTableModel.this.doc.insertBytes(this.offs, byArray2);
            HexTableModel.this.fireTableDataChanged();
            int n3 = this.offs;
            if (byArray2 != null && byArray2.length > 0) {
                n3 += byArray2.length - 1;
            }
            HexTableModel.this.editor.setSelectedRange(this.offs, n3);
            HexTableModel.this.editor.fireHexEditorEvent(this.offs, n2, n);
        }
    }

    private class ByteChangedUndoableEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private int offs;
        private byte oldVal;
        private byte newVal;

        public ByteChangedUndoableEdit(int n, byte by, byte by2) {
            this.offs = n;
            this.oldVal = by;
            this.newVal = by2;
        }

        @Override
        public void undo() {
            super.undo();
            if (HexTableModel.this.getByteCount() < this.offs) {
                throw new CannotUndoException();
            }
            this.setValueImpl(this.offs, this.oldVal);
        }

        @Override
        public void redo() {
            super.redo();
            if (HexTableModel.this.getByteCount() < this.offs) {
                throw new CannotRedoException();
            }
            this.setValueImpl(this.offs, this.newVal);
        }

        private void setValueImpl(int n, byte by) {
            HexTableModel.this.editor.setSelectedRange(n, n);
            HexTableModel.this.doc.setByte(n, by);
            Point point = HexTableModel.this.editor.offsetToCell(n);
            HexTableModel.this.fireTableCellUpdated(point.x, point.y);
            HexTableModel.this.fireTableCellUpdated(point.x, HexTableModel.this.bytesPerRow);
            HexTableModel.this.editor.fireHexEditorEvent(n, 1, 1);
        }
    }
}

