/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.swing.QuestionDialog;
import ch.e2e.swing.filechooser.FileChooser;
import ch.e2e.swing.filechooser.FileQuestion;
import ch.e2e.swing.util.FileChooserFilter;
import java.io.File;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class SaveFileChooser
extends FileChooser {
    private QuestionDialog overwriteDialog;
    private QuestionDialog defaultOverwriteDialog;
    private FileQuestion question;
    private boolean autoextend;

    public SaveFileChooser(JFrame owner, String title, String internalTitle, String subtitle) {
        super(owner, title, internalTitle, subtitle);
    }

    public SaveFileChooser(JDialog owner, String title, String internalTitle, String subtitle) {
        super(owner, title, internalTitle, subtitle);
    }

    public SaveFileChooser(JFrame owner, String title, String internalTitle, String subtitle, Icon icon) {
        super(owner, title, internalTitle, subtitle, icon);
    }

    public SaveFileChooser(JDialog owner, String title, String internalTitle, String subtitle, Icon icon) {
        super(owner, title, internalTitle, subtitle, icon);
    }

    public void createOverwriteDialog(String title, String internalTitle, String subtitle, Icon icon) {
        this.overwriteDialog = new QuestionDialog(this, title, internalTitle, subtitle, 0, icon);
        this.overwriteDialog.setLocale(this.getLocale());
    }

    public File saveFile(File selectedFile, boolean includeAllFiles, FileQuestion question) {
        return this.saveFile(selectedFile, includeAllFiles, question, false);
    }

    public File saveFile(File selectedFile, boolean includeAllFiles, FileQuestion question, boolean autoextend) {
        this.question = question;
        this.autoextend = autoextend;
        return this.selectFile(selectedFile, includeAllFiles);
    }

    @Override
    public boolean doOnOk() {
        if (this.fileTextField.getFiles().length > 0) {
            File selectedFile = this.fileTextField.getFiles()[0];
            if (this.autoextend) {
                selectedFile = this.checkFileExtension(selectedFile);
            }
            if (selectedFile.exists()) {
                if (this.overwriteDialog == null) {
                    return this.getDefaultOverwriteDialog().doQuestion(this.question.getQuestion(selectedFile));
                }
                return this.overwriteDialog.doQuestion(this.question.getQuestion(selectedFile));
            }
            return true;
        }
        return false;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.overwriteDialog != null) {
            this.overwriteDialog.setLocale(locale);
        }
        if (this.defaultOverwriteDialog != null) {
            this.defaultOverwriteDialog.setLocale(locale);
        }
    }

    private File checkFileExtension(File selectedFile) {
        String absolutePath = selectedFile.getAbsolutePath();
        FileChooserFilter selectedFilter = this.getSelectedFileFilter();
        if (!absolutePath.toLowerCase().endsWith(selectedFilter.getExtension().toLowerCase())) {
            absolutePath = absolutePath + selectedFilter.getExtension();
            selectedFile = new File(absolutePath);
            this.fileTextField.setText(selectedFile.getName());
        }
        return selectedFile;
    }

    private QuestionDialog getDefaultOverwriteDialog() {
        if (this.defaultOverwriteDialog == null) {
            this.defaultOverwriteDialog = new QuestionDialog(this, "", "", "", 0, null);
            this.defaultOverwriteDialog.setLocale(this.getLocale());
        }
        return this.defaultOverwriteDialog;
    }
}

