/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.io.FileUtilities;
import ch.e2e.swing.document.DirectoryTextFieldDocument;
import ch.e2e.swing.event.DirectorySelectedEvent;
import ch.e2e.swing.event.DirectorySelectedEventMulticaster;
import ch.e2e.swing.event.DirectorySelectedListener;
import ch.e2e.swing.filechooser.FileTextField;
import ch.e2e.swing.model.Directory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class DirectoryField
extends FileTextField
implements ActionListener {
    private DirectorySelectedListener directoryListener;
    private Directory root;

    public DirectoryField() {
        super(new DirectoryTextFieldDocument());
        this.addActionListener(this);
    }

    public void setRoot(File root) {
        this.setRoot(Directory.getDirectory(root));
    }

    public void setRoot(Directory root) {
        if (root == null || root.getDir() == null) {
            root = null;
            ((DirectoryTextFieldDocument)this.getDocument()).setRelative(false);
        } else {
            ((DirectoryTextFieldDocument)this.getDocument()).setRelative(true);
            this.root = root;
        }
        this.setText(this.getSelectedDirectory());
    }

    @Override
    public void setSelectedDirectory(Directory selectedDirectory) {
        if (this.setText(selectedDirectory)) {
            super.setSelectedDirectory(selectedDirectory);
        }
    }

    public boolean setText(Directory selectedDirectory) {
        boolean result = true;
        String path = "";
        if (selectedDirectory != null) {
            if (this.root != null && selectedDirectory.getDir() != null) {
                String relativePath = FileUtilities.getRelativePath((File)selectedDirectory.getDir(), (File)this.root.getDir());
                if (new File(relativePath).isAbsolute()) {
                    result = false;
                } else if (relativePath.endsWith("/") || relativePath.endsWith("\\")) {
                    path = relativePath.substring(0, relativePath.length() - 1);
                }
            } else if (selectedDirectory.getDir() != null) {
                path = selectedDirectory.getDir().getAbsolutePath();
            }
        }
        if (result) {
            this.setText(path);
        }
        return result;
    }

    @Override
    public Directory getSelectedDirectory() {
        Directory result = null;
        if (this.root == null) {
            result = this.getText().length() == 0 ? super.getSelectedDirectory() : (super.getSelectedDirectory() == null ? this.createResult(new File("")) : this.createResult(super.getSelectedDirectory().getDir()));
        } else if (this.getText().length() == 0) {
            if (this.root.getDir() != null) {
                result = this.root;
            }
        } else {
            result = this.createResult(this.root.getDir());
        }
        return result;
    }

    private Directory createResult(File file) {
        File f = new File(this.getText());
        if (!f.isAbsolute()) {
            f = file == null ? f.getAbsoluteFile() : new File(file, f.getPath());
        }
        Directory result = Directory.getDirectory(f);
        return result;
    }

    public void addDirectorySelectedListener(DirectorySelectedListener listener) {
        this.directoryListener = DirectorySelectedEventMulticaster.addListener(this.directoryListener, listener);
    }

    public void removeFileSelectedListener(DirectorySelectedListener listener) {
        this.directoryListener = DirectorySelectedEventMulticaster.removeListener(this.directoryListener, listener);
    }

    @Override
    public File[] getFiles() {
        File[] result = new File[1];
        if (this.getText().length() > 0) {
            result[0] = new File(this.getText());
            if (!result[0].isAbsolute()) {
                result[0] = new File(this.selectedDirectory.getDir(), this.getText());
            }
        } else {
            result[0] = this.selectedDirectory.getDir();
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.fireDirectorySelected();
    }

    private void fireDirectorySelected() {
        if (this.directoryListener != null) {
            DirectorySelectedEvent event = new DirectorySelectedEvent(this, Directory.getDirectory(this.getFiles()[0]));
            this.directoryListener.directorySelected(event);
        }
    }
}

