/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.VerticalLabel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class VerticalLabelUI
extends ComponentUI
implements PropertyChangeListener {
    private Font font = UIManager.getDefaults().getFont("Label.font");

    private VerticalLabelUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new VerticalLabelUI();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = c.getFontMetrics(this.font);
        int width = fm.stringWidth(((VerticalLabel)c).getText()) + 2;
        int height = fm.getHeight() + 2;
        Insets insets = c.getInsets();
        Dimension preferredSize = new Dimension(height + insets.left + insets.right, width + insets.top + insets.bottom);
        return preferredSize;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int width = fm.stringWidth(((VerticalLabel)c).getText());
        int height = fm.getHeight();
        Insets insets = c.getInsets();
        Dimension minimumSize = new Dimension(height + insets.left + insets.right, width + insets.top + insets.bottom);
        return minimumSize;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        VerticalLabel label = (VerticalLabel)c;
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Insets insets = c.getInsets();
        int strWidth = fm.stringWidth(((VerticalLabel)c).getText());
        int strHeight = fm.getHeight();
        int width = size.width - insets.right - insets.left;
        int height = size.height - insets.top - insets.bottom;
        int xPos = (width - strHeight) / 2 + insets.left;
        int yPos = (height - strWidth) / 2 + insets.top;
        Font f = c.getFont().deriveFont(label.getAffineTransform());
        g.setFont(f);
        g.setColor(c.getForeground());
        g.drawString(label.getText(), xPos, yPos);
    }

    @Override
    public void installUI(JComponent c) {
        this.installDefaults((VerticalLabel)c);
        this.installListeners((VerticalLabel)c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners((VerticalLabel)c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if (name.equals("font")) {
            this.font = (Font)event.getNewValue();
        }
    }

    private void installDefaults(VerticalLabel c) {
        LookAndFeel.installColorsAndFont(c, "Label.background", "Label.foreground", "Label.font");
    }

    private void installListeners(VerticalLabel c) {
        c.addPropertyChangeListener(this);
    }

    private void uninstallListeners(VerticalLabel c) {
        c.removePropertyChangeListener(this);
    }
}

