/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.eal;

import ch.e2e.builder.eal.EALStatementCompletion;
import ch.e2e.builder.eal.Token;
import java.util.Arrays;

public class EALToken {
    private Category category;
    private Token token;
    private EALStatementCompletion[] completions;
    private int type;
    private int index;

    public EALToken(Category category, Token token, EALStatementCompletion completion, Integer type) {
        this.category = category;
        this.token = token;
        this.completions = new EALStatementCompletion[]{completion};
        this.type = type == null ? 0 : type;
    }

    public EALToken(Category category, Token token, EALStatementCompletion[] completions, Integer type) {
        this.category = category;
        this.token = token;
        this.completions = completions;
        this.type = type == null ? 0 : type;
    }

    public EALToken(Category category, Token token, Integer type) {
        this(category, token, new EALStatementCompletion[0], type);
    }

    public EALToken(Category category, Token token, EALStatementCompletion completion) {
        this(category, token, completion, null);
    }

    public EALToken(Category category, Token token, EALStatementCompletion[] completions) {
        this(category, token, completions, null);
    }

    public EALToken(Category category, Token token) {
        this(category, token, new EALStatementCompletion[0], null);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getType() {
        return this.type;
    }

    public Token getToken() {
        return this.token;
    }

    public EALStatementCompletion[] getCompletions() {
        return this.completions;
    }

    public int getBeginLine() {
        return this.token.beginLine;
    }

    public int getBeginColumn() {
        return this.token.beginColumn;
    }

    public int getEndColumn() {
        return this.token.endColumn;
    }

    public String getImage() {
        return this.token.image;
    }

    public String toString() {
        return (Object)((Object)this.category) + " " + this.token.toString();
    }

    public int hashCode() {
        return this.getToken().hashCode();
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof EALToken) {
            equal = this.getToken().equals(((EALToken)obj).getToken());
        }
        return equal;
    }

    public class Type {
        public static final int UNKNOWN = 0;
        public static final int IN = 1;
        public static final int OUT = 2;
        public static final int LOCAL = 4;
        public static final int OPERATION = 8;
        public static final int DEPENDENCY = 16;
        public static final int INOUT = 3;
        public static final int RHS = 15;
        public static final int LHS = 3;
    }

    public static enum Category {
        COMMENT,
        CONSTANT,
        DEFAULT,
        FUNCTION,
        IDENTIFIER,
        KEYWORD,
        LINK,
        MACRO,
        NUMBER,
        OPERATION,
        OPERATOR,
        STRING;

        private static final String[] operations;
        private static final String[] macros;
        private static final String[] functions;

        public static Category getCategory(Token token, Category defaultCategory) {
            Category category = defaultCategory;
            String image = token.image;
            if (Arrays.asList(macros).contains(image)) {
                category = MACRO;
            } else if (Arrays.asList(functions).contains(image)) {
                category = FUNCTION;
            } else if (Arrays.asList(operations).contains(image)) {
                category = OPERATION;
            }
            return category;
        }

        static {
            operations = new String[]{"blobLength", "classToXML", "concat", "concatBlob", "condition", "convertDurationToDateTime", "convertBase64ToBlob", "convertToBoolean", "convertToDateTime", "convertToFloat", "convertToInteger", "convertToString", "copy", "count", "escapeURI", "exists", "findPattern", "findPatterns", "findString", "match", "not", "normalizeSpaces", "padLeft", "padRight", "parseDateTimeExpression", "printDateTimeExpression", "replace", "split", "stringLength", "subblob", "substring", "substringAfter", "substringBefore", "toLower", "toUpper", "transcodeToBlob", "transcodeToString", "unescapeURI", "xmlToClass"};
            macros = new String[]{"mapAttributes", "getConfigurationHost", "getConfigurationName", "getEncodingFromAlias", "getHostFromAlias", "getMethodFromAlias", "getPathFromAlias", "getPortFromAlias", "getProtocolFromAlias", "getResourceNameFromAlias", "getResourceTypeFromAlias", "getUrlFromAlias", "getUserFromAlias", "setting", "text"};
            functions = new String[]{"getError", "getErrors", "getPrincipal", "getServiceContext", "getServiceContextValue", "currentDateTime", "currentTimeTicks", "createUniqueId", "getSequenceNumber", "getTimestamp"};
        }
    }
}

