/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test.utils;

import ch.e2e.dom.DomUtilities;
import ch.e2e.test.E2EComparisonController;
import ch.e2e.test.E2EDiff;
import ch.e2e.test.E2EDifferenceEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Assert;

public class AssertFoldersEqual {
    private static Map<String, File> getFileMap(File folder, Set<String> ignorePatterns) throws IOException {
        Path folderPath = folder.toPath();
        try (Stream<Path> paths = Files.walk(folderPath, new FileVisitOption[0]);){
            Map<String, File> map = paths.filter(path -> ignorePatterns.stream().noneMatch(AssertFoldersEqual.toRelativePath(folderPath, path)::matches)).collect(Collectors.toMap(path -> AssertFoldersEqual.toRelativePath(folderPath, path), Path::toFile));
            return map;
        }
    }

    private static String toRelativePath(Path folderPath, Path path) {
        return folderPath.relativize(path).toString().replace(System.getProperty("file.separator"), "/");
    }

    public static void assertFoldersEqual(File folder, File refFolder) throws Exception {
        AssertFoldersEqual.assertFoldersEqual("", folder, refFolder);
    }

    public static void assertFoldersEqual(File folder, File refFolder, Options options) throws Exception {
        AssertFoldersEqual.assertFoldersEqual("", folder, refFolder, options);
    }

    public static void assertFoldersEqual(String message, File folder, File refFolder) throws Exception {
        AssertFoldersEqual.assertFoldersEqual(message, folder, refFolder, new Options());
    }

    public static void assertFoldersEqual(String message, File folder, File refFolder, Options options) throws Exception {
        Assert.assertTrue((String)(message + " -> missing folder: " + folder.getAbsolutePath()), (boolean)folder.exists());
        Assert.assertTrue((String)(message + " -> missing folder: " + refFolder.getAbsolutePath()), (boolean)folder.exists());
        Map<String, File> refFiles = AssertFoldersEqual.getFileMap(refFolder, options.fileIgnorePatterns);
        Map<String, File> resFiles = AssertFoldersEqual.getFileMap(folder, options.fileIgnorePatterns);
        for (Map.Entry<String, File> entry : refFiles.entrySet()) {
            File refFile = entry.getValue();
            String key = entry.getKey();
            if (resFiles.get(key) == null) {
                Assert.fail((String)(message + " -> missing entry: " + key));
                continue;
            }
            if (refFile.isDirectory() && !resFiles.get(key).isDirectory() || !refFile.isDirectory() && resFiles.get(key).isDirectory()) {
                Assert.fail((String)(message + " -> directory mismatch: " + key));
            } else if (!refFile.isDirectory()) {
                boolean doXmlAssert = false;
                for (String ext : options.xmlAssertExtensions) {
                    if (!refFile.getName().endsWith(ext)) continue;
                    doXmlAssert = true;
                    break;
                }
                if (doXmlAssert) {
                    E2EComparisonController controller = new E2EComparisonController();
                    E2EDiff importDiff = new E2EDiff(DomUtilities.parse((File)refFile, (boolean)false, (boolean)false), DomUtilities.parse((File)resFiles.get(key), (boolean)false, (boolean)false), new E2EDifferenceEngine(controller, options.xmlIgnoreAttributes, options.xmlIgnoreElements), key);
                    importDiff.identical();
                    XMLAssert.assertXMLIdentical((String)("XML not equal for " + key), (Diff)importDiff, (boolean)true);
                } else if (refFile.getName().endsWith(".zip")) {
                    Map<String, byte[]> refZipContent = AssertFoldersEqual.unzip(refFile);
                    Map<String, byte[]> resFileZipContent = AssertFoldersEqual.unzip(refFiles.get(key));
                    Assert.assertEquals((String)(message + " -> zip entries not equal: " + key), (long)refZipContent.size(), (long)resFileZipContent.size());
                    Assert.assertTrue((String)(message + " -> zip entries not equal: " + key), (boolean)refZipContent.entrySet().stream().allMatch(e -> Arrays.equals((byte[])e.getValue(), (byte[])resFileZipContent.get(e.getKey()))));
                } else {
                    Assert.assertEquals((String)(message + " -> entries not equal: " + key), (Object)FileUtils.readLines((File)refFile), (Object)FileUtils.readLines((File)resFiles.get(key)));
                }
            }
            resFiles.remove(key);
        }
        for (Map.Entry<String, File> entry : resFiles.entrySet()) {
            if (entry.getValue().isDirectory()) continue;
            Assert.fail((String)(message + " -> additional entry: " + entry.getKey()));
        }
    }

    private static Map<String, byte[]> unzip(File file) {
        HashMap<String, byte[]> zipContent = new HashMap<String, byte[]>();
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String filename = zipEntry.getName().replace(System.getProperty("file.separator"), "/");
                if (zipEntry.isDirectory()) {
                    zipContent.put(file.toPath().resolve(filename).toString(), null);
                    continue;
                }
                zipContent.put(file.toPath().resolve(filename).toString(), IOUtils.toByteArray((InputStream)zipInputStream));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return zipContent;
    }

    public static class Options {
        public Set<String> fileIgnorePatterns = new HashSet<String>();
        public Collection<String> xmlAssertExtensions = new HashSet<String>();
        public Collection<String> xmlIgnoreAttributes = new HashSet<String>();
        public Collection<String> xmlIgnoreElements = new HashSet<String>();
    }
}

