/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.project;

import ch.e2e.builder.base.project.ValueInstantiationException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ValueFactory {
    private ValueFactory() {
    }

    public static Object createValue(Element entry, File projectHome) throws ValueInstantiationException {
        String className = entry.getAttribute("type");
        try {
            Class<?> type = Class.forName(className);
            Object value = type.isArray() ? ValueFactory.readArray(type, entry.getChildNodes(), projectHome) : ValueFactory.createValue(entry, type, projectHome);
            return value;
        }
        catch (ClassNotFoundException cnfEx) {
            throw new ValueInstantiationException("Class " + className + "could not be found.", cnfEx);
        }
    }

    private static Object createValue(Element entry, Class<?> type, File projectHome) throws ValueInstantiationException {
        Object value;
        try {
            try {
                Constructor<?> constructor = type.getConstructor(Element.class);
                value = constructor.newInstance(entry);
            }
            catch (NoSuchMethodException e1) {
                try {
                    Constructor<?> constructor = type.getConstructor(String.class);
                    String valueStr = ValueFactory.readText(entry);
                    value = constructor.newInstance(ValueFactory.readText(entry));
                    if (value instanceof File) {
                        value = ValueFactory.getProjectFile((File)value, valueStr.replace("\\", "/"), projectHome);
                    }
                }
                catch (NoSuchMethodException e2) {
                    throw new ValueInstantiationException("No constructor with one org.w3c.dom.Element or one String parameter found in " + type.getName(), e2);
                }
            }
        }
        catch (Exception ie) {
            throw new ValueInstantiationException("Exception during initializing " + type.getName(), ie);
        }
        return value;
    }

    private static Object readArray(Class<?> type, NodeList childNodes, File projectHome) throws ValueInstantiationException {
        Object array = null;
        if (childNodes != null) {
            int elementCount = ValueFactory.getElementCount(childNodes);
            array = Array.newInstance(type.getComponentType(), elementCount);
            int index = 0;
            int length = childNodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = childNodes.item(i);
                if (!(node instanceof Element)) continue;
                Element entry = (Element)node;
                Array.set(array, index, ValueFactory.createValue(entry, type.getComponentType(), projectHome));
                ++index;
            }
        }
        return array;
    }

    private static int getElementCount(NodeList childNodes) {
        int elementCount = 0;
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            ++elementCount;
        }
        return elementCount;
    }

    public static File getProjectFile(File file, String filename, File projectHome) {
        if (!file.isAbsolute()) {
            try {
                file = new File(projectHome, filename).getCanonicalFile();
            }
            catch (IOException ioEx) {
                file = new File(projectHome, filename);
            }
        }
        return file;
    }

    public static Object createValueObject(String value, Class<?> type) throws ValueInstantiationException {
        Object result;
        try {
            Constructor<?> constructor = type.getConstructor(String.class);
            Object[] values = new String[]{value};
            result = constructor.newInstance(values);
        }
        catch (NoSuchMethodException ex) {
            throw new ValueInstantiationException("No constructor with one String parameter found in " + type.getName(), ex);
        }
        catch (Exception ex) {
            throw new ValueInstantiationException("Exception during initializing " + type.getName(), ex);
        }
        return result;
    }

    private static String readText(Element entry) {
        String result = null;
        if (entry.getChildNodes().getLength() == 1 && entry.getFirstChild() instanceof Text) {
            result = entry.getFirstChild().getNodeValue();
        } else if (entry.getChildNodes().getLength() == 0) {
            result = "";
        }
        return result;
    }
}

