/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.project;

import ch.e2e.builder.base.project.ProjectConstants;
import ch.e2e.builder.base.project.ProjectInstantiationException;
import ch.e2e.builder.base.project.ProjectReader;
import ch.e2e.builder.base.project.ProjectSettingObject;
import ch.e2e.builder.base.project.ProjectSettingObjectMap;
import ch.e2e.builder.base.project.ProjectSettingObjectWSChecker;
import ch.e2e.builder.base.project.ProjectValue;
import ch.e2e.builder.base.project.ValueFactory;
import ch.e2e.io.FileUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;

public final class E2EBuilderProject {
    private static final String systemUser = System.getProperty("user.name");
    private final HashMap<String, ProjectSettingObjectMap> settings;
    private HashMap<String, ProjectSettingObjectWSChecker> settingWSCheckers = new HashMap();
    private VetoableChangeListener listener;
    private File projectFile;
    private final File projectWorkspaceFile;
    private boolean isNew;

    public void putSettingWSChecker(String module, ProjectSettingObjectWSChecker checker) {
        this.settingWSCheckers.put(module, checker);
    }

    public static String getProjectFolderName() {
        return System.getProperty("ch.e2e.builder.base.home");
    }

    public static void setProjectFolderName(String projectFolder) {
        System.setProperty("ch.e2e.builder.base.home", projectFolder);
    }

    public E2EBuilderProject(File projectHome) throws ProjectInstantiationException {
        this(projectHome, true);
    }

    public E2EBuilderProject(File projectHome, boolean exportSystemValues) throws ProjectInstantiationException {
        this(projectHome, exportSystemValues, null);
    }

    public E2EBuilderProject(File projectHome, HashMap<String, ProjectSettingObjectWSChecker> settingWSCheckers) throws ProjectInstantiationException {
        this(projectHome, true, settingWSCheckers);
    }

    public E2EBuilderProject(File projectHome, boolean exportSystemValues, HashMap<String, ProjectSettingObjectWSChecker> settingWSCheckers) throws ProjectInstantiationException {
        String userName;
        this.projectFile = new File(projectHome, ".e2ebuilder");
        this.projectWorkspaceFile = new File(projectHome, ".$e2ebuilderWorkspace");
        this.settingWSCheckers = settingWSCheckers;
        if (this.settingWSCheckers == null) {
            this.settingWSCheckers = new HashMap();
        }
        E2EBuilderProject.setProjectFolderName(projectHome.getAbsolutePath());
        if (this.projectFile.exists()) {
            this.settings = ProjectReader.readSettings(this.settingWSCheckers, this.projectFile, this.projectWorkspaceFile, exportSystemValues);
            this.isNew = false;
            userName = this.getGenericValue("author", System.getProperty("user.name"));
        } else {
            this.settings = new HashMap();
            this.isNew = true;
            userName = systemUser;
            if (exportSystemValues) {
                this.exportSystemValues();
            }
        }
        if (exportSystemValues) {
            System.setProperty("user.name", userName);
        }
    }

    private void exportSystemValues() {
        File projectHome = this.projectFile.getParentFile();
        for (ProjectValue projectValue : ProjectConstants.GENERIC_VALUES) {
            try {
                Object value = ValueFactory.createValueObject(projectValue.getValue(), projectValue.getClazz());
                if (value instanceof File) {
                    value = ValueFactory.getProjectFile((File)value, projectValue.getValue(), projectHome);
                }
                System.setProperty(projectValue.getKey(), String.valueOf(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public HashMap<String, ProjectSettingObjectMap> getSettings() {
        return this.settings;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public File getProjectWorkspaceFile() {
        return this.projectWorkspaceFile;
    }

    public void setPropertyChangeListener(VetoableChangeListener listener) {
        this.listener = listener;
    }

    public void removePropertyChangeListener() {
        this.listener = null;
    }

    public void setName(String name) throws PropertyVetoException {
        this.setGenericValue("name", name);
    }

    public String getName() {
        return this.getGenericValue("name", "New Project");
    }

    public void setDescription(String description) throws PropertyVetoException {
        this.setGenericValue("description", description);
    }

    public String getDescription() {
        return this.getGenericValue("description", "");
    }

    public void setAuthor(String author) throws PropertyVetoException {
        this.setGenericValue("author", author);
        System.setProperty("user.name", author);
    }

    public String getAuthor() {
        return this.getGenericValue("author", System.getProperty("user.name"));
    }

    public File getProjectHome() {
        return (File)this.getGenericValue("home", (Object)null);
    }

    public void setProjectHome(File projectHome) throws PropertyVetoException {
        this.projectFile = new File(projectHome, ".e2ebuilder");
        File oldProjectHome = this.get("generic", "home", this.projectFile);
        if (this.setGenericValue("home", projectHome)) {
            E2EBuilderProject.setProjectFolderName(projectHome.getAbsolutePath());
            this.checkAllFiles(oldProjectHome, projectHome);
        }
    }

    public boolean hasProperty(String key) {
        return this.hasProperty("generic", key);
    }

    public boolean hasProperty(String module, String key) {
        return this.getSettings(module).containsKey(key);
    }

    public void removeProperty(String key) {
        this.removeProperty("generic", key);
    }

    public void removeProperty(String module, String key) {
        if (this.hasProperty(module, key)) {
            ProjectSettingObjectMap moduleSettings = this.getSettings(module);
            moduleSettings.remove(key);
        }
    }

    public ProjectSettingObjectMap getGenericValues() {
        return this.getSettings("generic");
    }

    public boolean setGenericValue(String key, boolean value) throws PropertyVetoException {
        return this.setGenericValue(key, (Object)value);
    }

    public boolean getGenericValue(String key, boolean defaultValue) {
        return (Boolean)this.get("generic", key, (Object)defaultValue);
    }

    public boolean setGenericValue(String key, int value) throws PropertyVetoException {
        return this.setGenericValue(key, (Object)value);
    }

    public int getGenericValue(String key, int defaultValue) {
        return (Integer)this.get("generic", key, (Object)defaultValue);
    }

    public boolean setGenericValue(String key, double value) throws PropertyVetoException {
        return this.setGenericValue(key, (Object)value);
    }

    public double getGenericValue(String key, double defaultValue) {
        return (Double)this.get("generic", key, (Object)defaultValue);
    }

    public String getGenericValue(String key, String defaultValue) {
        return this.get("generic", key, defaultValue);
    }

    public boolean setGenericValue(String key, Object value) throws PropertyVetoException {
        if (value instanceof File) {
            value = ValueFactory.getProjectFile((File)value, value.toString(), this.projectFile.getParentFile());
        }
        System.setProperty(key, String.valueOf(value));
        return this.set("generic", key, value);
    }

    public Object getGenericValue(String key, Object defaultValue) {
        return this.get("generic", key, defaultValue);
    }

    public File getGenericFolder(String key) {
        return this.get("generic", key, (File)null);
    }

    public boolean set(String module, String key, boolean value) throws PropertyVetoException {
        return this.set(module, key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean set(String module, String key, int value) throws PropertyVetoException {
        return this.set(module, key, (Object)value);
    }

    public boolean set(String module, String key, double value) throws PropertyVetoException {
        return this.set(module, key, (Object)value);
    }

    public boolean set(String module, String key, Object value) throws PropertyVetoException {
        boolean workspace;
        Object oldValue;
        boolean changed = false;
        ProjectSettingObjectMap moduleSettings = this.getSettings(module);
        ProjectSettingObject oldSetting = moduleSettings.getProjectSettingObject(key);
        Object object = oldValue = oldSetting != null ? oldSetting.getValue() : null;
        if (oldSetting != null) {
            workspace = oldSetting.getWorkspace();
        } else {
            ProjectSettingObjectWSChecker checker = this.settingWSCheckers.get(module);
            checker = checker != null ? checker : new ProjectSettingObjectWSChecker();
            workspace = checker.isWorkspace(key);
        }
        if (oldValue == null || !oldValue.equals(value)) {
            this.firePropertyChange(key, oldValue, value);
            moduleSettings.put(key, value, workspace);
            String prefix = ProjectSettingObjectMap.getModulePrefix(module);
            System.setProperty(prefix + key, value.toString());
            changed = true;
        }
        return changed;
    }

    public boolean get(String module, String key, boolean defaultValue) {
        return (Boolean)this.get(module, key, (Object)defaultValue);
    }

    public int get(String module, String key, int defaultValue) {
        return (Integer)this.get(module, key, (Object)defaultValue);
    }

    public double get(String module, String key, double defaultValue) {
        return (Double)this.get(module, key, (Object)defaultValue);
    }

    public String get(String module, String key, String defaultValue) {
        return (String)this.get(module, key, (Object)defaultValue);
    }

    public File get(String module, String key, File defaultFile, boolean relative) {
        if (relative && defaultFile != null) {
            defaultFile = new File(this.getProjectHome(), defaultFile.getPath());
        }
        return this.get(module, key, defaultFile);
    }

    public File get(String module, String key, File defaultFile) {
        if (defaultFile != null && !defaultFile.isAbsolute()) {
            throw new RuntimeException("File must be absolute.");
        }
        return (File)this.get(module, key, (Object)defaultFile);
    }

    public Object get(String module, String key, Object defaultValue) {
        ProjectSettingObjectMap moduleSettings = this.getSettings(module);
        ProjectSettingObject result = moduleSettings.getProjectSettingObject(key);
        if (result == null && defaultValue != null) {
            ProjectSettingObjectWSChecker checker = this.settingWSCheckers.get(module);
            checker = checker != null ? checker : new ProjectSettingObjectWSChecker();
            result = new ProjectSettingObject(defaultValue, checker.isWorkspace(key));
            moduleSettings.putSettingObject(key, result);
        }
        return result != null ? result.getValue() : null;
    }

    public boolean createProjectFolders() {
        Iterator<ProjectSettingObjectMap> settings = this.settings.values().iterator();
        boolean result = true;
        while (settings.hasNext()) {
            ProjectSettingObjectMap moduleSettings = settings.next();
            for (ProjectSettingObject setting : moduleSettings.values()) {
                if (!(setting.getValue() instanceof File) || ((File)setting.getValue()).exists()) continue;
                result &= ((File)setting.getValue()).mkdirs();
            }
        }
        return result;
    }

    private ProjectSettingObjectMap getSettings(String module) {
        ProjectSettingObjectMap moduleSettings = this.settings.get(module);
        if (moduleSettings == null) {
            moduleSettings = new ProjectSettingObjectMap();
            this.settings.put(module, moduleSettings);
        }
        return moduleSettings;
    }

    private void firePropertyChange(String key, Object oldValue, Object newValue) throws PropertyVetoException {
        PropertyChangeEvent event = new PropertyChangeEvent(this, key, oldValue, newValue);
        if (this.listener != null) {
            this.listener.vetoableChange(event);
        }
    }

    private void checkAllFiles(File oldProjectHome, File newProjectHome) {
        for (String module : this.settings.keySet()) {
            ProjectSettingObjectMap settings = this.settings.get(module);
            String prefix = ProjectSettingObjectMap.getModulePrefix(module);
            for (String key : settings.keySet()) {
                boolean inPath;
                ProjectSettingObject value;
                if (key.equals("home") || !((value = settings.getProjectSettingObject(key)).getValue() instanceof File) || !(inPath = FileUtilities.isInPath((File)((File)value.getValue()), (File)oldProjectHome))) continue;
                String relativePath = FileUtilities.getRelativePath((File)((File)value.getValue()), (File)oldProjectHome);
                File newFile = new File(newProjectHome, relativePath);
                settings.put(key, newFile);
                System.setProperty(prefix + key, newFile.getAbsolutePath());
            }
        }
    }

    public static String locateProjectHome(File projectFile) {
        File parentFile = projectFile.getParentFile();
        File builderProject = new File(parentFile, ".e2ebuilder");
        while (!builderProject.exists() && parentFile != null) {
            if ((parentFile = parentFile.getParentFile()) == null) continue;
            builderProject = new File(parentFile, ".e2ebuilder");
        }
        if (builderProject.exists()) {
            return parentFile.getAbsolutePath();
        }
        return new File("").getAbsolutePath();
    }
}

