/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.secure;

import ch.e2e.secure.Logging;
import ch.e2e.secure.TrustQuestion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class UntrustedTrustManager
implements X509TrustManager,
Logging {
    private char[] password;
    private File keystore = null;
    private TrustQuestion trustQuestion;
    private X509TrustManager originalManager = null;

    public UntrustedTrustManager(File keystore, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException {
        this.keystore = keystore;
        this.password = password.toCharArray();
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init((KeyStore)null);
        TrustManager[] tm = factory.getTrustManagers();
        if (tm != null && tm.length > 0 && tm[0] instanceof X509TrustManager) {
            this.originalManager = (X509TrustManager)tm[0];
        }
        if (this.originalManager == null) {
            String msg = "Could not get original TrustManager!";
            logger.severe(msg);
            throw new CertificateException(msg);
        }
    }

    public void setTrustQuestion(TrustQuestion trustQuestion) {
        this.trustQuestion = trustQuestion;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain != null && chain.length > 0) {
            try {
                this.originalManager.checkServerTrusted(chain, authType);
            }
            catch (Throwable t) {
                this.checkOwnCertificate(chain, t.getMessage());
            }
        }
    }

    public X509TrustManager getOriginalManager() {
        return this.originalManager;
    }

    private void checkOwnCertificate(X509Certificate[] chain, String exception) throws CertificateException {
        if (this.keystoreNotExists(chain) && this.trustQuestion != null) {
            int trustResult = this.trustQuestion.trust(chain);
            switch (trustResult) {
                case 100: {
                    logger.fine("continue");
                    break;
                }
                case 101: {
                    logger.fine("trust & continue");
                    this.saveKeyStore(chain);
                    break;
                }
                default: {
                    logger.fine("cancel/close");
                    throw new CertificateException(exception);
                }
            }
        }
    }

    private void saveKeyStore(X509Certificate[] chain) {
        try {
            KeyStore ks = this.loadKeyStore(this.keystore, this.password);
            if (ks != null) {
                ks.setCertificateEntry(chain[0].getSubjectDN().getName(), chain[0]);
                this.saveKeyStore(this.keystore, this.password, ks);
            }
        }
        catch (KeyStoreException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private boolean keystoreNotExists(X509Certificate[] chain) {
        boolean result = true;
        try {
            X509Certificate stored;
            KeyStore ks = this.loadKeyStore(this.keystore, this.password);
            if (ks != null && ks.containsAlias(chain[0].getSubjectDN().getName()) && ((stored = (X509Certificate)ks.getCertificate(chain[0].getSubjectDN().getName())) == null || !stored.equals(chain[0]))) {
                result = false;
            }
        }
        catch (Exception e) {
            logger.fine("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            result = false;
        }
        return result;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.originalManager.getAcceptedIssuers();
    }

    public boolean isClientTrusted(X509Certificate[] x509Certificates) {
        return false;
    }

    public boolean isServerTrusted(X509Certificate[] x509Certificates) {
        return false;
    }

    private KeyStore loadKeyStore(File keystore, char[] passwd) {
        KeyStore result = null;
        try {
            result = KeyStore.getInstance("JKS");
            if (keystore.isFile()) {
                FileInputStream in = new FileInputStream(keystore);
                result.load(in, passwd);
                ((InputStream)in).close();
                logger.fine("loaded");
            } else {
                result.load(null, passwd);
                logger.fine("created");
            }
        }
        catch (Exception e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
        }
        return result;
    }

    private void saveKeyStore(File keystore, char[] passwd, KeyStore data) {
        try {
            FileOutputStream out = new FileOutputStream(keystore);
            data.store(out, passwd);
            ((OutputStream)out).close();
            logger.fine("stored");
        }
        catch (Exception e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
        }
    }
}

