/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.tools;

import java.util.HashMap;

public class TypeMapper {
    public static final String ARRAY = "Array";
    public static final String BASE64BINARY = "base64Binary";
    public static final String BOOLEAN = "boolean";
    public static final String DATETIME = "datetime";
    public static final String DATE = "date";
    public static final String FLOAT = "float";
    public static final String INT = "int";
    public static final String INTEGER = "integer";
    public static final String STRING = "string";
    public static final String SOAP_ENC_ARRAY = "http://schemas.xmlsoap.org/soap/encoding/:Array";
    public static final String URI_SCHEMA_PREFIX = "http://www.w3.org/2001/XMLSchema:";
    public static final int URI_SCHEMA_PREFIX_LENGTH = "http://www.w3.org/2001/XMLSchema:".length();

    public static String xsd2BridgeType(String type, HashMap uris) {
        String namespace;
        String uri;
        int namespaceIndex = type.indexOf(58);
        if (namespaceIndex != -1 && (uri = (String)uris.get(namespace = type.substring(0, namespaceIndex))) != null) {
            type = uri + type.substring(namespaceIndex);
        }
        if (type.startsWith(URI_SCHEMA_PREFIX)) {
            type = type.substring(URI_SCHEMA_PREFIX_LENGTH);
        }
        type = TypeMapper.xsd2BridgeType(type);
        return type;
    }

    public static String xsd2BridgeType(String type) {
        if (type.equals(STRING)) {
            type = "Base Types.String";
        } else if (type.equals(BASE64BINARY)) {
            type = "Base Types.Blob";
        } else if (type.equals(SOAP_ENC_ARRAY)) {
            type = "Base Types.Array";
        } else if (type.equals(BOOLEAN)) {
            type = "Base Types.Boolean";
        } else if (type.equalsIgnoreCase(DATETIME) || type.equalsIgnoreCase(DATE)) {
            type = "Base Types.DateTime";
        } else if (type.equals(FLOAT)) {
            type = "Base Types.Float";
        } else if (type.equals(INTEGER) || type.equals(INT)) {
            type = "Base Types.Integer";
        } else {
            int dashIndex = type.lastIndexOf(58);
            if (dashIndex != -1) {
                type = type.substring(dashIndex + 1);
            }
        }
        return type;
    }

    public static String bridgeType2XSD(String type) {
        if (type.equals("Base Types.String")) {
            type = "xsd:string";
        } else if (type.equals("Base Types.Blob")) {
            type = "xsd:base64Binary";
        } else if (type.equals("Base Types.Boolean")) {
            type = "xsd:boolean";
        } else if (type.equals("Base Types.DateTime")) {
            type = "xsd:datetime";
        } else if (type.equals("Base Types.Float")) {
            type = "xsd:float";
        } else if (type.equals("Base Types.Integer")) {
            type = "xsd:integer";
        }
        return type;
    }
}

