/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.trace.testcase.TreeObject;
import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.Catches;
import ch.e2e.builder.trace.testcase.uml.IOUmlObject;
import ch.e2e.builder.trace.testcase.uml.Message;
import ch.e2e.builder.trace.testcase.uml.State;
import ch.e2e.builder.trace.testcase.uml.StateTransition;
import ch.e2e.builder.trace.testcase.uml.UmlObjectFactory;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class UmlObject
extends TreeObject {
    private static final Pattern FQN_PATTERN = Pattern.compile("urn:([^\\.]+\\.)*([^\\.\\$]+)(\\$.*)?");
    protected UmlObject parent;
    protected String name;
    protected boolean error;
    private ErrorHandling errorHandling;
    private String originalName;
    private List<UmlObject> children = new ArrayList<UmlObject>();
    private int index = -1;
    private Map<String, String> attributes = new HashMap<String, String>();
    private String objectId;

    public UmlObject(File documentFile) throws IOException, ParserConfigurationException, SAXException {
        Element element = DomUtilities.parse((File)documentFile, (boolean)false, (boolean)false).getDocumentElement();
        this.init(element, documentFile.getParentFile());
    }

    public UmlObject(Element element, TraceContainer traceContainer) {
        this(element, element.getAttribute("name"), traceContainer);
    }

    public UmlObject(Element element, String name, TraceContainer traceContainer) {
        this(name);
        traceContainer.addNamespaces(element);
        this.setObjectId(element);
        this.initAttributes(element);
        this.read(element, traceContainer);
    }

    public UmlObject(Element element, File documentFolder) {
        this.init(element, documentFolder);
        this.objectId = element.getAttribute("objectId");
        if (this.objectId.length() == 0) {
            this.setObjectId(element);
        }
    }

    public UmlObject(Element element, String name) {
        this(name);
        this.objectId = element.getAttribute("objectId");
        if (this.objectId.length() == 0) {
            this.setObjectId(element);
        }
        this.initAttributes(element);
        this.read(element, (File)null);
    }

    UmlObject(String name) {
        this.name = this.createName(name);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setObjectId(Element element) {
        String objectId = XmiIDFactory.getInstance().getXmiID((Object)element, this.getClass().getSimpleName());
        this.setObjectId(objectId);
        element.setAttribute("objectId", objectId);
    }

    public String getName() {
        return this.name;
    }

    public String getIndicatedName() {
        String name = this.index == -1 ? this.getName() : this.getName() + '[' + this.index + ']';
        return name;
    }

    public void addChild(UmlObject child) {
        if (child != null) {
            child.setParent(this);
            this.children.add(child);
        }
    }

    public void removeChild(UmlObject child) {
        if (child != null) {
            child.setParent(null);
            this.children.remove(child);
        }
    }

    public UmlObject getParent() {
        return this.parent;
    }

    public Object getChild(int i) {
        return i < this.children.size() ? this.children.get(i) : null;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public int getIndexOfChild(Object child) {
        return this.children.indexOf(child);
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String toString() {
        String result = this.index == -1 ? this.getName() : this.getName() + '[' + this.index + ']';
        return result;
    }

    public int getType() {
        return this.error ? this.internalGetType() + 9999 : this.internalGetType();
    }

    public int internalGetType() {
        return 9999;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public UmlObject findChild(String originalName) {
        UmlObject result = null;
        int length = this.children.size();
        for (int i = 0; i < length && result == null; ++i) {
            UmlObject child = this.children.get(i);
            result = (child instanceof IOUmlObject || child instanceof State) && child.getFilename().equals(originalName) || child.getOriginalName().equals(originalName) ? child : child.findChild(originalName);
        }
        return result;
    }

    public List<State> getStates() {
        ArrayList<State> states = new ArrayList<State>();
        for (UmlObject child : this.children) {
            if (!(child instanceof StateTransition)) continue;
            states.addAll(child.getStates());
        }
        return states;
    }

    public <T> T getFirstChild(Class<T> type) {
        T result = null;
        int length = this.getChildCount();
        for (int i = 0; result == null && i < length; ++i) {
            Object child = this.getChild(i);
            if (!type.isInstance(child)) continue;
            result = type.cast(child);
        }
        return result;
    }

    public String getFilename() {
        return UmlObject.getFilename(this.getOriginalName());
    }

    public static String getFilename(String filename) {
        return filename.replaceAll("[/\\|:\\*?<>\"]", "_");
    }

    public boolean isGenerated() {
        return false;
    }

    protected void addChild(Element child, File documentFolder) {
        File childDocumentFile;
        String childName = child.getAttribute("name");
        if (child.hasAttribute("id")) {
            childName = childName + '_' + child.getAttribute("id");
        }
        if ((childDocumentFile = new File(documentFolder, UmlObject.getFilename(childName) + ".xml")).exists()) {
            this.addChild(UmlObjectFactory.createUmlObject(childDocumentFile));
        } else {
            this.addChild(UmlObjectFactory.createUmlObject(child, documentFolder));
        }
    }

    protected void addChild(Element child, TraceContainer traceContainer) {
        UmlObject umlObject = UmlObjectFactory.createUmlObject(child, traceContainer);
        if (umlObject instanceof Message) {
            this.error = true;
        }
        this.addChild(umlObject);
    }

    void setParent(UmlObject parent) {
        this.parent = parent;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    protected void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    void read(Element element, TraceContainer traceContainer) {
        Object child;
        int i;
        this.error = false;
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (i = 0; i < length; ++i) {
            child = children.item(i);
            if (!(child instanceof Element)) continue;
            this.addChild((Element)child, traceContainer);
        }
        if (this.error) {
            element.setAttribute("error", "true");
        }
        length = this.children.size();
        for (i = 0; i < length; ++i) {
            child = this.children.get(i);
            if (!((UmlObject)child).error) continue;
            this.error = true;
            element.setAttribute("error", "true");
        }
    }

    void read(Element element, File documentFolder) {
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            this.addChild((Element)child, documentFolder);
        }
    }

    private String createName(String name) {
        this.originalName = name;
        Matcher m = FQN_PATTERN.matcher(name);
        if (m.matches()) {
            name = m.group(2);
        } else {
            int index = name.indexOf("...");
            if (index != -1) {
                name = name.substring(0, index);
            }
            name = name.replace('_', ' ');
        }
        return name;
    }

    private void init(Element element, File documentFolder) {
        this.name = this.createName(element.getAttribute("name"));
        this.initAttributes(element);
        this.read(element, documentFolder);
    }

    private void initAttributes(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = attributes.item(i);
            this.attributes.put(node.getNodeName(), node.getNodeValue());
        }
    }

    public String getStereotype() {
        return this.getClass().getSimpleName();
    }

    public String getUmlLabel() {
        return this.toString();
    }

    public boolean hasErrors() {
        return this.error || Boolean.parseBoolean(this.getAttribute("error"));
    }

    public boolean hasCausedError() {
        return !this.children.isEmpty() && this.children.get(0) instanceof Message;
    }

    public Message findErrorMessage() {
        Message errorMessage = null;
        Iterator<UmlObject> iterator = this.children.iterator();
        while (errorMessage == null && iterator.hasNext()) {
            UmlObject next = iterator.next();
            if (next instanceof Message) {
                errorMessage = (Message)next;
                continue;
            }
            if (!next.hasErrors()) continue;
            iterator = next.children.iterator();
        }
        return errorMessage;
    }

    @Override
    public TreeObject getTreeParent() {
        return this.getParent();
    }

    public ErrorHandling getErrorHandling() {
        if (!this.hasErrors()) {
            return ErrorHandling.NO_ERROR;
        }
        if (this.errorHandling == null) {
            this.errorHandling = this.isErrorCaught(this) ? ErrorHandling.ERROR_CAUGHT : ErrorHandling.ERROR_NOT_CAUGHT;
        }
        return this.errorHandling;
    }

    private boolean isErrorCaught(UmlObject o) {
        UmlObject parent;
        while ((parent = o.getParent()) != null) {
            if (this.isErrorCaught(o, parent)) {
                return true;
            }
            o = parent;
        }
        return false;
    }

    private boolean isErrorCaught(UmlObject o, UmlObject parent) {
        int idx = parent.getIndexOfChild(o) + 1;
        UmlObject next = idx < parent.children.size() ? parent.children.get(idx) : null;
        return next instanceof Catches && ((Catches)next).getChildCount() < 2;
    }

    public static enum ErrorHandling {
        NO_ERROR,
        ERROR_CAUGHT,
        ERROR_NOT_CAUGHT;

    }
}

